###########################################################################
#
# docprint.pm
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

# This document processor prints a document out to STDOUT


package docprint;

use arcinfo;
use docproc;
use util;


sub BEGIN {
    @ISA = ('docproc');
}

sub new {
    my ($class) = @_;
    my $self = new docproc ();

    return bless $self, $class;
}

sub process {
    my $self = shift (@_);
    my ($doc_obj) = @_;

    # add associated files as metadata to the document
    my @assoc_files = ();
    foreach $assoc_file (@{$doc_obj->get_assoc_files()}) {
	if (-e $assoc_file->[0]) {
	    $doc_obj->add_metadata ($doc_obj->get_top_section(), 
				    "gsdlassocfile", 
				    "$assoc_file->[1]:$assoc_file->[2]");
	}
    }
    
    # output document
    $doc_obj->output_section(STDOUT, $doc_obj->get_top_section());
}


1;
