###########################################################################
#
# SectionList.pm --
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

# Same as List classifier but includes all sections of document
# (excluding top level) rather than just top level document 
# itself

package SectionList;

use List;
use sorttools;

sub BEGIN {
    @ISA = ('List');
}

sub print_usage {
    print STDERR "
  usage: classify SectionList [options]
  options:

   -metadata X    Metadata field used for classification,
                  list will be sorted by this element.

   -buttonname X  (optional) Title field for this classification.
                  if not included title field will be Metaname. 

   -sort X        (optional) Sort documents in list by this metadata field.
                  By default it will sort by Metaname, or (if this is not
                  set) in build (random) order.

Same as List classifier but includes all sections of document
(excluding top level) rather than just top level document.
";
}

sub new {
    my $class = shift (@_);
    my $self = new List($class, @_);
 
    return bless $self, $class;
}

sub classify {
    my $self = shift (@_);
    my ($doc_obj, @options) = @_;
    
    my $thissection = undef;

    my $option;
    foreach $option (@options)
    {
	if ($option =~ m/^section=(\d+)$/i) 
	{
	    $thissection = $1;
	}
    }

    my $sortmeta = "";
    if (defined $self->{'sortname'}) {
	if ($self->{'sortname'} =~ /^filename$/i) {
	    $sortmeta = $doc_obj->get_source_filename();
	} else {
	    $sortmeta = $doc_obj->get_metadata_element($doc_obj->get_top_section(),
						       $self->{'sortname'});
	    if ($self->{'sortname'} eq "Creator") {
		&sorttools::format_string_name_english (\$sortmeta);
	    } else {
		&sorttools::format_string_english (\$sortmeta);
	    }
	}
	$sortmeta = "" unless defined $sortmeta;
    }

    if (!defined $thissection)
    {
	$thissection = $doc_obj->get_next_section ($doc_obj->get_top_section());
	while (defined $thissection) {
	    $self->classify_section($thissection, $doc_obj, $sortmeta);
	    $thissection = $doc_obj->get_next_section ($thissection);
	}
    }
    else
    {
	$self->classify_section($thissection, $doc_obj, $sortmeta);
    }
}

sub classify_section {
    my $self = shift (@_);
    my ($section, $doc_obj, $sortmeta) = @_;

    my $doc_OID = $doc_obj->get_OID();
    $sortmeta = "" unless defined $sortmeta;

    if (defined $self->{'sortname'}) {
	if (defined $self->{'metaname'}) {

	    my $metavalue = $doc_obj->get_metadata_element ($section, $self->{'metaname'});
	    if (defined $metavalue) {
		if (defined $self->{'list'}->{"$doc_OID.$section"}) {
		    my $outhandle = $self->{'outhandle'};
		    print $outhandle "WARNING: SectionList::classify called multiple times for $doc_OID.$section\n";
		} 
		$self->{'list'}->{"$doc_OID.$section"} = $sortmeta;
	    }
	} else {
	    if (defined $self->{'list'}->{"$doc_OID.$section"}) {
		my $outhandle = $self->{'outhandle'};
		print $outhandle "WARNING: SectionList::classify called multiple times for $doc_OID.$section\n";
	    } 
	    $self->{'list'}->{"$doc_OID.$section"} = $sortmeta;
	}

    } else {
	if (defined $self->{'metaname'}) {

	    my $metavalue = $doc_obj->get_metadata_element ($section, $self->{'metaname'});
	    if (defined $metavalue) {
		push (@{$self->{'list'}}, "$doc_OID.$section");
	    }
	} else {
	    push (@{$self->{'list'}}, "$doc_OID.$section");
	}
    }
}

1;
