###########################################################################
#
# HTML.pm --
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

# html classifier plugin - creates an empty classification
# that's simply a link to a web page
# options are:
# buttonname=Title  -- (optional) the title field for this classification.
#                      if not included title field 'Browse'
# url=url           -- the url of the web page to link to

package HTML;

use BasClas;

sub BEGIN {
    @ISA = ('BasClas');
}

sub print_usage {
    print STDERR "
  usage: classify AZList [options]
  options:
   -url X         The url of the web page to link to.
   -buttonname X  (optional) the title field for this classification.
                  The default is 'Browse'

HTML classifier plugin - creates classifier that is a link to a web page

";
}

sub new {
    my $class = shift (@_);
    my $self = new BasClas($class, @_);
    
    my ($title, $url);
    
    if (!parsargv::parse(\@_, 
			 q^url/.*/^, \$url,
			 q^buttonname/.*/Browse^, \$title,
			 "allow_extra_options")) {
	
	print STDERR "\nIncorrect options passed to $class, check your collect.cfg file\n";
	&print_usage();
	die "\n";
    }

    if (!defined $url) {
	my $outhandle = $self->{'outhandle'};
	print $outhandle "Error: HTML classifier contains no 'url' option\n";
	die "\n";
    }

    $self->{'url'} = $url;
    $self->{'title'} = $title;

    return bless $self, $class;
}

sub init {
    my $self = shift (@_);
}

sub classify {
    my $self = shift (@_);
    my ($doc_obj) = @_;

    # we don't do anything for individual documents
}

sub get_classify_info {
    my $self = shift (@_);

    my %classifyinfo = ('thistype'=>'Invisible',
			'childtype'=>'HTML',
			'Title'=>$self->{'title'},
			'contains'=>[]);

    push (@{$classifyinfo{'contains'}}, {'OID'=>$self->{'url'}});

    return \%classifyinfo;
}


1;
