######################################################################
#
# Spanish Language text and icon macros 
#
######################################################################
#
# This is the main macro file for translation when creating an 
# interface in another language.
#
# Under the 'text macros' comments are text macros of the form:
# _macroname_ {macro value}
# Everything between the {} is the text to be translated. This text 
# may itself contain macros (i.e. characters other than space between
# underscore characters, e.g. _about:numdocs_ or _textpage_). These
# macro names occurring within text shouldn't be translated but should
# be left as they are. Underscores or curly brackets occurring 
# naturally within the text should be escaped with a leading backslash
# (i.e. '\_', '\{' or '\}).
#
# Under the 'icons' comments are macros concerned with displaying
# icons which themselves contain text.
# Above each macro (or group of macros) for an icon is a comment line
# that looks something like '## "HOME" ## top_nav_button ## chome ##'.
# The first field of the comment ("HOME" in this case) is the text
# that appears in the english version of the icon. This is the text
# that must be translated, nothing needs to be done to the macros 
# themselves. The other two fields of the comments are used by 
# automatic icon generating software which reads the newly translated
# file and generates appropriate icons.
#
# Comment lines (other than those described above) need not be 
# translated (i.e. any lines beginning with '#', like this line).
#
# The simplest way to translate this file is to save it as something
# else (e.g. french.dm) and work through translating all the text
# macro values and icon comments.
#
######################################################################


######################################################################
# Global (base) package
package Global
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultcontent_ [l=es] {La p&aacute;gina solicitada no fue encontrada. Por 
favor utilice el bot&oacute;n 'regresar' de su navegador o el bot&oacute;n 
de principal para regresara la Biblioteca Digital Greenstone.}

_textdefaulttitle_ [l=es] {Error en GSDL}

_collectionextra_ [l=es] {Esta colecci&oacute;n contiene _about:numdocs_ documentos. 
La colecci&oacute;n fue construida hace _about:builddate_ d&iacute;as.}

_textimagecollection_ [l=es] {}
_textimageabout_ [l=es] {P&aacute;gina Acerca de}
_textimagehome_ [l=es] {P&aacute;gina Principal}
_textimagehelp_ [l=es] {P&aacute;gina de Ayuda}
_textimagepref_ [l=es] {P&aacute;gina de Preferencias}
_textimagegreenstone_ [l=es] {Software de la Biblioteca Digital Greenstone}
_textimagesearch_ [l=es] {Buscar t&eacute;rminos espec&iacute;ficos}
_textimageTitle_ [l=es] {Navegar en las listas de t&iacute;tulos en orden alfab&eacute;tico}
_textimageList_ [l=es] {Navegar en la lista de documentos}
_textimageCreator_ [l=es] {Navegar en las listas de autores en orden alfab&eacute;tico}
_textimageSeries_ [l=es] {Navegar por ejemplar}
_textimageDate_ [l=es] {Navegar por fecha}
_textimageSubject_ [l=es] {Navegar por categor&iacute;as de temas}
_textimageOrganization_ [l=es] {Navegar por organizaci&oacute;n}
_textimageHowto_ [l=es] {Navegar por categor&iacute;as de c&oacute;mo}
_textimageTopic_ [l=es] {Navegar por t&oacute;picos especiales}
_textimageBrowse_ [l=es] {Navegar}
_textimagePeople_ [l=es] {Navegar en listas de gente en orden alfab&eacute;tico}

_texticontabsearchgreen_ [l=es] {Buscar}
_texticontabdategreen_ [l=es] {Fechas}
_texticontabseriesgreen_ [l=es] {Series}
_texticontabauthorgreen_ [l=es] {Autores A-Z}
_texticontabtitlegreen_ [l=es] {T&iacute;tulos A-Z}
_texticontablistgreen_ [l=es] {Listados}
_texticontabsubjectgreen_ [l=es] {Temas}
_texticontaborggreen_ [l=es] {Organizaci&oacute;n}
_texticontabhowgreen_ [l=es] {C&oacute;mo}
_texticontabtopicgreen_ [l=es] {T&oacute;picos}
_texticontabbrwsegreen_ [l=es] {Navegar}
_texticontabPeoplegreen_ [l=es] {Gente A-Z}

_texticontext_ [l=es] {Ver el documento}
_texticonclosedbook_ [l=es] {abrir este documento y ver su &iacute;ndice de contenido}
_texticonnext_ [l=es] {ir a la siguiente secci&oacute;n}
_texticonprev_ [l=es] {ir a la secci&oacute;n anterior}

_page_ [l=es] {p&aacute;gina }
_pages_ [l=es] {p&aacute;ginas}
_of_ [l=es] { de }
_vol_ [l=es] {Volumen}
_num_ [l=es] {N&uacute;mero}

_textmonth00_ [l=es] {}
_textmonth01_ [l=es] {Enero}
_textmonth02_ [l=es] {Febrero}
_textmonth03_ [l=es] {Marzo}
_textmonth04_ [l=es] {Abril}
_textmonth05_ [l=es] {Mayo}
_textmonth06_ [l=es] {Junio}
_textmonth07_ [l=es] {Julio}
_textmonth08_ [l=es] {Agosto}
_textmonth09_ [l=es] {Septiembre}
_textmonth10_ [l=es] {Octubre}
_textmonth11_ [l=es] {Noviembre}
_textmonth12_ [l=es] {Diciembre}

_magazines_ [l=es] {Revistas}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "PRINCIPAL" ## top_nav_button ## chome ##
_httpiconchomeof_ [l=es] {_httpimg_/es/chomeof.gif}
_httpiconchomeon_ [l=es] {_httpimg_/es/chomeon.gif}
_widthchomex_ [l=es] {65}
_heightchomex_ [l=es] {20}

## "AYUDA" ## top_nav_button ## chelp ##
_httpiconchelpof_ [l=es] {_httpimg_/es/chelpof.gif}
_httpiconchelpon_ [l=es] {_httpimg_/es/chelpon.gif}
_widthchelpx_ [l=es] {46}
_heightchelpx_ [l=es] {20}
   
## "PREFERENCIAS" ## top_nav_button ## cpref ##
_httpiconcprefof_ [l=es] {_httpimg_/es/cprefof.gif}
_httpiconcprefon_ [l=es] {_httpimg_/es/cprefon.gif}
_widthcprefx_ [l=es] {88}
_heightcprefx_ [l=es] {20}

## "ayuda" ## green_title ## h_help ##
_httpiconhhelp_ [l=es] {_httpimg_/es/h\_help.gif}
_widthhhelp_ [l=es] {200}
_heighthhelp_ [l=es] {57}

## "autores a-z" ## nav_bar_button ## tauth ##
_httpicontauthgr_ [l=es] {_httpimg_/es/tauthgr.gif}
_httpicontauthof_ [l=es] {_httpimg_/es/tauthof.gif}
_httpicontauthon_ [l=es] {_httpimg_/es/tauthon.gif}
_widthtauthx_ [l=es] {100}
_heighttauthx_ [l=es] {17}

## "series" ## nav_bar_button ## tser ##
_httpicontsergr_ [l=es] {_httpimg_/es/tsergr.gif}
_httpicontserof_ [l=es] {_httpimg_/es/tserof.gif}
_httpicontseron_ [l=es] {_httpimg_/es/tseron.gif}
_widthtserx_ [l=es] {87}
_heighttserx_ [l=es] {17}

## "fechas" ## nav_bar_button ## tdate ##
_httpicontdategr_ [l=es] {_httpimg_/es/tdategr.gif}
_httpicontdateof_ [l=es] {_httpimg_/es/tdateof.gif}
_httpicontdateon_ [l=es] {_httpimg_/es/tdateon.gif}
_widthtdatex_ [l=es] {87}
_heighttdatex_ [l=es] {17}

## "temas" ## nav_bar_button ## tsubj ##
_httpicontsubjgr_ [l=es] {_httpimg_/es/tsubjgr.gif}
_httpicontsubjon_ [l=es] {_httpimg_/es/tsubjon.gif}
_httpicontsubjof_ [l=es] {_httpimg_/es/tsubjof.gif}
_widthtsubjx_ [l=es] {87}
_heighttsubjx_ [l=es] {17}

## "organizacin" ## nav_bar_button ## torg ##
_httpicontorggr_ [l=es] {_httpimg_/es/torggr.gif}
_httpicontorgon_ [l=es] {_httpimg_/es/torgon.gif}
_httpicontorgof_ [l=es] {_httpimg_/es/torgof.gif}
_widthtorgx_ [l=es] {108}
_heighttorgx_ [l=es] {17}

## "cmo" ## nav_bar_button ## thow ##
_httpiconthowgr_ [l=es] {_httpimg_/es/thowgr.gif}
_httpiconthowon_ [l=es] {_httpimg_/es/thowon.gif}
_httpiconthowof_ [l=es] {_httpimg_/es/thowof.gif}
_widththowx_ [l=es] {87}
_heightthowx_ [l=es] {17}

## "tpicos" ## nav_bar_button ## ttopic ##
_httpiconttopicgr_ [l=es] {_httpimg_/es/ttopicgr.gif}
_httpiconttopicon_ [l=es] {_httpimg_/es/ttopicon.gif}
_httpiconttopicof_ [l=es] {_httpimg_/es/ttopicof.gif}
_widthttopicx_ [l=es] {87}
_heightttopicx_ [l=es] {17}

## "navegar" ## nav_bar_button ## tbrwse ##
_httpicontbrwsegr_ [l=es] {_httpimg_/es/tbrwsegr.gif}
_httpicontbrwseon_ [l=es] {_httpimg_/es/tbrwseon.gif}
_httpicontbrwseof_ [l=es] {_httpimg_/es/tbrwseof.gif}
_widthtbrwsex_ [l=es] {87}
_heighttbrwsex_ [l=es] {17}

## "buscar" ## nav_bar_button ## tsrch ##
_httpicontsrchgr_ [l=es] {_httpimg_/es/tsrchgr.gif}
_httpicontsrchof_ [l=es] {_httpimg_/es/tsrchof.gif}
_httpicontsrchon_ [l=es] {_httpimg_/es/tsrchon.gif}
_widthtsrchx_ [l=es] {87}
_heighttsrchx_ [l=es] {17}

## "ttulos a-z" ## nav_bar_button ## ttitl ##
_httpiconttitlgr_ [l=es] {_httpimg_/es/ttitlgr.gif}
_httpiconttitlof_ [l=es] {_httpimg_/es/ttitlof.gif}
_httpiconttitlon_ [l=es] {_httpimg_/es/ttitlon.gif}
_widthttitlx_ [l=es] {90}
_heightttitlx_ [l=es] {17}

## "gente" ## nav_bar_button ## tpeop ##
_httpicontpeopgr_ [l=es] {_httpimg_/es/tpeopgr.gif}
_httpicontpeopof_ [l=es] {_httpimg_/es/tpeopof.gif}
_httpicontpeopon_ [l=es] {_httpimg_/es/tpeopon.gif}
_widthtpeopx_ [l=es] {87}
_heighttpeopx_ [l=es] {17}



######################################################################
# 'about' page
package about
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textabcol_ [l=es] {Acerca de esta colecci&oacute;n}

_textsubcols1_ [l=es] {<p>La colecci&oacute;n completa comprende _1_ subcolecciones: 
<blockquote>} 

_textsubcols2_ [l=es] {</blockquote>
Puede seleccionar (y cambiar) las subcolecciones que est&aacute;
utilizando actualmente en la p&aacute;gina de Preferencias.}

#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "acerca de" ## green_title ## h_about ##
_httpiconhabout_ [l=es] {_httpimg_/es/h\_about.gif}
_widthhabout_ [l=es] {200}
_heighthabout_ [l=es] {57}



######################################################################
# document package
package document
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textTitlepage_ [l=es] {_texticonhtitle_}
_textCreatorpage_ [l=es] {_texticonhauth_}
_textSubjectpage_ [l=es] {_texticonhsubj_}
_textSeriespage_ [l=es] {_texticonhser_}
_textDatepage_ [l=es] {_texticonhdate_}
_textHowtopage_ [l=es] {_texticonhhow_}
_textOrganizationpage_ [l=es] {_texticonhorg_}
_textBrowsepage_ [l=es] {_texticonhbrwse_}
_textPeoplepage_ [l=es] {_texticonhpeople_}

_texticonhtitle_ [l=es] {T&iacute;tulos A-Z}
_texticonhauth_ [l=es] {Autores A-Z}
_texticonhsubj_ [l=es] {Temas}
_texticonhser_ [l=es] {Series}
_texticonhdate_ [l=es] {Fechas}
_texticonhhow_ [l=es] {C&oacute;mo}
_texticonhorg_ [l=es] {Organizaciones}
_texticonhbrwse_ [l=es] {Navegar}
_texticonhpeople_ [l=es] {Gente A-Z}

_texticonopenbookshelf_ [l=es] {cerrar esta secci&oacute;n de la biblioteca}
_texticonclosedbookshelf_ [l=es] {abrir esta secci&oacute;n de la biblioteca y ver el &iacute;ndice de contenido}
_texticonopenbook_ [l=es] {cerrar este libro}
_texticonclosedfolder_ [l=es] {Abrir esta carpeta y ver su contenido}
_texticonclosedfolder2_ [l=es] {abrir subsecci&oacute;n: }
_texticonopenfolder_ [l=es] {cerrar esta carpeta}
_texticonopenfolder2_ [l=es] {cerrar subsecci&oacute;n: }
_texticonsmalltext_ [l=es] {Ver esta secci&oacute;n del texto}
_texticonsmalltext2_ [l=es] {ver texto: }
_texticonpointer_ [l=es] {secci&oacute;n actual}
_texticondetach_ [l=es] {Abrir esta p&aacute;gina en una nueva ventana}
_texticonhighlight_ [l=es] {Resaltar los t&eacute;rminos de la b&uacute;squeda}
_texticonnohighlight_ [l=es] {No resaltar los t&eacute;rminos de la b&uacute;squeda}
_texticoncontracttoc_ [l=es] {Contraer el &iacute;ndice de contenido}
_texticonexpandtoc_ [l=es] {Expandir el &iacute;ndice de contenido}
_texticonexpandtext_ [l=es] {Mostrar el texto completo}
_texticoncontracttext_ [l=es] {Mostrar el texto s&oacute;lo de la secci&oacute;n seleccionada}
_texticonwarning_ [l=es] {<b>Advertencia: </b>}
_texticoncont_ [l=es] {&#191;desea continuar?}

_textltwarning_ [l=es] {
<p><center>
<table cellspacing=0 cellpadding=0 width=_pagewidth_>
<tr valign=top><td>_iconwarning_Expandir el texto generar&aacute; una gran cantidad 
de datos a desplegar en su navegador _imagecont_
</td></tr></table></center>
}  

_textgoto_ [l=es] {ir a la p&aacute;gina}
_textintro_ [l=es] { <i>(texto inicial)</i>}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "ttulos a-z" ## green_title ## h_title ##
_httpiconhtitle_ [l=es] {_httpimg_/es/h\_title.gif}
_widthhtitle_ [l=es] {200}
_heighthtitle_ [l=es] {57}

## "autores a-z" ## green_title ## h_auth ##
_httpiconhauth_ [l=es] {_httpimg_/es/h\_auth.gif}
_widthhauth_ [l=es] {200}

## "temas" ## green_title ## h_subj ##
_httpiconhsubj_ [l=es] {_httpimg_/es/h\_subj.gif}
_widthhsubj_ [l=es] {200}
_heighthsubj_ [l=es] {57}

## "series" ## green_title ## h_ser ##
_httpiconhser_ [l=es] {_httpimg_/es/h\_ser.gif}
_widthhser_ [l=es] {200}
_heighthser_ [l=es] {57}

## "fechas" ## green_title ## h_date ##
_httpiconhdate_ [l=es] {_httpimg_/es/h\_date.gif}
_widthhdate_ [l=es] {200}
_heighthdate_ [l=es] {57}

## "cmo" ## green_title ## h_how ##
_httpiconhhow_ [l=es] {_httpimg_/es/h\_how.gif}
_widthhhow_ [l=es] {200}
_heighthhow_ [l=es] {57}

## "tpicos" ## green_title ## h_topic ##
_httpiconhtopic_ [l=es] {_httpimg_/es/h\_topic.gif}
_widthhtopic_ [l=es] {200}
_heighthtopic_ [l=es] {57}

## "organizacin" ## green_title ## h_org ##
_httpiconhorg_ [l=es] {_httpimg_/es/h\_org.gif}
_widthhorg_ [l=es] {250}
_heighthorg_ [l=es] {57}

## "navegar" ## green_title ## h_brwse ##
_httpiconhbrwse_ [l=es] {_httpimg_/es/h\_brwse.gif}
_widthhbrwse_ [l=es] {200}
_heighthbrwse_ [l=es] {57}

## "gente" ## green_title ## h_people ##
_httpiconhpeople_ [l=es] {_httpimg_/es/h\_people.gif}
_widthhpeople_ [l=es] {200}
_heighthpeople_ [l=es] {57}

## "DESEA CONTINUAR?" ## top_nav_button ## cont ##
_httpiconcontoff_ [l=es] {_httpimg_/es/contoff.gif}
_httpiconconton_ [l=es] {_httpimg_/es/conton.gif}
_widthcontx_ [l=es] {122}
_heightcontx_ [l=es] {17}

## "TEXTO COMPLETO" ## document_button ## eallt ## 
_httpiconealltof_ [l=es] {_httpimg_/es/ealltof.gif}
_httpiconeallton_ [l=es] {_httpimg_/es/eallton.gif}
_widthealltx_ [l=es] {91}
_heightealltx_ [l=es] {30}

## "CONTRAER NDICE" ## document_button ## econc ##
_httpiconeconcof_ [l=es] {_httpimg_/es/econcof.gif}
_httpiconeconcon_ [l=es] {_httpimg_/es/econcon.gif}
_widtheconcx_ [l=es] {92}
_heighteconcx_ [l=es] {30}

## "SEPARAR" ## document_button ## edtch ##
_httpiconedtchof_ [l=es] {_httpimg_/es/edtchof.gif}
_httpiconedtchon_ [l=es] {_httpimg_/es/edtchon.gif}
_widthedtchx_ [l=es] {65}
_heightedtchx_ [l=es] {30}

## "EXPANDIR NDICE" ## document_button ## eexpc ##
_httpiconeexpcof_ [l=es] {_httpimg_/es/eexpcof.gif}
_httpiconeexpcon_ [l=es] {_httpimg_/es/eexpcon.gif}
_widtheexpcx_ [l=es] {86}
_heighteexpcx_ [l=es] {30}

## "CONTRAER TEXTO" ## document_button ## etsec ##
_httpiconetsecof_ [l=es] {_httpimg_/es/etsecof.gif}
_httpiconetsecon_ [l=es] {_httpimg_/es/etsecon.gif}
_widthetsecx_ [l=es] {90}
_heightetsecx_ [l=es] {30}

## "RESALTAR" ## document_button ## ehl ##
_httpiconehlof_ [l=es] {_httpimg_/es/ehlof.gif}
_httpiconehlon_ [l=es] {_httpimg_/es/ehlon.gif}
_widthehlx_ [l=es] {65}
_heightehlx_ [l=es] {30}

## "NO RESALTAR" ## document_button ## enhl ##
_httpiconenhlof_ [l=es] {_httpimg_/es/enhlof.gif}
_httpiconenhlon_ [l=es] {_httpimg_/es/enhlon.gif}
_widthenhlx_ [l=es] {65}
_heightenhlx_ [l=es] {30}



######################################################################
# 'search' page
package query
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# this if statement produces the text 'results n1 - nn for query: querystring' or 
# 'No matches for query: querystring', depending on whether or not there were
# any matches
_textquerytitle_ [l=es] {_If_(_thislast_,resultados _thisfirst_ - _thislast_ para la petici&oacute;n:_cgiargq_,No se encontraron resultados para la petici&oacute;n: _cgiargq_)}

_textnoquerytitle_ [l=es] {P&aacute;gina de b&uacute;squeda}

_texticonthispage_ [l=es] {buscar}
_textsome_ [l=es] {_If_(_cgiargb_,clasificado,algunas de)}
_textall_ [l=es] {_If_(_cgiargb_,boleano,todas)}
_texticonqueryresultsbar_ [l=es] {}
_textfreqmsg1_ [l=es] {Palabras contadas: }
_textpostprocess_ [l=es] {_If_(_quotedquery_,<br><i>postprocesado para encontrar _quotedquery_</i>
)}					     

_textmorethan_ [l=es] {M&aacute;s de }
_textapprox_ [l=es] {Acerca de }
_textnodocs_ [l=es] {No hay documentos que correspondan a la petici&oacute;n.}
_text1doc_ [l=es] {un documento corresponde a la petici&oacute;n.}
_textlotsdocs_ [l=es] {documentos corresponden a la petici&oacute;n.}
_textmatches_ [l=es] {Correspondencias }
_textbeginsearch_ [l=es] {Iniciar la b&uacute;squeda}

_textsimplesearch_ [l=es] {Buscar _If_(_hselection_, _hselection_)_If_(_jselection_,_textjselect_)_If_(_nselection_, en idioma _nselection_) 
que contengan _querytypeselection_ las palabras}

_textadvancedsearch_ [l=es] {Buscar _If_(_hselection_, _hselection_, _defaultindextext_)_If_(_jselection_,_textjselect_)_If_(_nselection_, en idioma _nselection_) 
utilizando la petici&oacute;n _querytypeselection_}

_textjselect_ [l=es] {_If_(_hselection_, de) _jselection_}

_textstemon_ [l=es] { (ignorar las terminaciones de las palabras)}
_textclearhistory_ [l=es] {Borrar Historia}
_textexpand_ [l=es] {Expandir}
_textcontract_ [l=es] {Contraer}
_textsearchhistory_ [l=es] {Buscar en la Historia}
_textquery_ [l=es] {Petici&oacute;n}
_textresults_ [l=es] {Resultados}
_textview_ [l=es] {Ver}
_textnohistory_ [l=es] {La b&uacute;squeda en la historia no est&aacute; disponible}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "buscar" ## green_title ## h_search ##
_httpiconhsearch_ [l=es] {_httpimg_/es/h\_search.gif}
_widthhsearch_ [l=es] {200}
_heighthsearch_ [l=es] {57}

## "resultados" ## green_bar_left_aligned ## qryresb ##
_httpiconqryresb_ [l=es] {_httpimg_/es/qryresb.gif}
_widthqryresb_ [l=es] {_pagewidth_}
_heightqryresb_ [l=es] {17}

## "mostrar" ## hand_made ##
_httpicondisplay_ [l=es] {_httpimg_/display.gif}
_widthdisplay_ [l=es] {60}
_heightdisplay_ [l=es] {20}



######################################################################
# 'preferences' page
package preferences
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsearchprefs_ [l=es] {Preferencias de b&uacute;squeda}
_textcollectionprefs_ [l=es] {Preferencias de colecciones}
_textpresentationprefs_ [l=es] {Preferencias de presentaci&oacute;n}
_textpreferences_ [l=es] {Preferencias}
_textignorecase_ [l=es] { ignorar diferencias entre may&uacute;sculas y min&uacute;sculas}
_textmatchcase_ [l=es] { deben corresponder may&uacute;sculas y min&uacute;sculas}
_textstem_ [l=es] { ignorar las terminaciones de las palabras}
_textnostem_ [l=es] { debe corresponder la palabra completa}
_textprefop_ [l=es] {Regresa hasta _maxdocoption_ resultados con _hitsperpageoption_ aciertos por p&aacute;gina.}
_textextlink_ [l=es] {Acceder a p&aacute;ginas de Web externas: }
_textintlink_ [l=es] {Documentos fuente recuperados de:}
_textlanguage_ [l=es] {Idioma de la interfaz: }
_textencoding_ [l=es] {Codificaci&oacute;n: }
_textformat_ [l=es] {Formato de la interfaz: }
_textall_ [l=es] {todas}
_textsimplemode_ [l=es] {b&uacute;squeda simple}
_textadvancedmode_ [l=es] {b&uacute;squeda avanzada (permite b&uacute;squedas boleanas utilizando !, &, | y par&eacute;ntesis)}
_textlinkinterm_ [l=es] {a trav&eacute;s de una p&aacute;gina intermedia}
_textlinkdirect_ [l=es] {ir directamente ah&iacute;}
_textdigitlib_ [l=es] {la biblioteca digital}
_textweb_ [l=es] {el web}
_textlangeng_ [l=es] {Ingl&eacute;s}
_textlanggerman_ [l=es] {Alem&aacute;n}
_textlangfrench_ [l=es] {Franc&eacute;s}
_textlangspanish_ [l=es] {Espa&ntilde;ol}
_textlangmaori_ [l=es] {M_amn_ori}
_textlangchinese_ [l=es] {Chino}
_textgraphical_ [l=es] {Gr&aacute;fica}
_texttextual_ [l=es] {S&oacute;lo texto}
_textcollectionoption_ [l=es] {<p>
Subcolecciones a incluir:
<br>}
_textfcoption_ [l=es] {Incluir la barra de navegaci&oacute;n en la parte superior de las p&aacute;ginas del documento}
_texthloption_ [l=es] {Resaltar los t&eacute;rminos de la b&uacute;squeda dentro del documento}
_texthistorydisplay_ [l=es] {mostrar la historia de la b&uacute;squeda}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "preferencias" ## green_title ## h_pref ##
_httpiconhpref_ [l=es] {_httpimg_/es/h\_pref.gif}
_widthhpref_ [l=es] {200}
_heighthpref_ [l=es] {57}



######################################################################
# 'delete search history' page
package delhistory
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdsh_ [l=es] {Borrar la historia de la b&uacute;squeda}

_textselectdelete_ [l=es] {<a href="_httpclearhistory_&hdh=1">Borre todos los 
registros</a> o seleccione los registros a <select name=hmode>
<option value=save>conservar<option value=delete selected>borrar</select><br>
Los registros pueden ser seleccionados escribiendo sus n&uacute;meros en el 
cuadro, <br> o presionando en los cuadros de cada registro.<br> Los valores 
aceptados son 1,2,3-6,7- etc }

_textclearselected_ [l=es] {Borrar seleccionados}
_textselect_ [l=es] {seleccionar}


#------------------------------------------------------------
# icons
#------------------------------------------------------------



######################################################################
# 'help' page -- this is lower priority for translating than the
# rest of this file
package help
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textHelp_ [l=es] {Ayuda}
_textSearchshort_ [l=es] {buscar palabras clave}
_textSeriesshort_ [l=es] {acceder a las publicaciones por series}
_textDateshort_ [l=es] {acceder a las publicaciones por fecha}
_textSubjectshort_ [l=es] {acceder a las publicaciones por tema}
_textTitleshort_ [l=es] {acceder a las publicaciones por t&iacute;tulo}
_textBrowseshort_ [l=es] {navegar en las publicaciones}
_textCreatorshort_ [l=es] {acceder a las publicaciones por autor}
_textOrganizationshort_ [l=es] {acceder a las publicaciones por organizaci&oacute;n}
_textHowtoshort_ [l=es] {acceder a las publicaciones por lista de c&oacute;mo}
_textTopicshort_ [l=es] {acceder a las publicaciones por t&oacute;pico}
_textPeopleshort_ [l=es] {acceder a las publicaciones por gente}
_textdefaultshorttext_ [l=es] {clasificaci&oacute;n no definida}

_textSearchlong_ [l=es] { <p>Puede <i>buscar palabras clave</i> que aparecen en 
el texto desde la p&aacute;gina de "b&uacute;squeda". &Eacute;sta es la primera p&aacute;gina que 
aparece cuando usted inicia y puede ser accesada desde otras p&aacute;ginas al 
presionar el bot&oacute;n de <i>buscar</i>.  }

_textTitlelong_ [l=es] { <p>Puede <i>acceder a las publicaciones por t&iacute;tulo</i> 
presionando el bot&oacute;n <i>titulos a-z</i>. El resultado ser&aacute; una 
lista de libros en orden alfab&eacute;tico.  }

_textOrganizationlong_ [l=es] { <p>Puede <i>acceder a las publicaciones por 
organizaci&oacute;n</i> presionando el bot&oacute;n <i>organizaci&oacute;n</i>. El resultado 
ser&aacute; una lista de organizaciones.  }

_textHowtolong_ [l=es] { <p>Puede <i>acceder a las publicaciones por una lista 
de c&oacute;mo</i> presionando el bot&oacute;n <i>c&oacute;mo</i>. El resultado 
ser&aacute; una lista de c&oacute;mos.  }

_textCreatorlong_ [l=es] { <p>Puede <i>acceder a publicaciones por autor</i> 
presionando el bot&oacute;n <i>autores a-z</i>. El resultado ser&aacute; una 
lista de libros ordenados por el apellido del autor.  }

_textTopiclong_ [l=es] { <p>Puede <i>acceder a las publicaciones por t&oacute;pico</i> 
presionando el bot&oacute;n de <i>t&oacute;pico</i>. El resultado ser&aacute; 
una lista de t&oacute;picos para navegarlos.  }

_textSubjectlong_ [l=es] { <p>Puede <i>acceder a las publicaciones por tema</i> 
presionando el bot&oacute;n de <i>temas</i>. El resultado ser&aacute; una lista de temas, 
representados por libreros.  }

_textSerieslong_ [l=es] { <p>Puede <i>acceder a las publicaciones por series</i> 
presionando el bot&oacute;n de <i>series</i>. El resultado ser&aacute; una lista 
de las series que se encuentran en la colecci&oacute;n.  }

_textDatelong_ [l=es] { <p>Puede <i>acceder a las publicaciones por fecha</i> 
presionando el bot&oacute;n de <i>fechas</i>. El resultado ser&aacute; una lista
de todas las publicaciones, ordenadas cronol&oacute;gicamente.  }

_textBrowselong_ [l=es] { <p> Puede <i>navegar en las publicaciones</i> presionando 
el bot&oacute;n de <i>navegar</i>.  }

_textPeoplelong_ [l=es] { <p>Puede <i>acceder a las publicaciones por gente</i> 
presionando el bot&oacute;n <i>gente a-z</i>. El resultado ser&aacute; una lista
ordenada por apellido.  }

_textdefaultlongtext_ [l=es] { <p>Pulse el bot&oacute;n <i>desconocido</i> para navegar 
en las publicaciones (el listado ser&aacute; ordenado por un campo desconocido).  }

_texthelptopics_ [l=es] {

<h2 align=left>T&oacute;picos</h2>
<ul>
  <li><a href="\#finding-information">_textsimplehelpheading_</a>
  _topicreadingdocs_
  <li><a href="\#searching">&#191;C&oacute;mo buscar palabras clave?</a>
<ul>
  <li><a href="\#query-terms">T&eacute;rminos de la b&uacute;squeda</a>
  <li><a href="\#query-type">Tipo de petici&oacute;n</a>
  <li><a href="\#scope-of-queries">Rango de las b&uacute;squedas</a>
</ul>
  <li><a href="\#preferences">_textchangeprefs_</a>
<ul>
  <li><a href="\#col-prefs">Preferencias de colecci&oacute;n</a>
  <li><a href="\#pres-prefs">Preferencias de presentaci&oacute;n</a>
  <li><a href="\#search-prefs">Preferencias de b&uacute;squeda</a>
</ul>
</ul>
}

# there are 4 versions of this section of the help text.
# which version is used is currently set within the server
# (it should probably use the macro language e.g. [type=book])
# 1 = html (like fao collections) -- section is empty
# 2 = book (like hdl collection) -- macros beginning with book
# 3 = bibliographic (like csbib) -- macros beginning with bib
# 4 = standard (like gberg) -- the default

_topicreadingdocs_ [l=es] {<li><a href="\#reading-docs">_textreadingdocs_</a>}

_textreadingdocs_ [l=es] {&#191;C&oacute;mo leer los documentos?}
_booktextreadingdocs_ [l=es] {&#191;C&oacute;mo leer los libros?}
_bibtextreadingdocs_ [l=es] {Obtener m&aacute;s informaci&oacute;n sobre un elemento bibliogr&aacute;fico}

_texthelpreadingdocs_ [l=es] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>Puede notar cuando ha llegado a un documento en particular porque su 
t&iacute;tulo y autor aparecen en la parte superior izquierda de la 
p&aacute;gina. Al lado de &eacute;stos est&aacute; el n&uacute;mero de la 
p&aacute;gina actual, un cuadro que le permite seleccionar la nueva 
p&aacute;gina y las flechas de adelante y atr&aacute;s.

<p>Debajo est&aacute; el texto de la secci&oacute;n actual. Cuando lo haya 
leido, las flechas que se encuentran en la parte inferior pueden llevarlo a la 
secci&oacute;n siguiente o regresarlo a la secci&oacute;n anterior.

<p>Abajo del t&iacute;tulo y autor se encuentran tres botones. Presione
<i>texto completo</i> para desplegar el texto completo de documento actual. 
Si el documento es extenso, este proceso tomar&aacute; alg&uacute;n tiempo y 
utilizar&aacute; mucha memoria!. Presione <i>separar</i> para crear un nueva 
ventana de su navegador para este documento (esto es &uacute;til si desea 
comparar documentos o leer dos a la vez). Finalmente, cuando realiza una 
b&uacute;squeda, las palabras a buscar aparecen resaltadas; presione <i>sin 
resaltar</i> para eliminar esta apariencia.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_httpiconmore_" border="0"></td><td>Presione la flecha para ir a la secci&oacute;n siguiente ...</td></tr>
<tr><td colspan=2><img src="_httpiconless_" border="0"></td><td>... o regresar a la secci&oacute;n anterior</td></tr>
<tr><td><img src="_document:httpiconealltof_" border="0"></td><td><img 
src="_document:httpiconetsecof_" border="0"></td><td>Desplegar el texto completo, o no</td></tr>
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Abrir esta p&aacute;gina en una nueva ventana</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Resaltar o no los t&eacute;rminos buscados</td></tr>
</table>
}

_booktexthelpreadingdocs_ [l=es] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>Puede notar cuando ha llegado a un libro en particular porque la 
fotograf&iacute;a de su portada aparece en la parte izquierda de la 
p&aacute;gina. Al lado de la fotograf&iacute;a est&aacute; el &iacute;ndice 
de contenido con una flecha que le indica d&oacute;nde est&aacute; usted. 
Este &iacute;ndice es expandible: presione las carpetas para abrirlas o 
cerrarlas. Presione en el libro abrierto, que se encuentra en la parte 
superior, para cerrarlo.

<p>Debajo est&aacute; el texto de la secci&oacute;n actual. Cuando lo haya 
leido, las flechas que se encuentran en la parte inferior pueden llevarlo a la
secci&oacute;n siguiente o regresarlo a la secci&oacute;n anterior.

<p>Abajo de la fotograf&iacute;a se encuentran cuatro botones. Presione sobre 
<i>texto completo</i> para desplegar el texto completo de la secci&oacute;n 
actual o del libro. Si el libro es extenso, este proceso tomar&aacute; 
alg&uacute;n tiempo y utilizar&aacute; mucha memoria!. Presione <i>expandir 
&iacute;ndice</i> para expandir el &iacute;ndice completo y as&iacute; pueda 
ver todos los t&iacute;tulos de cap&iacute;tulos y subsecciones. Presione 
<i>separar</i> para crear un nueva ventana de su navegador para este documento 
(esto es &uacute;til si desea comparar libros o leer dos a la vez). Finalmente, 
cuando realiza una b&uacute;squeda, las palabras a buscar aparecen resaltadas; 
presione <i>sin resaltar</i> para eliminar esta apariencia.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_httpiconbshelf_" border="0"></td><td>Abrir este librero</td></tr>
<tr><td><img src="_httpiconopenbook_" border="0"></td><td><img 
src="_httpiconbook_" border="0"></td><td>Abrir/cerrar este libro</td></tr>
<tr><td colspan=2><img src="_httpiconitext_" border="0"></td><td>Ver esta secci&oacute;n del texto</td></tr>
<tr><td><img src="_document:httpiconealltof_" border="0"></td><td><img 
src="_document:httpiconetsecof_" border="0"></td><td>Desplegar el texto completo, o no</td></tr>
<tr><td><img src="_document:httpiconeexpcof_" border="0"></td><td><img
src="_document:httpiconeconcof_" border="0"></td><td>Expandir o no el &iacute;ndice de contenido</td></tr>
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Abrir esta p&aacute;gina en una nueva ventana</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Resaltar o no los t&eacute;rminos de la b&uacute;squeda</td></tr>
<tr><td colspan=2><img src="_httpiconmore_" border="0"></td><td>Presionar la flecha para ir a la secci&oacute;n siguiente ...</td></tr>
<tr><td colspan=2><img src="_httpiconless_" border="0"></td><td>... o regresar a la secci&oacute;n anterior</td></tr>
</table>
}

_bibtexthelpreadingdocs_ [l=es] {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>Algunos elementos bibliogr&aacute;ficos contienen m&aacute;s 
informaci&oacute;n, por ejemplo un resumen. Puede notar desde la p&aacute;gina 
de resultados si este es el caso porque que se muestran con el &iacute;cono
 _icontext_ en lugar del &iacute;cono _iconblanktext_.

<p>Presionar el &iacute;cono _icontext_ le dar&aacute; m&aacute;s 
informaci&oacute;n acerca del elemento bibliogr&aacute;fico.

<p> Abajo del elemento bibliogr&aacute;fico se encuentran dos botones. Presione
<i>separar</i> para crear un nueva ventana de su navegador para este 
libro (esto es &uacute;til si desea comparar elementos bibliogr&aacute;ficos). 
Finalmente, cuando realiza una b&uacute;squeda, las palabras a buscar aparecen 
resaltadas; presione <i>sin resaltar</i> para eliminar esta apariencia.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Abrir esta p&aacute;gina en una nueva ventana</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Resaltar o no los t&eacute;rminos buscados</td></tr>
</table>
}

_texthelpsearching_ [l=es] {
<h2>&#191;C&oacute;mo buscar palabras clave?</h2>
<p>
  Desde la p&aacute;gina de b&uacute;squeda, hacer una petici&oacute;n siguiendo estos pasos:<p>
  <ol><li>Especificar qu&eacute; documentos quiere buscar
      <li>Decir si quiere buscar todas las palabras o s&oacute;lo algunas
      <li>Escribir las palabras que quiere buscar
      <li>Presionar el bot&oacute;n de <i>Iniciar la b&uacute;squeda</i>
  </ol>
  
<p>Cuando hace una petici&oacute;n, se mostrar&aacute;n los t&iacute;tulos de 
veinte documentos resultantes. Existe un bot&oacute;n al final que lo 
llevar&aacute; a los siguientes veinte documentos. De ah&iacute; 
encontrar&aacute; botones para llevarlo a los terceros veinte o regresar a los 
primeros veinte, etc&eacute;tera. Presione el t&iacute;tulo de cualquier 
documento o el peque&ntilde;o bot&oacute;n al lado de &eacute;l, para verlo. 

<p>El n&uacute;mero m&aacute;ximo documentos resultantes es de 100. Puede 
  cambiar este n&uacute;mero presionando el bot&oacute;n de <i>preferencias</i>
  que se encuentra en la parte superior de la p&aacute;gina.<p>

<p>_iconblankbar_
<a name=query-terms>
<h3>T&eacute;rminos de la b&uacute;squeda</h3>

<p>Lo que escribe en el cuadro de petici&oacute;n es interpretado como una 
lista de palabras llamadas "t&eacute;rminos de la b&uacute;squeda". Cada 
t&eacute;rmino contiene letras y d&iacute;gitos. Los t&eacute;rminos se separan 
por el espacio en blanco. Si aparecen otros caracteres, como los de 
puntuaci&oacute;n, &eacute;stos sirven para separar los t&eacute;rminos 
como si fueran espacios y son ignorados. No puede buscar palabras que incluyan 
puntuaci&oacute;n.

<p>Por ejemplo, la petici&oacute;n<p>
    <ul><kbd>Agro-sivicultura en las Islas del Pac&iacute;fico: Sistemas de Sustento (1993)</kbd></ul>
      <p>ser&aacute; tratado de igual manera que<p>
      <ul><kbd>Agro sivicultura en las Islas del Pac&iacute;fico Sistemas de Sustento 1993 </kbd></ul><p>
      
<p>_iconblankbar_
<a name=query-type>
<h3>Tipo de petici&oacute;n</h3>

<p>Existen dos tipos de petici&oacute;n.

<ul>
  <li>Peticiones de <b>todas</b> las palabras. &Eacute;sta busca documentos que 
      contengan todas las palabras que especifique. Los documentos que 
      satisfagan la petici&oacute;n ser&aacute;n desplegados en orden 
      alfab&eacute;tico. <p>     
      
  <li>Peticiones de <b>alguna(s)</b> palabra(s).  Solamente liste los
      t&eacute;rminos que probablemente aparecer&aacute;n en los documentos que 
      est&eacute; buscando. Los documentos se ordenar&aacute;n de acuerdo a que 
      tanto coincidieron con su petici&oacute;n. Cuando se determina el grado de
      correspondencia, 

      <p><ul>
        <li> entre m&aacute;s t&eacute;rminos buscados contenga el documento, 
             satisfacer&aacute; mejor su petici&oacute;n;
        <li> los t&eacute;rminos no comunes son m&aacute;s importantes que los 
             comunes;
        <li> los documentos m&aacute;s peque&ntilde;os tienen m&aacute;s 
             probabilidades que los grandes de corresponder a su solicitud.
      </ul>      
</ul>

<p>Utilice tantos t&eacute;rminos de b&uacute;squeda como desee, una 
oraci&oacute;n completa, o quizas todo un p&aacute;rrafo. Si especifica un 
s&oacute;lo t&eacute;rmino, los documentos ser&aacute;n 
ordenados por frecuencia de ocurrencia.<p>
_texthelpscope_
}

_textchangeprefs_ [l=es] {Cambiando sus preferencias}

_texthelppreferences_ [l=es] {<h2>_textchangeprefs_</h2>

<p>Cuando presione el bot&oacute;n de <i>preferencias</i>, de la parte superior de la
p&aacute;gina, ser&aacute; capaz de cambiar algunas caracter&iacute;sticas de la 
interfaz para satisfacer sus propios requisitos.

<p>_iconblankbar_
<a name=col-prefs>
<h3 align=left>Perefencias de colecci&oacute;n</h3>
<p>
Algunas colecciones se componen de varias subcolecciones, las cuales pueden
buscarse de forma independiente o juntas, como una unidad. De esta 
manera, puede seleccionar qu&eacute; subcolecciones desea incluir en sus 
b&uacute;squedas en la p&aacute;gina de preferencias.

<p>_iconblankbar_
<a name=pres-prefs>
<h3 align=left>Preferencias de presentaci&oacute;n</h3>
<p>
Dependiendo de la colecci&oacute;n, pueden existir muchas opciones para definir 
la manera de la presentaci&oacute;n.
<p>
Las colecciones de p&aacute;ginas de Web le permiten eliminar la barra de 
navegaci&oacute;n de Greenstone de la parte superior de cada p&aacute;gina, 
de modo que una vez terminada la b&uacute;squeda se encontrar&aacute; en la 
p&aacute;gina correspondiente sin los encabezados de Greenstone. Para realizar 
otra b&uacute;squeda tendr&aacute; que utilizar el bot&oacute;n "regresar" de 
su navegador. Estas colecciones tambi&eacute;n le permiten eliminar el mensaje 
de alerta de Greenstone cuando seleccione una liga que lo lleve fuera de la 
colecci&oacute;n de la biblioteca digital y de Web en si. Y en algunas 
colecciones del Web puede controlar si las ligas de la p&aacute;gina de 
"Resultados de la b&uacute;squeda" lo llevan directo al URL en cuesti&oacute;n 
o m&aacute;s bien a la copia de la p&aacute;gina de la biblioteca digital.

<p>
Las colecciones que son capaces de ser representadas en diferentes idiomas 
le permiten especificar el idioma de la interfaz. Si el idioma es Chino, 
puede especificar tambi&eacute;n cu&aacute;les son los est&aacute;ndares 
Chinos de codificaci&oacute;n que utiliza su navegador.

<p>
Finalmente, todas las colecciones le permiten cambiar a una interfaz de texto
diferente de la gr&aacute;fica. Esto es muy &uacute;til para los usuarios con 
problemas visuales que utilizan fuentes grandes o sintetizadores de voz como 
salida.

<p>_iconblankbar_
<a name=search-prefs>
<h3 align=left>Preferencias de b&uacute;squeda</h3>
Dos pares de botones controlan la diferencia entre may&uacute;sculas y 
min&uacute;sculas y las ra&iacute;ces de las b&uacute;squedas que hace. 
El primer conjunto de botones controla si deben coincidir may&uacute;sculas 
o min&uacute;sculas. El segundo conjunto controla si se ignoran las 
terminaciones de las palabras o no (ra&iacute;ces).

<p>Por ejemplo, si los botones de <i>ignorar diferencias entre may&uacute;sculas
y min&uacute;sculas</i> y el de <i>ignorar terminaciones de palabras</i> 
est&aacute;n seleccionados, la b&uacute;squeda<p>
    <ul><kbd>Construcciones Africanas</kbd></ul>
      <p>ser&aacute; considerada al igual que <p>
      <ul><kbd>constructores africanos</kbd></ul><p>
      porque la letra may&uacute;scula en "Africanas" sera transformada a 
      min&uacute;scula, y los sufijos "ciones" y "nas" se eliminaran de 
      "Construcciones" y "Africanas" respectivamente ( de la misma manera, 
      "tores" y "nos" se eliminar&aacute;n de "constructores" y "africanos").

<p>Tambi&eacute;n puede cambiar a un modo "avanzado" de consulta que le permite 
combinar t&eacute;rminos utilizando Y (&), O (|), y NO (!). Esto le 
permitir&aacute; especificar consultas m&aacute;s precisas.

<p>Finalmente, puede controlar el n&uacute;mero de aciertos regresados, y el
n&uacute;mero de estos presentado en cada pantalla completa.
}

_texttanumbrowseoptions_ [l=es] {Existen _numbrowseoptions_ manera(s) de encontrar informaci&oacute;n en esta colecci&oacute;n:}

_textsimplehelpheading_ [l=es] {&#191;C&oacute;mo encontrar informaci&oacute;n?}

_texthelpscope_ [l=es] {
<p>_iconblankbar_
<a name=scope-of-queries>
<h3 align=left>Rango de las b&uacute;squedas</h3> 

<p>
En la mayor&iacute;a de las colecciones puede escoger diferentes &iacute;ndices 
para buscar. Por ejemplo, puede haber &iacute;ndices por autor o t&iacute;tulo. 
Tambi&eacute;n puede haber &iacute;ndices por cap&iacute;tulo o p&aacute;rrafo. 
Generalmente, se recupera el documento correspondiente sin importar &eacute;l 
&iacute;ndice por el cual se busca. 
<p>Si los documentos son libros, estos aparecer&aacute;n en el lugar 
predefinido.
}
