######################################################################
#
# English Language text and icon macros 
#
######################################################################
#
# This is the main macro file for translation when creating an 
# interface in another language.
#
# Under the 'text macros' comments are text macros of the form:
# _macroname_ {macro value}
# Everything between the {} is the text to be translated. This text 
# may itself contain macros (i.e. characters other than space between
# underscore characters, e.g. _about:numdocs_ or _textpage_). These
# macro names occurring within text shouldn't be translated but should
# be left as they are. Underscores or curly brackets occurring 
# naturally within the text should be escaped with a leading backslash
# (i.e. '\_', '\{' or '\}).
#
# Under the 'icons' comments are macros concerned with displaying
# icons which themselves contain text.
# Above each macro (or group of macros) for an icon is a comment line
# that looks something like '## "HOME" ## top_nav_button ## chome ##'.
# The first field of the comment ("HOME" in this case) is the text
# that appears in the english version of the icon. This is the text
# that must be translated, nothing needs to be done to the macros 
# themselves. The other two fields of the comments are used by 
# automatic icon generating software which reads the newly translated
# file and generates appropriate icons.
#
# Comment lines (other than those described above) need not be 
# translated (i.e. any lines beginning with '#', like this line).
#
# The simplest way to translate this file is to save it as something
# else (e.g. french.dm) and work through translating all the text
# macro values and icon comments.
#
######################################################################


######################################################################
# Global (base) package
package Global
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultcontent_ {The requested page could not be found. Please use
your browsers 'back' button or the above home button to return to the
Greenstone Digital Library.}

_textdefaulttitle_ {GSDL Error}

_collectionextra_ {This collection contains _about:numdocs_ documents. 
It was last built _about:builddate_ days ago.}

_textimagecollection_ {}
_textimageabout_ {About page}
_textimagehome_ {Home page}
_textimagehelp_ {Help page}
_textimagepref_ {Preferences page}
_textimagegreenstone_ {Greenstone Digital Library Software}

_textimagesearch_ {Search for specific terms}
_textimageTitle_ {Browse alphabetical list of titles}
_textimageList_ {Browse document listing}
_textimageCreator_ {Browse alphabetical list of authors}
_textimageSeries_ {Browse by issue}
_textimageDate_ {Browse by date}
_textimageSubject_ {Browse by subject category}
_textimageTo_ {Browse by To field}
_textimageFrom_ {Browse by From field}
_textimageOrganization_ {Browse by organization}
_textimageHowto_ {Browse how to categories}
_textimageTopic_ {Browse special topic issues}
_textimageBrowse_ {Browse}
_textimagePeople_ {Browse alphabetical list of People}
_textimageLanguage_ {Browse by language}
_textimageAcronym_ {Browse acronyms}
_textimagePhrase_ {Browse phrases}

_texticontabsearchgreen_{Search}
_texticontabdategreen_{Dates}
_texticontabseriesgreen_{Series}
_texticontabauthorgreen_{Authors A-Z}
_texticontabtitlegreen_{Titles A-Z}
_texticontablistgreen_ {Listing}
_texticontabsubjectgreen_{Subjects}
_texticontabtogreen_{To}
_texticontabfromgreen_{From}
_texticontaborggreen_{Organization}
_texticontabhowgreen_{How to}
_texticontabtopicgreen_{Topics}
_texticontabbrwsegreen_{Browse}
_texticontabPeoplegreen_{People A-Z}
_texticontabLanguagegreen_{Language}
_texticontabAcronymgreen_{Acronyms}
_texticontabPhrasegreen_{Phrases}

_texticontext_ {View the document}
_texticonclosedbook_ {open this document and view contents}
_texticonnext_ {to next section}
_texticonprev_ {to previous section}
_texticonmsword_ {View the Microsoft Word document}
_texticonpdf_  {View the PDF document}
_texticonps_  {View the PS document}
_texticonmidi_ {View the MIDI document}

_page_ {page }
_pages_ {pages}
_of_ { of }
_vol_ {Vol.}
_num_ {No.}

_textmonth00_ {}
_textmonth01_ {January}
_textmonth02_ {February}
_textmonth03_ {March}
_textmonth04_ {April}
_textmonth05_ {May}
_textmonth06_ {June}
_textmonth07_ {July}
_textmonth08_ {August}
_textmonth09_ {September}
_textmonth10_ {October}
_textmonth11_ {November}
_textmonth12_ {December}

_Document_ {Document}
_Section_ {Section}
_Paragraph_ {Paragraph}

_magazines_ {Magazines}

_nzdlpagefooter_ {<p>_iconblankbar_
<p><a href="http://www.nzdl.org">New Zealand Digital Library Project</a>
<br><a href="http://www.cs.waikato.ac.nz/cs">Department of Computer Science</a>, 
<a href="http://www.waikato.ac.nz">University of Waikato</a>, 
New Zealand}

#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "HOME" ## top_nav_button ## chome ##
_httpiconchomeof_ {_httpimg_/chomeof.gif}
_httpiconchomeon_ {_httpimg_/chomeon.gif}
_widthchomex_ {43}
_heightchomex_ {20}

## "HELP" ## top_nav_button ## chelp ##
_httpiconchelpof_ {_httpimg_/chelpof.gif}
_httpiconchelpon_ {_httpimg_/chelpon.gif}
_widthchelpx_ {36}
_heightchelpx_ {20}

## "PREFERENCES" ## top_nav_button ## cpref ##
_httpiconcprefof_ {_httpimg_/cprefof.gif}
_httpiconcprefon_ {_httpimg_/cprefon.gif}
_widthcprefx_ {87}
_heightcprefx_ {20}

## "help" ## green_title ## h_help ##
_httpiconhhelp_ {_httpimg_/h\_help.gif}
_widthhhelp_ {200}
_heighthhelp_ {57}

## "authors a-z" ## nav_bar_button ## tauth ##
_httpicontauthgr_ {_httpimg_/tauthgr.gif}
_httpicontauthof_ {_httpimg_/tauthof.gif}
_httpicontauthon_ {_httpimg_/tauthon.gif}
_widthtauthx_ {110}
_heighttauthx_ {17}

## "series" ## nav_bar_button ## tser ##
_httpicontsergr_ {_httpimg_/tsergr.gif}
_httpicontserof_ {_httpimg_/tserof.gif}
_httpicontseron_ {_httpimg_/tseron.gif}
_widthtserx_ {87}
_heighttserx_ {17}

## "dates" ## nav_bar_button ## tdate ##
_httpicontdategr_ {_httpimg_/tdategr.gif}
_httpicontdateof_ {_httpimg_/tdateof.gif}
_httpicontdateon_ {_httpimg_/tdateon.gif}
_widthtdatex_ {87}
_heighttdatex_ {17}

## "subjects" ## nav_bar_button ## tsubj ##
_httpicontsubjgr_ {_httpimg_/tsubjgr.gif}
_httpicontsubjon_ {_httpimg_/tsubjon.gif}
_httpicontsubjof_ {_httpimg_/tsubjof.gif}
_widthtsubjx_ {87}
_heighttsubjx_ {17}

## "to" ## nav_bar_button ## tto ##
_httpiconttogr_ {_httpimg_/ttogr.gif}
_httpiconttoon_ {_httpimg_/ttoon.gif}
_httpiconttoof_ {_httpimg_/ttoof.gif}
_widthttox_ {87}
_heightttox_ {17}

## "from" ## nav_bar_button ## tfrom ##
_httpicontfromgr_ {_httpimg_/tfromgr.gif}
_httpicontfromon_ {_httpimg_/tfromon.gif}
_httpicontfromof_ {_httpimg_/tfromof.gif}
_widthtfromx_ {87}
_heighttfromx_ {17}

## "organization" ## nav_bar_button ## torg ##
_httpicontorggr_{_httpimg_/torggr.gif}
_httpicontorgon_{_httpimg_/torgon.gif}
_httpicontorgof_{_httpimg_/torgof.gif}
_widthtorgx_ {109}
_heighttorgx_ {17}

## "how to" ## nav_bar_button ## thow ##
_httpiconthowgr_{_httpimg_/thowgr.gif}
_httpiconthowon_{_httpimg_/thowon.gif}
_httpiconthowof_{_httpimg_/thowof.gif}
_widththowx_ {87}
_heightthowx_ {17}

## "topic" ## nav_bar_button ## ttopic ##
_httpiconttopicgr_{_httpimg_/ttopicgr.gif}
_httpiconttopicon_{_httpimg_/ttopicon.gif}
_httpiconttopicof_{_httpimg_/ttopicof.gif}
_widthttopicx_ {87}
_heightttopicx_ {17}

## "browse" ## nav_bar_button ## tbrwse ##
_httpicontbrwsegr_{_httpimg_/tbrwsegr.gif}
_httpicontbrwseon_{_httpimg_/tbrwseon.gif}
_httpicontbrwseof_{_httpimg_/tbrwseof.gif}
_widthtbrwsex_ {87}
_heighttbrwsex_ {17}

## "search" ## nav_bar_button ## tsrch ##
_httpicontsrchgr_ {_httpimg_/tsrchgr.gif}
_httpicontsrchof_ {_httpimg_/tsrchof.gif}
_httpicontsrchon_ {_httpimg_/tsrchon.gif}
_widthtsrchx_ {87}
_heighttsrchx_ {17}

## "titles a-z" ## nav_bar_button ## ttitl ##
_httpiconttitlgr_ {_httpimg_/ttitlgr.gif}
_httpiconttitlof_ {_httpimg_/ttitlof.gif}
_httpiconttitlon_ {_httpimg_/ttitlon.gif}
_widthttitlx_ {87}
_heightttitlx_ {17}

## "people" ## nav_bar_button ## tpeop ##
_httpicontpeopgr_ {_httpimg_/tpeopgr.gif}
_httpicontpeopof_ {_httpimg_/tpeopof.gif}
_httpicontpeopon_ {_httpimg_/tpeopon.gif}
_widthtpeopx_ {97}
_heighttpeopx_ {17}

## "language" ## nav_bar_button ## tlang ##
_httpicontlanggr_ {_httpimg_/tlanggr.gif}
_httpicontlangon_ {_httpimg_/tlangon.gif}
_httpicontlangof_ {_httpimg_/tlangof.gif}
_widthtlangx_ {87}
_heighttlangx_ {17}

## "acronym" ## nav_bar_button ## tacro ##
_httpicontacrogr_ {_httpimg_/tacrogr.gif}
_httpicontacroof_ {_httpimg_/tacroof.gif}
_httpicontacroon_ {_httpimg_/tacroon.gif}
_widthtacrox_ {87}
_heighttacrox_ {17}

## "phrases" ## nav_bar_button ## tphrse ##
_httpicontphrsegr_ {_httpimg_/tphrsegr.gif}
_httpicontphrseof_ {_httpimg_/tphrseof.gif}
_httpicontphrseon_ {_httpimg_/tphrseon.gif}
_widthtphrsex_ {87}
_heighttphrsex_ {17}


######################################################################
# 'about' page
package about
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textabcol_ {About this collection}

_textsubcols1_ {<p>The complete collection comprises _1_ subcollections:
<blockquote>}

_textsubcols2_ {</blockquote>
You can check (and alter) which subcollections you are 
currently using on the Preferences page.}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "about" ## green_title ## h_about ##
_httpiconhabout_ {_httpimg_/h\_about.gif}
_widthhabout_ {200}
_heighthabout_ {57}



######################################################################
# document package
package document
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textTitlepage_ {_texticonhtitle_}
_textCreatorpage_ {_texticonhauth_}
_textSubjectpage_ {_texticonhsubj_}
_textTopage_ {_texticonhto_}
_textFrompage_ {_texticonhfrom_}
_textSeriespage_ {_texticonhser_}
_textDatepage_ {_texticonhdate_}
_textHowtopage_ {_texticonhhow_}
_textOrganizationpage_ {_texticonhorg_}
_textBrowsepage_ {_texticonhbrwse_}
_textPeoplepage_ {_texticonhpeople_}
_textLanguagepage_ {_texticonhlanguage_}
_textAcronympage_ {_texticonhacronym_}
_textPhrasepage_ {_texticonhphrases_}

_texticonhtitle_ {Titles A-Z}
_texticonhauth_ {Authors A-Z}
_texticonhsubj_ {Subjects}
_texticonhto_ {To}
_texticonhfrom_ {From}
_texticonhser_ {Series}
_texticonhdate_ {Dates}
_texticonhhow_ {How to}
_texticonhorg_ {Organizations}
_texticonhbrwse_ {Browse}
_texticonhpeople_ {People A-Z}
_texticonhlanguage_ {Languages}
_texticonhacronym_ {Acronyms}
_texticonhphrases_ {Phrases}

_texticonopenbookshelf_ {close this section of the library}
_texticonclosedbookshelf_ {open this section of the library and view contents}
_texticonopenbook_ {close this book}
_texticonclosedfolder_ {Open this folder and view contents}
_texticonclosedfolder2_ {open sub-section: }
_texticonopenfolder_ {close this folder}
_texticonopenfolder2_ {close sub-section: }
_texticonsmalltext_ {View this section of the text}
_texticonsmalltext2_ {view text: }
_texticonpointer_ {current section}
_texticondetach_ {Open this page in a new window}
_texticonhighlight_ {Highlight search terms}
_texticonnohighlight_ {Don't highlight search terms}
_texticoncontracttoc_ {Collapse table of contents}
_texticonexpandtoc_ {Expand table of contents}
_texticonexpandtext_ {Display all text}
_texticoncontracttext_ {Display text only for currently selected section}
_texticonwarning_ {<b>Warning: </b>}
_texticoncont_ {continue?}

_textltwarning_ {
<p><center>
<table cellspacing=0 cellpadding=0 width=_pagewidth_>
<tr valign=top><td>_iconwarning_Expanding the text here will generate a large 
amount of data for your browser to display _imagecont_
</td></tr></table></center>
}

_textgoto_ {go to page}
_textintro_ { <i>(introductory text)</i>}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "titles a-z" ## green_title ## h_title ##
_httpiconhtitle_ {_httpimg_/h\_title.gif}
_widthhtitle_ {200}
_heighthtitle_ {57}

## "authors a-z" ## green_title ## h_auth ##
_httpiconhauth_ {_httpimg_/h\_auth.gif}
_widthhauth_ {200}
_heighthauth_ {57}

## "subjects" ## green_title ## h_subj ##
_httpiconhsubj_ {_httpimg_/h\_subj.gif}
_widthhsubj_ {200}
_heighthsubj_ {57}

## "to" ## green_title ## h_to ##
_httpiconhto_ {_httpimg_/h\_to.gif}
_widthhto_ {200}
_heighthto_ {57}

## "from" ## green_title ## h_from ##
_httpiconhfrom_ {_httpimg_/h\_from.gif}
_widthhfrom_ {200}
_heighthfrom_ {57}

## "series" ## green_title ## h_ser ##
_httpiconhser_ {_httpimg_/h\_ser.gif}
_widthhser_ {200}
_heighthser_ {57}

## "dates" ## green_title ## h_date ##
_httpiconhdate_ {_httpimg_/h\_date.gif}
_widthhdate_ {200}
_heighthdate_ {57}

## "how to" ## green_title ## h_how ##
_httpiconhhow_ {_httpimg_/h\_how.gif}
_widthhhow_ {200}
_heighthhow_ {57}

## "topics" ## green_title ## h_topic ##
_httpiconhtopic_ {_httpimg_/h\_topic.gif}
_widthhtopic_ {200}
_heighthtopic_ {57}

## "organization" ## green_title ## h_org ##
_httpiconhorg_ {_httpimg_/h\_org.gif}
_widthhorg_ {250}
_heighthorg_ {57}

## "browse" ## green_title ## h_brwse ##
_httpiconhbrwse_ {_httpimg_/h\_brwse.gif}
_widthhbrwse_ {200}
_heighthbrwse_ {57}

## "people" ## green_title ## h_people ##
_httpiconhpeople_ {_httpimg_/h\_people.gif}
_widthhpeople_ {200}
_heighthpeople_ {57}

## "languages" ## green_title ## h_lang ##
_httpiconhlanguage_ {_httpimg_/h\_lang.gif}
_widthhlanguage_ {200}
_heighthlanguage_ {57}

## "acronyms" ## green_title ## h_acro ##
_httpiconhacronym_ {_httpimg_/h\_acro.gif}
_widthhacronym_ {200}
_heighthacronym_ {57}

## "phrases" ## green_title ## h_phrse ##
_httpiconhphrse_ {_httpimg_/h\_phrse.gif}
_widthhphrse_ {200}
_heighthphrse_ {57}

## "CONTINUE?" ## top_nav_button ## cont ##
_httpiconcontoff_ {_httpimg_/contoff.gif}
_httpiconconton_ {_httpimg_/conton.gif}
_widthcontx_ {76}
_heightcontx_ {17}

## "EXPAND TEXT" ## document_button ## eallt ## 
_httpiconealltof_ {_httpimg_/ealltof.gif}
_httpiconeallton_ {_httpimg_/eallton.gif}
_widthealltx_ {65}
_heightealltx_ {30}

## "CONTRACT CONTENTS" ## document_button ## econc ##
_httpiconeconcof_ {_httpimg_/econcof.gif}
_httpiconeconcon_ {_httpimg_/econcon.gif}
_widtheconcx_ {65}
_heighteconcx_ {30}

## "DETACH" ## document_button ## edtch ##
_httpiconedtchof_ {_httpimg_/edtchof.gif}
_httpiconedtchon_ {_httpimg_/edtchon.gif}
_widthedtchx_ {65}
_heightedtchx_ {30}

## "EXPAND CONTENTS" ## document_button ## eexpc ##
_httpiconeexpcof_ {_httpimg_/eexpcof.gif}
_httpiconeexpcon_ {_httpimg_/eexpcon.gif}
_widtheexpcx_ {65}
_heighteexpcx_ {30}

## "CONTRACT TEXT" ## document_button ## etsec ##
_httpiconetsecof_ {_httpimg_/etsecof.gif}
_httpiconetsecon_ {_httpimg_/etsecon.gif}
_widthetsecx_ {65}
_heightetsecx_ {30}

## "HIGHLIGHTING" ## document_button ## ehl ##
_httpiconehlof_ {_httpimg_/ehlof.gif}
_httpiconehlon_ {_httpimg_/ehlon.gif}
_widthehlx_ {65}
_heightehlx_ {30}

## "NO HIGHLIGHTING" ## document_button ## enhl ##
_httpiconenhlof_ {_httpimg_/enhlof.gif}
_httpiconenhlon_ {_httpimg_/enhlon.gif}
_widthenhlx_ {65}
_heightenhlx_ {30}



######################################################################
# 'search' page
package query
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# this if statement produces the text 'results n1 - nn for query: querystring' or 
# 'No matches for query: querystring', depending on whether or not there were
# any matches
_textquerytitle_ {_If_(_thislast_,results _thisfirst_ - _thislast_ for query: _cgiargq_,No matches for query: _cgiargq_)}
_textnoquerytitle_ {Search page}

_texticonthispage_ {search}
_textsome_ {_If_(_cgiargb_,ranked,some)}
_textall_ {_If_(_cgiargb_,boolean,all)}
_textformsome_ {_If_(_cgiargb_,ranked,some)}
_textformall_ {_If_(_cgiargb_,natural,all)}
_texticonqueryresultsbar_ {}
_texticonsearchhistorybar_ {search history}

#alt text for query buttons
_textusequery_ {use this query}
_textfreqmsg1_ {Word count: }
_textpostprocess_ {_If_(_quotedquery_,<br><i>post-processed to find _quotedquery_</i>
)}

_textmorethan_ {More than }
_textapprox_ {About }
_textnodocs_ {No documents matched the query.}
_text1doc_ {1 document matched the query.}
_textlotsdocs_ {documents matched the query.}
_textmatches_ {Matches }
_textbeginsearch_ {Begin Search}
_textrunquery_{Run Query}
_textclearform_{Clear Form}

#these go together in form search:
#"Word or phrase  (fold, stem)  ... in field"
_textwordphrase_{Word or phrase}
_textinfield_{... in field}
_textfoldstem_{(fold, stem)}

_textadvquery_{Or enter a query directly:}
_textallfields_{All fields}
_textand_{and}
_textor_{or}
_textandnot_{and not}

# _hselection_, _jselection_, _nselection_ and _gselection_ are set from 
# within the server some or all of them may remain unset


_textsimplesearch_ {Search for _If_(_hselection_, _hselection_) _If_(_jselection_, _textjselect_) _If_(_gselection_, at _gselection_ level) _If_(_nselection_, in _nselection_ language)
which contain _querytypeselection_ of the words}

_textadvancedsearch_ {Search _If_(_hselection_, _hselection_, _defaultindextext_) _If_(_jselection_,_textjselect_) _If_(_gselection_, at _gselection_ level)_If_(_nselection_, in _nselection_ language) 
using _querytypeselection_ query}

_textformsimplesearch_ {Search for _If_(_hselection_, _hselection_) _If_(_jselection_, _textjselect_) _If_(_gselection_, at _gselection_ level) _If_(_nselection_, in _nselection_ language)
which contain _formquerytypeselection_ of}

_textformadvancedsearch_ {Search _If_(_hselection_, _hselection_, _defaultindextext_) _If_(_jselection_,_textjselect_) _If_(_gselection_, at _gselection_ level)_If_(_nselection_, in _nselection_ language) 
and display results in _formquerytypeselection_ order}


_textjselect_ {_If_(_hselection_, of) _jselection_}

_textdatesearch_ {This collection can be searched for documents within a date range, or documents that contain a particular date. This is an optional feature of the search.}
_textstartdate_ {Start (or only) date:}
_textenddate_ {End date:}
_textbc_ {B.C.E.}
_textad_ {C.E.}
_textexplaineras_{C.E. and B.C.E are alternatives for A.D. and B.C. repsectively.  These terms are considered to be culture indiscriminate, and stand for "Common Era" and "Before the Common Era"} 

_textstemon_ { (ignoring word endings)}

_textsearchhistory_ {Search History}

#text macros for search history
_textnohistory_ {Search history not available}
_texthresult_ {result}
_texthresults_ {results}
_texthallwords_ {all words}
_texthsomewords_ {some words}
_texthboolean_ {boolean}
_texthranked_ {ranked}
_texthcaseon_ {case must match}
_texthcaseoff_ {casefolded}
_texthstemon_ {stemmed}
_texthstemoff_ {unstemmed}

#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "search" ## green_title ## h_search ##
_httpiconhsearch_ {_httpimg_/h\_search.gif}
_widthhsearch_ {200}
_heighthsearch_ {57}

## "results" ## green_bar_left_aligned ## qryresb ##
_httpiconqryresb_ {_httpimg_/qryresb.gif}
_widthqryresb_ {_pagewidth_}
_heightqryresb_ {17}

## "history" ## green_bar_left_aligned ## schhistb ##
_httpiconsrchhistb_ {_httpimg_/schhistb.gif}
_widthsrchhistb_ {_pagewidth_}
_heightsrchhistb_ {17}

## "display" ## hand_made ##
_httpicondisplay_ {_httpimg_/display.gif}
_widthdisplay_ {60}
_heightdisplay_ {20}


######################################################################
# 'preferences' page
package preferences
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsearchprefs_ {Search preferences}
_textcollectionprefs_ {Collection preferences}
_textpresentationprefs_ {Presentation preferences}
_textpreferences_ {Preferences}
_textcasediffs_ {Case differences:}
_textignorecase_ { ignore case differences}
_textmatchcase_ { upper/lower case must match}
_textwordends_{Word endings:}
_textstem_ { ignore word endings}
_textnostem_ { whole word must match}
_textprefop_ {Return up to _maxdocoption_ hits with _hitsperpageoption_ hits per page.}
_textextlink_ {Access to external Web pages:}
_textintlink_ {Source documents retrieved from:}
_textlanguage_ {Interface language:}
_textencoding_ {Encoding:}
_textformat_ {Interface format:}
_textall_ {all}
_textquerymode_{Query mode:}
_textsimplemode_ { simple query mode}
_textadvancedmode_ { advanced query mode (allows boolean searching using !, &, |, and parentheses)}
_textlinkinterm_ {through intermediate page}
_textlinkdirect_ {go directly there}
_textdigitlib_ {the digital library}
_textweb_ {the web}
_textgraphical_ {Graphical}
_texttextual_ {Textual}
_textcollectionoption_ {<p>
Subcollections to include:
<br>}
_textrelateddocdisplay_ {display related documents}
_textfcoption_ { Include navigation bar at top of document pages}
_texthloption_ { Highlight search terms within document text}
_textsearchhistory_{Search history:}
_texthistorydisplay_ { display _historynumrecords_search history records}
_textnohistorydisplay_{ do not display search history}

_texttypesearch_ {Type of search:}
_texttextsearch_ {text search}
_textformsearch_ {form search}
_textqueryboxsize_ {Query box size:}
_textregbox_{ regular query box}
_textbigbox_{ large query box}
_textformtype_ {Form type:}
_textsimple_{ simple}
_textadvanced_ { advanced}

# used in "with 4 fields" in the form search box
_textwith_{with}
_textfields_{fields}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "preferences" ## green_title ## h_pref ##
_httpiconhpref_ {_httpimg_/h\_pref.gif}
_widthhpref_ {200}
_heighthpref_ {57}


######################################################################
# 'help' page -- this is lower priority for translating than the
# rest of this file
package help
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textHelp_ {Help}
_textSearchshort_ {search for particular words}
_textSeriesshort_ {access publications by series}
_textDateshort_ {access publications by date}
_textSubjectshort_ {access publications by subject}
_textToshort_ {access publications by To field}
_textFromshort_ {access publications by From field}
_textTitleshort_ {access publications by title}
_textBrowseshort_ {browse publications}
_textCreatorshort_ {access publications by author}
_textOrganizationshort_ {access publications by organization}
_textHowtoshort_ {access publications by how to listing}
_textTopicshort_ {access publications by topic}
_textPeopleshort_ {access publications by people}
_textLanguageshort_ {access publications by language}
_textAcronymshort_ {access publications by acronym occurance}
_textPhraseshort_ {browse phrases occurring in publications}
_textdefaultshorttext_ {undefined classification}

_textSearchlong_ { <p>You can <i>search for particular words</i> that
appear in the text from the "search" page. This is the first page that
comes up when you begin, and can be reached from other pages by pressing
the <i>search</i> button.  }

_textTitlelong_ { <p>You can <i>access publications by title</i> by
pressing the <i>titles a-z</i> button.  This brings up a list of books in
alphabetic order.  }

_textOrganizationlong_ { <p>You can <i>access publications by
organization</i> by pressing the <i>organization</i> button.  This brings
up a list of organizations.  }

_textHowtolong_ { <p>You can <i>access publications by how to listing</i>
by pressing the <i>how to</i> button.  This brings up a list of how to
strings.  }

_textCreatorlong_ { <p>You can <i>access publications by author</i> by
pressing the <i>authors a-z</i> button.  This brings up a list of books,
sorted by author name.  }

_textTopiclong_ { <p>You can <i>access publications by topic</i> by
pressing the <i>topic</i> button.  This brings up a list of topics to
browse.  }

_textSubjectlong_ { <p>You can <i>access publications by subject</i> by
pressing the <i>subjects</i> button.  This brings up a list of subjects,
represented by bookshelves.  }

_textTolong_ { <p>You can <i>access publications by To field</i> by
pressing the <i>to</i> button.  This brings up a list of addressees.  }

_textFromlong_ { <p>You can <i>access publications by From field</i> by
pressing the <i>from</i> button.  This brings up a list of senders.  }

_textSerieslong_ { <p>You can <i>access publications by series</i> by
pressing the <i>series</i> button.  This brings up a list of those series
which are currently in the collection.  }

_textDatelong_ { <p>You can <i>access publications by date</i> by pressing
the <i>dates</i> button.  This brings up a list of all the issues, sorted
chronologically.  }

_textBrowselong_ { <p>You can <i>browse publications</i> by pressing the
<i>browse</i> button.  }

_textPeoplelong_ { <p>You can <i>access publications by people</i> by
pressing the <i>people a-z</i> button.  This brings up a list of entries,
sorted by surname.  }

_textLanguagelong_ { <p>You can <i>access publications by language</i> by
pressing the <i>languages</i> button.  This brings up a list of entries,
sorted by language.  }

_textAcronymlong_ { <p>You can <i>access publications by acronym occurance</i> by
pressing the <i>acronyms</i> button.  This brings up a list of the acronyms,
and the places that they occur.  }

_textPhraselong_ { <p>You can <i>browse phrases occurring in publications</i> by
pressing the <i>phrases</i> button.  This uses the phind phrase browser.  }

_textdefaultlongtext_ { <p>Click on the <i>unknown</i> button to browse
publications (listing is sorted by an unknown field).  }

_texthelptopics_ {
<h2 align=left>Topics</h2>
<ul>
  <li><a href="\#finding-information">_textsimplehelpheading_</a>
  _topicreadingdocs_
  <li><a href="\#searching">How to search for particular words</a>
<ul>
  <li><a href="\#query-terms">Search terms</a>
  <li><a href="\#query-type">Query type</a>
  <li><a href="\#scope-of-queries">Scope of queries</a>
</ul>
   <li><a href="\#datesearching">Searching with dates</a>
<ul>
  <li><a href="\#datesearch-howto">How to use date search</a>	
  <li><a href="\#datesearch-results">How date search results work</a>
</ul> 		
  <li><a href="\#preferences">_textchangeprefs_</a>
<ul>
  <li><a href="\#col-prefs">Collection preferences</a>
  <li><a href="\#lang-prefs">Language preferences</a>
  <li><a href="\#pres-prefs">Presentation preferences</a>
  <li><a href="\#search-prefs">Search preferences</a>
</ul>
</ul>
}

# there are 4 versions of this section of the help text.
# which version is used is currently set within the server
# (it should probably use the macro language e.g. [type=book])
# 1 = html (like fao collections) -- section is empty
# 2 = book (like hdl collection) -- macros beginning with book
# 3 = bibliographic (like csbib) -- macros beginning with bib
# 4 = standard (like gberg) -- the default

_topicreadingdocs_ {<li><a href="\#reading-docs">_textreadingdocs_</a>}

_textreadingdocs_ {How to read the documents}
_booktextreadingdocs_ {How to read the books}
_bibtextreadingdocs_ {Getting more information on a bibliography item}

_texthelpreadingdocs_ {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>You can tell when you have arrived at an individual document because its
title and author appear at the top left of the page. Beside these is the
number of the current page, a box that allows you to select a new page, and
forward and backward arrows.

<p>Underneath is the text of the current section. When you have read
through it, there are arrows at the bottom to take you on to the next
section or back to the previous one.

<p>Below the title and author are three buttons. Click on <i>expand
text</i> to expand out the whole text of the current document. If the
document is large, this could take a long time and use a lot of memory!
Click on <i>detach</i> to make a new browser window for this
document. (This is useful if you want to compare documents, or read two at
once.)  Finally, when you do a search the words you search for are
highlighted.  Click on <i>no highlighting</i> to remove the highlighting.
<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_httpiconmore_" border="0"></td><td>Click on the arrow to go to the next section ...</td></tr>
<tr><td colspan=2><img src="_httpiconless_" border="0"></td><td>... or back to the previous section</td></tr>
<tr><td><img src="_document:httpiconealltof_" border="0"></td><td><img 
src="_document:httpiconetsecof_" border="0"></td><td>Display all text, or not</td></tr>
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Open this page in a new window</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Highlight search terms, or not</td></tr>
</table>

}

_booktexthelpreadingdocs_ {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>You can tell when you have arrived at an individual book because there
is a photograph of its front cover at the top left of the page.  Beside the
photograph is a table of contents with an arrow marking where you are.
This table is expandable: click on the folders to open them or close them.
Click on the open book at the top to close it.

<p>Underneath is the text of the current section.  When you have read
through it, there are arrows at the bottom to take you on to the next
section or back to the previous one.

<p>Below the photograph are four buttons. Click on <i>expand text</i> to
expand out the whole text of the current section, or book.  If the book is
large, this could take a long time and use a lot of memory! Click on
<i>expand contents</i> to expand out the whole table of contents so that
you can see the titles of all chapters and subsections. Click on
<i>detach</i> to make a new browser window for this book.  (This is useful
if you want to compare books, or read two at once.) Finally, when you do a
search the words you search for are highlighted. Click on <i>no
highlighting</i> to remove highlighting.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_httpiconbshelf_" border="0"></td><td>Open this bookshelf</td></tr>
<tr><td><img src="_httpiconopenbook_" border="0"></td><td><img 
src="_httpiconbook_" border="0"></td><td>Open/close this book</td></tr>
<tr><td colspan=2><img src="_httpiconitext_" border="0"></td><td>View this section of the text</td></tr>
<tr><td><img src="_document:httpiconealltof_" border="0"></td><td><img 
src="_document:httpiconetsecof_" border="0"></td><td>Display all text, or not</td></tr>
<tr><td><img src="_document:httpiconeexpcof_" border="0"></td><td><img
src="_document:httpiconeconcof_" border="0"></td><td>Expand table of contents, or not</td></tr>
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Open this page in a new window</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Highlight search terms, or not</td></tr>
<tr><td colspan=2><img src="_httpiconmore_" border="0"></td><td>Click the arrow to go to the next section ...</td></tr>
<tr><td colspan=2><img src="_httpiconless_" border="0"></td><td>... or back to the previous section</td></tr>
</table>
}

_bibtexthelpreadingdocs_ {
<p>_iconblankbar_
<a name=reading-docs>
<h2>_textreadingdocs_</h2>

<p>Some bibliography items contain more information, such as an abstract.
You can tell from the query response page if this is the case because they 
are shown with the _icontext_ icon instead of the _iconblanktext_ icon.

<p>Clicking on the _icontext_ icon will give you more information about the
bibliography item.

<p> Below the bibliography item are two buttons. Click on <i>detach</i> to 
make a new browser window for this book. (This is useful if you want to compare
bibliography items.) Finally, when you do a search the words you search for are 
highlighted. Click on <i>no highlighting</i> to remove the highlighting.

<p>
<table cellspacing="0" cellpadding="2" border="0">
<tr><td colspan=2><img src="_document:httpiconedtchof_" border="0"></td><td>Open this page in a new window</td></tr>
<tr><td><img src="_document:httpiconehlof_" border="0"></td><td><img
src="_document:httpiconenhlof_" border="0"></td><td>Highlight search terms, or not</td></tr>
</table>
}

_texthelpsearching_ {
<h2>How to search for particular words</h2>
<p>
  From the search page, you make a query in these simple steps:<p>
  
  <ol><li>Specify what items you want to search
      <li>Say whether you want to search for all or just some of the words
      <li>Type in the words you want to search for
      <li>Click the <i>Begin Search</i> button
  </ol>

<p>When you make a query, the titles of twenty matching documents will be shown.
There is a button at the end to take you on to the next twenty documents.  From
there you will find buttons to take you on to the third twenty or back to the
first twenty, and so on.  Click the title of any document, or the little button
beside it, to see it.

<p>A maximum of 100 is imposed on the number of
  documents returned.  You can change this number by clicking the
  <i>preferences</i> button at the top of the page.<p>

<p>_iconblankbar_
<a name=query-terms>
<h3>Search terms</h3>

<p>Whatever you type into the query box is interpreted as a list of words
called "search terms."  Each term contains nothing but alphabetic characters
and digits.  Terms are separated by white space.  If any other characters such
as punctuation appear, they serve to separate terms just as though they were
spaces.  And then they are ignored.  You can't search for words that include
punctuation.

<p>For example, the query<p>
    <ul><kbd>Agro-forestry in the Pacific Islands: Systems for Sustainability (1993)</kbd></ul>
      <p>will be treated the same as<p>
      <ul><kbd>Agro forestry in the Pacific Islands  Systems for Sustainability  1993 </kbd></ul><p>

<p>_iconblankbar_
<a name=query-type>
<h3>Query type</h3>

<p>There are two different kinds of query.

<ul>
  <li>Queries for <b>all</b> of the words.  These look for documents (or
      chapters, or titles) that contain all the words you have specified.
      Documents that satisfy the query are displayed, in alphabetical
      order.<p>

  <li>Queries for <b>some</b> of the words.  Just list some terms that are
      likely to appear in the documents you are looking for.  Documents are
      displayed in order of how closely they match the query.  When determining

      the degree of match,

      <p><ul>
        <li> the more search terms a document contains, the closer it matches;
        <li> rare terms are more important than common ones;
        <li> short documents match better than long ones.
      </ul>
</ul>

<p>Use as many search terms as you like--a whole sentence, or even a
whole paragraph.  If you specify only
one term, documents will be ordered by its frequency of occurrence.<p>
_texthelpscope_
}

_textdatesearch_{Searching with Dates}

_texthelpdatesearch_{<h2>_textdatesearch_</h2>
Date search lets you find documents that, as well as matching your search 
terms, are about events within a certain timeframe.  You can search for 
documents from a certain year or from a range of years.  Note that you do not 
have to have any search terms -- you can search by date alone; and also that 
you do not have to use dates in your search, if you do not type any dates in it
 is just the same as if the date search didn't exist.<p>

<p>_iconblankbar_
<a name=datesearch-howto>
<h3>How to use this feature:</h3>
<ul>
   <li>To search for documents about a single year:<p>
   <ul>
       <li>Type in any ordinary search terms as you normally would.	
       <li>Type the year you want into the "Start (or only) date" box.
       <li>If your date is from before the common era (also known as before 
	   Christ), choose the B.C.E option from the pulldown menu next to that
	   box.
       <li>Begin your search as you ordinarily would.
   </ul>
<p><li>To search for documents about a time period or range of years:<p>
   <ul>
       <li>Type in any ordinary search terms as you normally would.
       <li>Type the earlier date into the "Start (or only) date" box.
       <li>Type the later date into the "End date" box.
       <li>Select "B.C.E from the pulldown menu next to any date from before 
           the common era (also known as before Christ).
       <li>Begin your search as you ordinarily would.
   </ul>    
</ul><p>

<p>_iconblankbar_
<a name=datesearch-results>
<h3>The way results of your search work</h3>

Generally speaking a search for documents about the year 1903 will not return documents that, say, reference books written in 1903, just documents about 1903.  However, the way that the documents' dates are found, it will return documents that have a date range (for example 1899-1911) that includes 1903, and also those documents which, as part of their text name the century that 1903 is a part of (for example 20th century or twentieth century).  This means that for some documents, the dates in your search will not actually appear in the document text.  For a range search, all of this applies to every date in the range.<p>
}

_textchangeprefs_ {Changing your preferences}

_texthelppreferences_ {<h2>_textchangeprefs_</h2>

<p>When you click the <i>preferences</i> button at the top of the page you will
be able to change some features of the interface to suit your own requirements.

<p>_iconblankbar_
<a name=col-prefs>
<h3 align=left>Collection preferences</h3>

Some collections comprise several subcollections, which can be searched
independently or together, as one unit.  If so, you can select which
subcollections to include in your searches on the Preferences page.

<p>_iconblankbar_
<a name=lang-prefs>
<h3 align=left>Language preferences</h3>

Each collection has a default presentation language, but you can switch to
a different language if you like.  You can also alter the encoding scheme
used by Greenstone for output to the browser -- the software chooses
sensible defaults, but with some browsers better visual results can be used
by switching to a different encoding scheme. All collections allow you to
switch from the standard graphical interface format to a textual one. This
is particularly useful for visually impaired users who use large screen
fonts or speech synthesizers for output.

<p>_iconblankbar_
<a name=pres-prefs>
<h3 align=left>Presentation preferences</h3>

Depending on the particular collection, there may be several options you can
set that control the presentation.

<p>Collections of Web pages allow you to suppress the Greenstone navigation bar at
the top of each document page, so that once you have done a search you land at
the exact Web page that matches without any Greenstone header.  To do another
search you will have to use your browser's "back" button.  These collections
also allow you to suppress Greenstone's warning message when you click a link
that takes you out of the digital library collection and on to the Web itself.
And in some Web collections you can control whether the links on the "Search
Results" page take you straight to the actual URL in question, rather than to
the digital library's copy of the page.

<p>_iconblankbar_
<a name=search-prefs>
<h3 align=left>Search preferences</h3>
<p>Two pairs of buttons control the kind of text matching in the searches that
you make. The first set (labeled "case differences") controls whether upper and
lower case must match.  The second ("word endings") controls whether to ignore
word endings or not.  It is possible to get a large query box, so that you can
easily do paragraph-sized searching. It is surprisingly quick to search for
large amounts of text.

<p>For example, if the buttons <i>ignore case differences</i> and
<i>ignore word endings</i> are selected, the query<p>
    <ul><kbd>African building</kbd></ul>
      <p>will be treated the same as<p>
      <ul><kbd>africa builds</kbd></ul><p>
      because the uppercase letter in "African" will be transformed to
      lowercase, and  the suffixes "n" and "ing" will be removed from
      "African" and "building" respectively (also, "s" would be removed from
      "builds").

<p>You can switch to an "advanced" query mode which allows you to combine terms
using AND (&amp;), OR (|), and NOT (!). This allows you to specify more precise
queries. You can turn the search history feature, which shows you your last few
queries.  This makes it easy to repeat slightly modified versions of previous
queries. Finally, you can control the number of hits returned, and the
number presented on each screenful.
}

_texttanumbrowseoptions_ {There are _numbrowseoptions_ ways to find information in this collection:}

_textsimplehelpheading_ {How to find information}

_texthelpscope_ {
<p>_iconblankbar_
<a name=scope-of-queries>
<h3 align=left>Scope of queries</h3>

<p>
In most collections you can choose different indexes to search. For example, there might
be author or title indexes. Or there might be chapter or paragraph indexes. Generally,
the full matching document is returned regardless of which index you search.
<p>If documents are books, they will be opened at the appropriate place.
}
