###########################################################################
#
# win32 makefile -- lib
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = ..
STLPATH = f:\stlport

AR = lib
CC = cl
CPPFLAGS =
# note that if compiling with a newer version of VC++ than 4.2 we'll
# use the built in STL and so the following definitions should not 
# be defined - this setup is for use with VC++ 4.2 and STLPort
# GSDL_NAMESPACE_BROKEN
# GSDL_USE_IOS_H
# __STL_NO_NEW_IOSTREAMS
DEFS = -DQUIET -D__WIN32__ -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H \
	-DSHORT_SUFFIX -DPARADOCNUM -DHAVE_CONFIG_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = -I$(GSDLHOME)\packages\mg\lib -I$(STLPATH)

COMPILE = $(CC) -c $(CPPFLAGS) $(DEFS) $(INCLUDES)

.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 

HEADERS = \
  cfgread.h      fileutil.h     gsdlunicode.h  text_t.h \
  display.h      gsdlconf.h     gsdltimes.h    gsdltools.h

SOURCES = \
  cfgread.cpp      fileutil.cpp     text_t.cpp \
  display.cpp      gsdlunicode.cpp  gsdltimes.cpp  gsdltools.cpp

OBJECTS = \
  cfgread.obj        fileutil.obj       text_t.obj   \
  display.obj        gsdlunicode.obj    gsdltimes.obj  gsdltools.obj

all: gsdllib.lib

gsdllib.lib : $(OBJECTS)
	if EXIST gsdllib.lib del gsdllib.lib
	$(AR) /out:gsdllib.lib $(OBJECTS)

clean:
	del *.obj 
	del gsdllib.lib

install:
