/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.util.Enumeration;
import java.util.Vector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.Filter;
import jaws.filterPackage.Range;

public class SelectFilter
extends Filter
implements OptionHandler {
    protected int m_Attribute;
    protected Range m_Values;
    protected double m_Value;
    protected boolean m_Inverse;

    public SelectFilter() {
        this.m_InputFormat = null;
        this.setOutputFormat(null);
        this.b_NewBatch = true;
        this.m_Attribute = -1;
        this.m_Values = new Range();
        this.m_Value = 0.0;
        this.m_Inverse = false;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tChoose attribute to be used for selection.", "C", 1, "-C <num>"));
        vector.addElement(new Option("\tNumeric value to be used for selection on numeric attribute.\n\t(Instances with values smaller than given value.)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tRange of label indices to be used for selection on nominal attribute.\n\t(First and last are valid indexes.)", "L", 1, "-L <index1,index2-index4,...>"));
        vector.addElement(new Option("\tInvert matching sense.", "V", 0, "-V"));
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            if (string.toLowerCase().equals("last")) {
                this.setAttributeIndex(0);
            } else if (string.toLowerCase().equals("first")) {
                this.setAttributeIndex(1);
            } else {
                this.setAttributeIndex(Integer.parseInt(string));
            }
        } else {
            this.setAttributeIndex(-1);
        }
        String string2 = Utils.getOption('S', stringArray);
        if (string2.length() != 0) {
            this.setSplitPoint(new Double(string2));
        } else {
            this.setSplitPoint(0.0);
        }
        String string3 = Utils.getOption('L', stringArray);
        if (string3.length() != 0) {
            this.setNominalIndices(string3);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.m_InputFormat != null) {
            this.inputFormat(this.m_InputFormat);
        }
    }

    public boolean inputFormat(Instances instances) throws Exception {
        this.m_InputFormat = new Instances(instances, 0);
        if (this.m_Attribute == -1) {
            this.setAttributeIndex(this.m_InputFormat.numAttributes());
        }
        if (!this.isNumeric() && !this.isNominal()) {
            throw new Exception("Can only handle numeric or nominal attributes.");
        }
        this.m_Values.setUpper(this.m_InputFormat.attribute(this.m_Attribute).numValues() - 1);
        this.setOutputFormat(this.m_InputFormat);
        this.b_NewBatch = true;
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        if (instance.isMissing(this.m_Attribute)) {
            return false;
        }
        if (this.isNumeric()) {
            if (!this.m_Inverse) {
                if (Utils.sm(instance.value(this.m_Attribute), this.m_Value)) {
                    this.push((Instance)instance.copy());
                    return true;
                }
            } else if (Utils.grOrEq(instance.value(this.m_Attribute), this.m_Value)) {
                this.push((Instance)instance.copy());
                return true;
            }
        }
        if (this.isNominal() && this.m_Values.isInRange((int)instance.value(this.m_Attribute))) {
            this.push((Instance)instance.copy());
            return true;
        }
        return false;
    }

    public boolean isNominal() {
        if (this.m_InputFormat == null) {
            return false;
        }
        return this.m_InputFormat.attribute(this.m_Attribute).isNominal();
    }

    public boolean isNumeric() {
        if (this.m_InputFormat == null) {
            return false;
        }
        return this.m_InputFormat.attribute(this.m_Attribute).isNumeric();
    }

    public int getAttributeIndex() {
        return this.m_Attribute + 1;
    }

    public void setAttributeIndex(int n) {
        this.m_Attribute = n - 1;
    }

    public double getSplitPoint() {
        return this.m_Value;
    }

    public void setSplitPoint(double d) {
        this.m_Value = d;
    }

    public boolean getInvertSelection() {
        return this.m_Values.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Inverse = bl;
        this.m_Values.setInvert(bl);
    }

    public String getNominalIndices() {
        return this.m_Values.getRanges();
    }

    public void setNominalIndices(String string) throws Exception {
        this.m_Values.setRanges(string);
    }

    public void setNominalIndicesArr(int[] nArray) throws Exception {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = n == 0 ? String.valueOf(nArray[n] + 1) : String.valueOf(string) + "," + (nArray[n] + 1);
            ++n;
        }
        this.setNominalIndices(string);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new SelectFilter(), stringArray);
                return;
            }
            Filter.filterFile(new SelectFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

