/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.util.Enumeration;
import java.util.Vector;
import jaws.corePackage.Attribute;
import jaws.corePackage.FastVector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.Filter;

public class MakeIndicatorFilter
extends Filter
implements OptionHandler {
    private int theAttIndex = -1;
    private int theValIndex = -1;
    private boolean m_Numeric = true;

    public boolean inputFormat(Instances instances) throws Exception {
        this.m_InputFormat = new Instances(instances, 0);
        if (this.theAttIndex < 0) {
            throw new Exception("No attribute chosen.");
        }
        if (!this.m_InputFormat.attribute(this.theAttIndex).isNominal()) {
            throw new Exception("Chosen attribute not nominal.");
        }
        if (this.m_InputFormat.attribute(this.theAttIndex).numValues() < 2) {
            throw new Exception("Chosen attribute has less than two values.");
        }
        if (this.theValIndex < 0) {
            throw new Exception("Index of value undefined.");
        }
        this.b_NewBatch = true;
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        Instance instance2;
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        if ((int)(instance2 = (Instance)instance.copy()).value(this.theAttIndex) == this.theValIndex) {
            instance2.setValue(this.theAttIndex, 1.0);
        } else {
            instance2.setValue(this.theAttIndex, 0.0);
        }
        this.push(instance2);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSets the attribute index.", "C", 1, "-C <col>"));
        vector.addElement(new Option("\tSets the value's index.", "V", 1, "-V <index>"));
        vector.addElement(new Option("\tSet if new boolean attribute nominal.", "N", 0, "-V <index>"));
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string;
        String string2 = Utils.getOption('C', stringArray);
        if (string2.length() != 0) {
            if (string2.toLowerCase().equals("last")) {
                this.setAttIndex(0);
            } else if (string2.toLowerCase().equals("first")) {
                this.setAttIndex(1);
            } else {
                this.setAttIndex(Integer.parseInt(string2));
            }
        }
        if ((string = Utils.getOption('V', stringArray)).length() != 0) {
            if (string.toLowerCase().equals("last")) {
                this.setValueIndex(0);
            } else if (string.toLowerCase().equals("first")) {
                this.setValueIndex(1);
            } else {
                this.setValueIndex(Integer.parseInt(string));
            }
        }
        boolean bl = this.m_Numeric = !Utils.getFlag('N', stringArray);
        if (this.m_InputFormat != null) {
            this.inputFormat(this.m_InputFormat);
        }
    }

    public int getAttIndex() {
        return this.theAttIndex + 1;
    }

    public void setAttIndex(int n) {
        this.theAttIndex = n - 1;
    }

    public int getValueIndex() {
        return this.theValIndex + 1;
    }

    public void setValueIndex(int n) {
        this.theValIndex = n - 1;
    }

    public void setNumeric(boolean bl) {
        this.m_Numeric = bl;
    }

    public boolean getNumeric() {
        return this.m_Numeric;
    }

    private void setOutputFormat() {
        try {
            FastVector fastVector = new FastVector(this.m_InputFormat.numAttributes());
            int n = 0;
            while (n < this.m_InputFormat.numAttributes()) {
                Attribute attribute = this.m_InputFormat.attribute(n);
                if (n != this.theAttIndex) {
                    fastVector.addElement(attribute.copy());
                } else if (this.m_Numeric) {
                    fastVector.addElement(new Attribute(attribute.name()));
                } else {
                    FastVector fastVector2 = new FastVector(2);
                    fastVector2.addElement("'not_" + MakeIndicatorFilter.removeQuotes(attribute.value(this.theValIndex)) + "'");
                    fastVector2.addElement("'" + MakeIndicatorFilter.removeQuotes(attribute.value(this.theValIndex)) + "'");
                    fastVector.addElement(new Attribute(attribute.name(), fastVector2));
                }
                ++n;
            }
            Instances instances = new Instances(this.m_InputFormat.relationName(), fastVector, 0);
            instances.setClassIndex(this.m_InputFormat.classIndex());
            this.setOutputFormat(instances);
            return;
        }
        catch (Exception exception) {
            System.err.println("Problem setting new output format");
            System.exit(0);
            return;
        }
    }

    private static final String removeQuotes(String string) {
        if (string.endsWith("'") || string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new MakeIndicatorFilter(), stringArray);
                return;
            }
            Filter.filterFile(new MakeIndicatorFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

