/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.util.Enumeration;
import java.util.Vector;
import jaws.corePackage.Attribute;
import jaws.corePackage.ContingencyTables;
import jaws.corePackage.FastVector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.SpecialFunctions;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.Filter;
import jaws.filterPackage.Range;

public class DiscretiseFilter
extends Filter
implements OptionHandler {
    protected Range m_DiscretiseCols;
    protected int m_NumBins;
    protected int m_ClassIndex;
    protected double[][] m_CutPoints;
    protected boolean b_UseMDL;
    protected boolean b_MakeBinary;
    protected boolean b_UseBetterEncoding;
    protected boolean b_UseKononenko;

    public DiscretiseFilter() {
        this.m_InputFormat = null;
        this.setOutputFormat(null);
        this.b_NewBatch = true;
        this.b_UseMDL = true;
        this.b_UseKononenko = false;
        this.b_MakeBinary = false;
        this.b_UseBetterEncoding = false;
        this.m_DiscretiseCols = new Range();
        try {
            this.setAttributeIndices("first-last");
        }
        catch (Exception exception) {
            System.err.println("Problem setting attribute indices: " + exception.getMessage());
        }
        this.m_NumBins = 10;
        this.m_ClassIndex = -1;
        this.m_CutPoints = null;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tSpecify the number of bins to divide numeric attributes into.\n\t(default 10)", "B", 1, "-B <num>"));
        vector.addElement(new Option("\tDetermine cuts using Fayyad & Irani method using this column for the class.", "C", 1, "-C <col>"));
        vector.addElement(new Option("\tSpecify list of columns to discretise. First and last are valid indexes.\n\t(default none)", "R", 1, "-R <col1,col2-col4,...>"));
        vector.addElement(new Option("\tOutput binary attributes for discretized attributes.", "D", 0, "-D"));
        vector.addElement(new Option("\tUse better encoding of split point for MDL.", "E", 0, "-E"));
        vector.addElement(new Option("\tUse Kononenko's MDL criterion.", "K", 0, "-K"));
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string;
        this.b_MakeBinary = Utils.getFlag('D', stringArray);
        this.b_UseBetterEncoding = Utils.getFlag('E', stringArray);
        this.b_UseKononenko = Utils.getFlag('K', stringArray);
        String string2 = Utils.getOption('B', stringArray);
        if (string2.length() != 0) {
            this.setBins(Integer.parseInt(string2));
            this.setUseMDL(false);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        String string3 = Utils.getOption('R', stringArray);
        if (string3.length() != 0) {
            this.setAttributeIndices(string3);
        }
        if ((string = Utils.getOption('C', stringArray)).length() != 0) {
            if (string.toLowerCase().equals("last")) {
                this.setClassIndex(0);
            } else if (string.toLowerCase().equals("first")) {
                this.setClassIndex(1);
            } else {
                this.setClassIndex(Integer.parseInt(string));
            }
            this.setUseMDL(true);
        }
        if (this.m_InputFormat != null) {
            this.inputFormat(this.m_InputFormat);
        }
    }

    public boolean inputFormat(Instances instances) throws Exception {
        this.m_InputFormat = new Instances(instances, 0);
        this.b_NewBatch = true;
        this.setOutputFormat(null);
        this.m_DiscretiseCols.setUpper(this.m_InputFormat.numAttributes() - 1);
        this.m_CutPoints = null;
        if (this.b_UseMDL) {
            if (this.m_ClassIndex >= 0) {
                this.m_InputFormat.setClassIndex(this.m_ClassIndex);
            } else if (this.m_ClassIndex == -1 && this.m_InputFormat.classIndex() < 0) {
                this.m_InputFormat.setClassIndex(this.m_InputFormat.numAttributes() - 1);
            }
            if (this.m_ClassIndex >= -1 && !this.m_InputFormat.classAttribute().isNominal()) {
                throw new Exception("Supervised discretization not possible: class is not nominal!");
            }
        }
        return false;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        if (this.m_CutPoints != null) {
            this.convertInstance(instance);
            return true;
        }
        this.m_InputFormat.add(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.m_CutPoints == null) {
            this.calculateCutPoints();
            this.setOutputFormat();
            int n = 0;
            while (n < this.m_InputFormat.numInstances()) {
                Instance instance = this.m_InputFormat.instance(n);
                this.convertInstance(instance);
                ++n;
            }
            this.m_InputFormat = new Instances(this.m_InputFormat, 0);
        }
        this.b_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public boolean getMakeBinary() {
        return this.b_MakeBinary;
    }

    public void setMakeBinary(boolean bl) {
        this.b_MakeBinary = bl;
    }

    public boolean getUseMDL() {
        return this.b_UseMDL;
    }

    public void setUseMDL(boolean bl) {
        this.b_UseMDL = bl;
    }

    public boolean getUseKononeko() {
        return this.b_UseKononenko;
    }

    public void setUseKononeko(boolean bl) {
        this.b_UseKononenko = bl;
    }

    public boolean getUseBetterEncoding() {
        return this.b_UseBetterEncoding;
    }

    public void setUseBetterEncoding(boolean bl) {
        this.b_UseBetterEncoding = bl;
    }

    public int getBins() {
        return this.m_NumBins;
    }

    public void setBins(int n) {
        this.m_NumBins = n;
    }

    public int getClassIndex() {
        return this.m_ClassIndex + 1;
    }

    public void setClassIndex(int n) {
        this.m_ClassIndex = n - 1;
    }

    public boolean getInvertSelection() {
        return this.m_DiscretiseCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_DiscretiseCols.setInvert(bl);
    }

    public String getAttributeIndices() {
        return this.m_DiscretiseCols.getRanges();
    }

    public void setAttributeIndices(String string) throws Exception {
        this.m_DiscretiseCols.setRanges(string);
    }

    public void setAttributeIndicesArr(int[] nArray) throws Exception {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = n == 0 ? String.valueOf(nArray[n] + 1) : String.valueOf(string) + "," + (nArray[n] + 1);
            ++n;
        }
        this.setAttributeIndices(string);
    }

    protected void calculateCutPoints() throws Exception {
        Instances instances = null;
        this.m_CutPoints = new double[this.m_InputFormat.numAttributes()][];
        int n = this.m_InputFormat.numAttributes() - 1;
        while (n >= 0) {
            if (this.m_DiscretiseCols.isInRange(n) && this.m_InputFormat.attribute(n).isNumeric()) {
                if (this.b_UseMDL) {
                    if (instances == null) {
                        instances = new Instances(this.m_InputFormat);
                    }
                    this.calculateCutPointsByMDL(n, instances);
                } else {
                    this.calculateCutPointsByBinning(n);
                }
            }
            --n;
        }
    }

    protected void calculateCutPointsByMDL(int n, Instances instances) throws Exception {
        instances.sort(instances.attribute(n));
        int n2 = instances.numInstances();
        int n3 = 0;
        while (n3 < instances.numInstances()) {
            if (instances.instance(n3).isMissing(n)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        this.m_CutPoints[n] = this.cutPointsForSubset(instances, n, 0, n2);
    }

    private boolean KononenkosMDL(double[] dArray, double[][] dArray2, double d, int n) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3] > 0.0) {
                ++n2;
            }
            ++n3;
        }
        double d4 = SpecialFunctions.log2Binomial(d + (double)n2 - 1.0, n2 - 1);
        double d5 = SpecialFunctions.log2Multinomial(d, dArray);
        double d6 = d5 + d4;
        int n4 = 0;
        while (n4 < dArray2.length) {
            double d7 = Utils.sum(dArray2[n4]);
            d2 += SpecialFunctions.log2Binomial(d7 + (double)n2 - 1.0, n2 - 1);
            d3 += SpecialFunctions.log2Multinomial(d7, dArray2[n4]);
            ++n4;
        }
        double d8 = Utils.log2(n) + d2 + d3;
        return Utils.gr(d6, d8);
    }

    private boolean FayyadAndIranisMDL(double[] dArray, double[][] dArray2, double d, int n) {
        double d2 = ContingencyTables.entropy(dArray);
        double d3 = ContingencyTables.entropyConditionedOnRows(dArray2);
        double d4 = d2 - d3;
        int n2 = 0;
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3] > 0.0) {
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < dArray2[0].length) {
            if (dArray2[0][n5] > 0.0) {
                ++n4;
            }
            ++n5;
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < dArray2[1].length) {
            if (dArray2[1][n7] > 0.0) {
                ++n6;
            }
            ++n7;
        }
        double d5 = ContingencyTables.entropy(dArray2[0]);
        double d6 = ContingencyTables.entropy(dArray2[1]);
        double d7 = Utils.log2(Math.pow(3.0, n2) - 2.0) - ((double)n2 * d2 - (double)n6 * d6 - (double)n4 * d5);
        return Utils.gr(d4, (Utils.log2(n) + d7) / d);
    }

    private double[] cutPointsForSubset(Instances instances, int n, int n2, int n3) throws Exception {
        double d;
        double d2;
        double d3 = -1.7976931348623157E308;
        double d4 = -1.0;
        int n4 = -1;
        int n5 = 0;
        int n6 = n3 - n2;
        if (n6 < 2) {
            return null;
        }
        double[][] dArray = new double[2][instances.numClasses()];
        int n7 = n2;
        while (n7 < n3) {
            double[] dArray2 = dArray[1];
            int n8 = (int)instances.instance(n7).classValue();
            dArray2[n8] = dArray2[n8] + 1.0;
            ++n7;
        }
        double[] dArray3 = new double[instances.numClasses()];
        System.arraycopy(dArray[1], 0, dArray3, 0, instances.numClasses());
        double d5 = d2 = ContingencyTables.entropy(dArray3);
        double[][] dArray4 = new double[2][instances.numClasses()];
        int n9 = n2;
        while (n9 < n3 - 1) {
            double[] dArray5 = dArray[0];
            int n10 = (int)instances.instance(n9).classValue();
            dArray5[n10] = dArray5[n10] + 1.0;
            double[] dArray6 = dArray[1];
            int n11 = (int)instances.instance(n9).classValue();
            dArray6[n11] = dArray6[n11] - 1.0;
            if (Utils.sm(instances.instance(n9).value(n), instances.instance(n9 + 1).value(n))) {
                d3 = instances.instance(n9).value(n);
                double d6 = ContingencyTables.entropyConditionedOnRows(dArray);
                if (Utils.sm(d6, d5)) {
                    d4 = d3;
                    d5 = d6;
                    n4 = n9;
                    System.arraycopy(dArray[0], 0, dArray4[0], 0, instances.numClasses());
                    System.arraycopy(dArray[1], 0, dArray4[1], 0, instances.numClasses());
                }
                ++n5;
            }
            ++n9;
        }
        if (!this.b_UseBetterEncoding) {
            n5 = n6 - 1;
        }
        if (Utils.eq(d = d2 - d5, 0.0)) {
            return null;
        }
        if (this.b_UseKononenko && this.KononenkosMDL(dArray3, dArray4, n6, n5) || !this.b_UseKononenko && this.FayyadAndIranisMDL(dArray3, dArray4, n6, n5)) {
            double[] dArray7;
            double[] dArray8 = this.cutPointsForSubset(instances, n, n2, n4 + 1);
            double[] dArray9 = this.cutPointsForSubset(instances, n, n4 + 1, n3);
            if (dArray8 == null && dArray9 == null) {
                dArray7 = new double[]{d4};
            } else if (dArray9 == null) {
                dArray7 = new double[dArray8.length + 1];
                System.arraycopy(dArray8, 0, dArray7, 0, dArray8.length);
                dArray7[dArray8.length] = d4;
            } else if (dArray8 == null) {
                dArray7 = new double[1 + dArray9.length];
                dArray7[0] = d4;
                System.arraycopy(dArray9, 0, dArray7, 1, dArray9.length);
            } else {
                dArray7 = new double[dArray8.length + dArray9.length + 1];
                dArray7 = new double[dArray8.length + dArray9.length + 1];
                System.arraycopy(dArray8, 0, dArray7, 0, dArray8.length);
                dArray7[dArray8.length] = d4;
                System.arraycopy(dArray9, 0, dArray7, dArray8.length + 1, dArray9.length);
            }
            return dArray7;
        }
        return null;
    }

    protected void calculateCutPointsByBinning(int n) {
        double d = 0.0;
        double d2 = 1.0;
        int n2 = 0;
        while (n2 < this.m_InputFormat.numInstances()) {
            Instance instance = this.m_InputFormat.instance(n2);
            if (!instance.isMissing(n)) {
                double d3 = instance.value(n);
                if (d < d2) {
                    d = d2 = d3;
                }
                if (d3 > d) {
                    d = d3;
                }
                if (d3 < d2) {
                    d2 = d3;
                }
            }
            ++n2;
        }
        double d4 = (d - d2) / (double)this.m_NumBins;
        if (d4 > 0.0) {
            double[] dArray = new double[this.m_NumBins - 1];
            int n3 = 1;
            while (n3 < this.m_NumBins) {
                dArray[n3 - 1] = d2 + d4 * (double)n3;
                ++n3;
            }
            this.m_CutPoints[n] = dArray;
        }
    }

    protected void setOutputFormat() {
        if (this.m_CutPoints == null) {
            this.setOutputFormat(null);
            return;
        }
        try {
            FastVector fastVector = new FastVector(this.m_InputFormat.numAttributes());
            int n = this.m_InputFormat.classIndex();
            int n2 = 0;
            while (n2 < this.m_InputFormat.numAttributes()) {
                if (this.m_DiscretiseCols.isInRange(n2) && this.m_InputFormat.attribute(n2).isNumeric()) {
                    if (!this.b_MakeBinary) {
                        FastVector fastVector2 = new FastVector(1);
                        if (this.m_CutPoints[n2] == null) {
                            fastVector2.addElement("'All'");
                        } else {
                            int n3 = 0;
                            while (n3 <= this.m_CutPoints[n2].length) {
                                if (n3 == 0) {
                                    fastVector2.addElement("'(-inf-" + Utils.doubleToString(this.m_CutPoints[n2][n3], 6) + "]'");
                                } else if (n3 == this.m_CutPoints[n2].length) {
                                    fastVector2.addElement("'(" + Utils.doubleToString(this.m_CutPoints[n2][n3 - 1], 6) + "-inf)'");
                                } else {
                                    fastVector2.addElement("'(" + Utils.doubleToString(this.m_CutPoints[n2][n3 - 1], 6) + "-" + Utils.doubleToString(this.m_CutPoints[n2][n3], 6) + "]'");
                                }
                                ++n3;
                            }
                        }
                        fastVector.addElement(new Attribute(this.m_InputFormat.attribute(n2).name(), fastVector2));
                    } else if (this.m_CutPoints[n2] == null) {
                        FastVector fastVector3 = new FastVector(1);
                        fastVector3.addElement("'All'");
                        fastVector.addElement(new Attribute(this.m_InputFormat.attribute(n2).name(), fastVector3));
                    } else {
                        if (n2 < this.m_InputFormat.classIndex()) {
                            n += this.m_CutPoints[n2].length - 1;
                        }
                        int n4 = 0;
                        while (n4 < this.m_CutPoints[n2].length) {
                            FastVector fastVector4 = new FastVector(2);
                            fastVector4.addElement("'(-inf-" + Utils.doubleToString(this.m_CutPoints[n2][n4], 6) + "]'");
                            fastVector4.addElement("'(" + Utils.doubleToString(this.m_CutPoints[n2][n4], 6) + "-inf)'");
                            fastVector.addElement(new Attribute(this.m_InputFormat.attribute(n2).name(), fastVector4));
                            ++n4;
                        }
                    }
                } else {
                    fastVector.addElement(this.m_InputFormat.attribute(n2).copy());
                }
                ++n2;
            }
            Instances instances = new Instances(this.m_InputFormat.relationName(), fastVector, 0);
            instances.setClassIndex(n);
            this.setOutputFormat(instances);
            return;
        }
        catch (Exception exception) {
            System.err.println("Problem setting new output format");
            System.exit(0);
            return;
        }
    }

    protected void convertInstance(Instance instance) throws Exception {
        Instance instance2 = new Instance(this.outputFormatPeek().numAttributes());
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_InputFormat.numAttributes()) {
            if (this.m_DiscretiseCols.isInRange(n2) && this.m_InputFormat.attribute(n2).isNumeric()) {
                int n3;
                double d = instance.value(n2);
                if (this.m_CutPoints[n2] == null) {
                    if (instance.isMissing(n2)) {
                        instance2.setMissing(n);
                    } else {
                        instance2.setValue(n, 0.0);
                    }
                    ++n;
                } else if (!this.b_MakeBinary) {
                    if (instance.isMissing(n2)) {
                        instance2.setMissing(n);
                    } else {
                        n3 = 0;
                        while (n3 < this.m_CutPoints[n2].length) {
                            if (d <= this.m_CutPoints[n2][n3]) break;
                            ++n3;
                        }
                        instance2.setValue(n, (double)n3);
                    }
                    ++n;
                } else {
                    n3 = 0;
                    while (n3 < this.m_CutPoints[n2].length) {
                        if (instance.isMissing(n2)) {
                            instance2.setMissing(n);
                        } else if (d <= this.m_CutPoints[n2][n3]) {
                            instance2.setValue(n, 0.0);
                        } else {
                            instance2.setValue(n, 1.0);
                        }
                        ++n;
                        ++n3;
                    }
                }
            } else {
                instance2.setValue(n, instance.value(n2));
                ++n;
            }
            ++n2;
        }
        instance2.setWeight(instance.weight());
        this.push(instance2);
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new DiscretiseFilter(), stringArray);
                return;
            }
            Filter.filterFile(new DiscretiseFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

