/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.util.Enumeration;
import java.util.Vector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.Filter;
import jaws.filterPackage.Range;

public class DeleteFilter
extends Filter
implements OptionHandler {
    protected Range m_DeleteCols;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tSpecify list of columns to delete. First and last are valid indexes.\n" + "\t(default none)", "R", 1, "-R <index1,index2-index4,...>"));
        vector.addElement(new Option("\tInvert matching sense (i.e. only keep specified columns)", "V", 0, "-V"));
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.m_InputFormat != null) {
            this.inputFormat(this.m_InputFormat);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean inputFormat(Instances instances) {
        this.m_InputFormat = new Instances(instances, 0);
        this.b_NewBatch = true;
        this.m_DeleteCols.setUpper(this.m_InputFormat.numAttributes() - 1);
        Instances instances2 = new Instances(instances, 0);
        try {
            int n = this.m_InputFormat.numAttributes() - 1;
            while (true) {
                if (n < 0) {
                    this.setOutputFormat(instances2);
                    return true;
                }
                if (this.m_DeleteCols.isInRange(n)) {
                    if (n == instances2.classIndex()) {
                        instances2.setClassIndex(0);
                    }
                    instances2.deleteAttributeAt(n);
                }
                --n;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            System.err.println("Jaws currently doesn't allow deleting all columns of Instances");
            System.exit(0);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean input(Instance var1_1) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        var2_2 = this.outputFormatPeek();
        var3_3 = new Instance(var2_2.numAttributes());
        var4_4 = 0;
        var5_5 = 0;
        ** GOTO lbl17
        {
            ++var4_4;
            do {
                if (this.m_DeleteCols.isInRange(var4_4)) continue block0;
                var3_3.setValue(var5_5, var1_1.value(var4_4));
                ++var4_4;
                ++var5_5;
lbl17:
                // 2 sources

            } while (var5_5 < var2_2.numAttributes());
        }
        var3_3.setWeight(var1_1.weight());
        this.push(var3_3);
        return true;
    }

    public boolean getInvertSelection() {
        return this.m_DeleteCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_DeleteCols.setInvert(bl);
    }

    public String getAttributeIndices() {
        return this.m_DeleteCols.getRanges();
    }

    public void setAttributeIndices(String string) throws Exception {
        this.m_DeleteCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) throws Exception {
        String string = "";
        int n = 0;
        while (n < nArray.length) {
            string = n == 0 ? "" + (nArray[n] + 1) : string + "," + (nArray[n] + 1);
            ++n;
        }
        this.setAttributeIndices(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new DeleteFilter(), stringArray);
                return;
            }
            Filter.filterFile(new DeleteFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public DeleteFilter() {
        this.m_InputFormat = null;
        this.setOutputFormat(null);
        this.b_NewBatch = true;
        this.m_DeleteCols = new Range();
    }
}

