/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.util.Enumeration;
import java.util.Vector;
import jaws.corePackage.Attribute;
import jaws.corePackage.FastVector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.Filter;

public class AddFilter
extends Filter
implements OptionHandler {
    protected int m_AttributeType;
    protected String m_Name;
    protected int m_Insert;
    protected FastVector m_Labels;

    public AddFilter() {
        this.m_InputFormat = null;
        this.setOutputFormat(null);
        this.m_AttributeType = 0;
        this.b_NewBatch = true;
        this.m_Insert = -1;
        this.m_Name = "unnamed";
        this.m_Labels = new FastVector(5);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSpecify where to insert the column. First and last are valid indexes.\n\t(default last)", "C", 1, "-C <index>"));
        vector.addElement(new Option("\tCreate nominal attribute with given labels\n\t(default numeric attribute)", "L", 1, "-L <label1,label2,...>"));
        vector.addElement(new Option("\tName of the new attribute.\n\t(default = 'Unnamed')", "N", 1, "-N <name>"));
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string;
        String string2;
        String string3 = Utils.getOption('C', stringArray);
        if (string3.length() != 0) {
            if (string3.toLowerCase().equals("last")) {
                this.setAttributeIndex(0);
            } else if (string3.toLowerCase().equals("first")) {
                this.setAttributeIndex(1);
            } else {
                this.setAttributeIndex(Integer.parseInt(string3));
            }
        }
        if ((string2 = Utils.getOption('L', stringArray)).length() != 0) {
            this.setNominalLabels(string2);
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            this.setAttributeName(string);
        }
        if (this.m_InputFormat != null) {
            this.inputFormat(this.m_InputFormat);
        }
    }

    public boolean inputFormat(Instances instances) {
        this.m_InputFormat = new Instances(instances, 0);
        this.b_NewBatch = true;
        Instances instances2 = new Instances(instances, 0);
        Attribute attribute = null;
        switch (this.m_AttributeType) {
            case 0: {
                attribute = new Attribute(this.m_Name);
                break;
            }
            case 1: {
                attribute = new Attribute(this.m_Name, this.m_Labels);
                break;
            }
            default: {
                System.err.println("Unknown attribute type in AddFilter");
                System.exit(0);
            }
        }
        if (this.m_Insert < 0 || this.m_Insert > this.m_InputFormat.numAttributes()) {
            this.m_Insert = this.m_InputFormat.numAttributes();
        }
        try {
            instances2.insertAttributeAt(attribute, this.m_Insert);
            this.setOutputFormat(instances2);
        }
        catch (Exception exception) {
            System.err.println("Error in inputFormat() - this should never be reached!!");
            System.exit(0);
        }
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        Instance instance2 = new Instance(this.outputFormatPeek().numAttributes());
        int n = 0;
        int n2 = 0;
        while (n < this.m_InputFormat.numAttributes()) {
            if (n == this.m_Insert) {
                ++n2;
            }
            instance2.setValue(n2, instance.value(n));
            ++n;
            ++n2;
        }
        instance2.setWeight(instance.weight());
        this.push(instance2);
        return true;
    }

    public String getAttributeName() {
        return this.m_Name;
    }

    public void setAttributeName(String string) {
        String string2 = string.trim();
        if (string2.indexOf(32) >= 0) {
            if (string2.indexOf(39) != 0) {
                string2 = string2.replace('\'', ' ');
            }
            string2 = String.valueOf('\'') + string2 + '\'';
        }
        this.m_Name = string2;
    }

    public int getAttributeIndex() {
        return this.m_Insert + 1;
    }

    public void setAttributeIndex(int n) {
        this.m_Insert = n - 1;
    }

    public String getNominalLabels() {
        String string = "";
        int n = 0;
        while (n < this.m_Labels.size()) {
            string = n == 0 ? (String)this.m_Labels.elementAt(n) : String.valueOf(string) + "," + (String)this.m_Labels.elementAt(n);
            ++n;
        }
        return string;
    }

    public void setNominalLabels(String string) throws Exception {
        String string2;
        int n;
        FastVector fastVector = new FastVector(10);
        while ((n = string.indexOf(44)) >= 0) {
            string2 = string.substring(0, n).trim();
            if (string2.equals("")) {
                throw new Exception("Invalid label list at " + string.substring(n));
            }
            fastVector.addElement(string2);
            string = string.substring(n + 1);
        }
        string2 = string.trim();
        if (!string2.equals("")) {
            fastVector.addElement(string2);
        }
        this.m_Labels = fastVector;
        if (fastVector.size() == 0) {
            this.m_AttributeType = 0;
            return;
        }
        this.m_AttributeType = 1;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new AddFilter(), stringArray);
                return;
            }
            Filter.filterFile(new AddFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

