/*
 * Decompiled with CFR 0.152.
 */
package jaws.corePackage;

import jaws.corePackage.Utils;

public final class Matrix {
    private double[][] elements;

    public Matrix(int n, int n2) {
        this.elements = new double[n][n2];
    }

    public final double getElement(int n, int n2) {
        return this.elements[n][n2];
    }

    public final int numRows() {
        return this.elements.length;
    }

    public final int numColumns() {
        return this.elements[0].length;
    }

    public final void setElement(int n, int n2, double d) {
        this.elements[n][n2] = d;
    }

    public final void setRow(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < dArray.length) {
            this.elements[n][n2] = dArray[n2];
            ++n2;
        }
    }

    public final void setColumn(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < this.elements.length) {
            this.elements[n2][n] = dArray[n];
            ++n2;
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.elements.length) {
            int n2 = 0;
            while (n2 < this.elements[n].length) {
                stringBuffer.append("\t" + Utils.doubleToString(this.elements[n][n2], 5, 3));
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public final Matrix transpose() {
        int n = this.elements.length;
        int n2 = this.elements[0].length;
        Matrix matrix = new Matrix(n2, n);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                matrix.elements[n3][n4] = this.elements[n4][n3];
                ++n4;
            }
            ++n3;
        }
        return matrix;
    }

    public final Matrix multiply(Matrix matrix) {
        int n = this.elements.length;
        int n2 = this.elements[0].length;
        int n3 = matrix.elements[0].length;
        Matrix matrix2 = new Matrix(n, n3);
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n3) {
                int n6 = 0;
                while (n6 < n2) {
                    double[] dArray = matrix2.elements[n4];
                    int n7 = n5;
                    dArray[n7] = dArray[n7] + this.elements[n4][n6] * matrix.elements[n6][n5];
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        return matrix2;
    }

    public final double[] regression(Matrix matrix) throws Exception {
        int n = this.elements[0].length;
        double[] dArray = new double[n];
        Matrix matrix2 = this.transpose();
        Matrix matrix3 = matrix2.multiply(this);
        Matrix matrix4 = matrix2.multiply(matrix);
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = matrix4.elements[n2][0];
            ++n2;
        }
        matrix3.lubksb(matrix3.ludcmp(), dArray);
        return dArray;
    }

    public final void lubksb(int[] nArray, double[] dArray) {
        int n;
        double d;
        int n2 = this.elements[0].length;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = nArray[n4];
            d = dArray[n5];
            dArray[n5] = dArray[n4];
            if (n3 != -1) {
                n = n3;
                while (n < n4) {
                    d -= this.elements[n4][n] * dArray[n];
                    ++n;
                }
            } else if (d != 0.0) {
                n3 = n4;
            }
            dArray[n4] = d;
            ++n4;
        }
        n = n2 - 1;
        while (n >= 0) {
            d = dArray[n];
            int n6 = n + 1;
            while (n6 < n2) {
                d -= this.elements[n][n6] * dArray[n6];
                ++n6;
            }
            dArray[n] = d / this.elements[n][n];
            --n;
        }
    }

    public final int[] ludcmp() throws Exception {
        int n;
        double d;
        int n2 = this.elements[0].length;
        int[] nArray = new int[this.elements.length];
        int n3 = -1;
        double[] dArray = new double[n2];
        int n4 = 0;
        while (n4 < n2) {
            d = 0.0;
            n = 0;
            while (n < n2) {
                double d2;
                double d3 = Math.abs(this.elements[n4][n]);
                if (d2 > d) {
                    d = d3;
                }
                ++n;
            }
            if (d < 1.0E-9) {
                throw new Exception("Matrix is singular!");
            }
            dArray[n4] = 1.0 / d;
            ++n4;
        }
        n = 0;
        while (n < n2) {
            double d4;
            int n5;
            int n6;
            double d5;
            int n7 = 0;
            while (n7 < n) {
                d5 = this.elements[n7][n];
                n6 = 0;
                while (n6 < n7) {
                    d5 -= this.elements[n7][n6] * this.elements[n6][n];
                    ++n6;
                }
                this.elements[n7][n] = d5;
                ++n7;
            }
            d = 0.0;
            n6 = n;
            while (n6 < n2) {
                double d6;
                d5 = this.elements[n6][n];
                n5 = 0;
                while (n5 < n) {
                    d5 -= this.elements[n6][n5] * this.elements[n5][n];
                    ++n5;
                }
                this.elements[n6][n] = d5;
                d4 = dArray[n6] * Math.abs(d5);
                if (d6 >= d) {
                    d = d4;
                    n3 = n6;
                }
                ++n6;
            }
            if (n != n3) {
                n5 = 0;
                while (n5 < n2) {
                    d4 = this.elements[n3][n5];
                    this.elements[n3][n5] = this.elements[n][n5];
                    this.elements[n][n5] = d4;
                    ++n5;
                }
                dArray[n3] = dArray[n];
            }
            nArray[n] = n3;
            if (this.elements[n][n] == 0.0) {
                throw new Exception("Matrix is singular");
            }
            if (n != n2 - 1) {
                d4 = 1.0 / this.elements[n][n];
                n5 = n + 1;
                while (n5 < n2) {
                    double[] dArray2 = this.elements[n5];
                    int n8 = n;
                    dArray2[n8] = dArray2[n8] * d4;
                    ++n5;
                }
            }
            ++n;
        }
        return nArray;
    }
}

