/*
 * Decompiled with CFR 0.152.
 */
package jaws.corePackage;

import java.io.Serializable;
import java.util.Enumeration;
import jaws.corePackage.Copyable;
import jaws.corePackage.FastVector;

public class Attribute
implements Copyable,
Serializable {
    public static final int NUMERIC = 0;
    public static final int NOMINAL = 1;
    public static final int STRING = 2;
    private String theName;
    private int theType;
    private FastVector theValues;
    private int theIndex;

    public Attribute(String string) {
        this.theName = string;
        this.theIndex = -1;
        this.theValues = null;
        this.theType = 0;
    }

    public Attribute(String string, FastVector fastVector) {
        this.theName = string;
        this.theIndex = -1;
        this.theValues = fastVector;
        if (this.theValues == null) {
            this.theValues = new FastVector();
            this.theType = 2;
            return;
        }
        this.theType = 1;
    }

    public Object copy() {
        Attribute attribute = new Attribute(this.theName);
        attribute.theIndex = this.theIndex;
        if (!this.isNominal() && !this.isString()) {
            return attribute;
        }
        attribute.theType = this.theType;
        attribute.theValues = this.theValues;
        return attribute;
    }

    public final Enumeration enumerateValues() {
        if (this.isNominal() || this.isString()) {
            return this.theValues.elements();
        }
        return null;
    }

    public final boolean equals(Attribute attribute) {
        if (!this.theName.equals(attribute.theName)) {
            return false;
        }
        if (this.isNumeric() && attribute.isNumeric()) {
            return true;
        }
        if (this.isNumeric() || attribute.isNumeric()) {
            return false;
        }
        if (this.theValues.size() != attribute.theValues.size()) {
            return false;
        }
        int n = 0;
        while (n < this.theValues.size()) {
            if (!((String)this.theValues.elementAt(n)).equals((String)attribute.theValues.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final int index() {
        return this.theIndex;
    }

    public final int indexOfValue(String string) {
        if (!this.isNominal() && !this.isString()) {
            return -1;
        }
        return this.theValues.indexOf(string);
    }

    public final boolean isNominal() {
        return this.theType == 1;
    }

    public final boolean isNumeric() {
        return this.theType == 0;
    }

    public final boolean isString() {
        return this.theType == 2;
    }

    public final String name() {
        return this.theName;
    }

    public final int numValues() {
        if (!this.isNominal() && !this.isString()) {
            return 0;
        }
        return this.theValues.size();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@attribute " + this.theName + " ");
        if (this.isNominal()) {
            stringBuffer.append('{');
            Enumeration enumeration = this.enumerateValues();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((String)enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append('}');
        } else if (this.isNumeric()) {
            stringBuffer.append("real");
        } else {
            stringBuffer.append("string");
        }
        return stringBuffer.toString();
    }

    public final int type() {
        return this.theType;
    }

    public final String value(int n) {
        if (!this.isNominal() && !this.isString()) {
            return "";
        }
        return (String)this.theValues.elementAt(n);
    }

    Attribute(String string, int n) {
        this(string);
        this.theIndex = n;
    }

    Attribute(String string, FastVector fastVector, int n) {
        this(string, fastVector);
        this.theIndex = n;
    }

    final void addValue(String string) {
        this.freshAttributeValues();
        this.theValues.addElement(string);
    }

    final void delete(int n) throws Exception {
        if (!this.isNominal() && !this.isString()) {
            throw new Exception("Can only remove value ofnominal or string attribute!");
        }
        this.freshAttributeValues();
        this.theValues.removeElementAt(n);
    }

    final void forceAddValue(String string) {
        this.theValues.addElement(string);
    }

    final void setIndex(int n) {
        this.theIndex = n;
    }

    final void setValue(int n, String string) throws Exception {
        if (!this.isNominal() && !this.isString()) {
            throw new Exception("Can only set value of nominalor string attribute!");
        }
        this.freshAttributeValues();
        this.theValues.setElementAt(string, n);
    }

    private void freshAttributeValues() {
        this.theValues = (FastVector)this.theValues.copy();
    }
}

