/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import java.util.Enumeration;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.DistributionClassifier;
import jaws.evaluationPackage.Evaluation;

public class ZeroR
extends DistributionClassifier {
    private int theClassValue;
    private double[] theCounts;
    private Instances theInstances;

    public void buildClassifier(Instances instances) throws Exception {
        this.theInstances = instances;
        this.theClassValue = 0;
        if (instances.classAttribute().isNumeric()) {
            this.theCounts = null;
        } else {
            this.theCounts = new double[instances.numClasses()];
            int n = 0;
            while (n < this.theCounts.length) {
                this.theCounts[n] = 1.0;
                ++n;
            }
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (instance.classIsMissing()) continue;
            if (instances.classAttribute().isNominal()) {
                int n = (int)instance.classValue();
                this.theCounts[n] = this.theCounts[n] + instance.weight();
                continue;
            }
            this.theClassValue = (int)((double)this.theClassValue + instance.weight() * instance.classValue());
        }
        if (instances.classAttribute().isNumeric()) {
            this.theClassValue = (int)((double)this.theClassValue / instances.sumOfWeights());
            return;
        }
        this.theClassValue = Utils.maxIndex(this.theCounts);
        Utils.normalize(this.theCounts);
    }

    public double classifyInstance(Instance instance) {
        return this.theClassValue;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.theCounts == null) {
            throw new Exception("ZeroR: Class is numeric, can't compute distribution!");
        }
        return this.theCounts;
    }

    public String toString() {
        try {
            if (this.theCounts == null) {
                return "ZeroR predicts class value: " + this.theClassValue;
            }
            return "ZeroR predicts class value: " + this.theInstances.classAttribute().value(this.theClassValue);
        }
        catch (Exception exception) {
            return "Can't print classifier!";
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new ZeroR(), stringArray));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            return;
        }
    }
}

