/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import java.util.Enumeration;
import jaws.classifierPackage.Test;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;

class PrismRule {
    public int classification;
    public Instances instances;
    public Test test;
    public int errors;
    public PrismRule next;

    public PrismRule(Instances instances, int n) throws Exception {
        this.instances = instances;
        this.classification = n;
        this.test = null;
        this.next = null;
        this.errors = 0;
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            if ((int)((Instance)enumeration.nextElement()).classValue() == n) continue;
            ++this.errors;
        }
    }

    public int resultRule(Instance instance) {
        if (this.test == null || this.test.satisfies(instance)) {
            return this.classification;
        }
        return -1;
    }

    public int resultRules(Instance instance) {
        if (this.resultRule(instance) != -1) {
            return this.classification;
        }
        if (this.next != null) {
            return this.next.resultRules(instance);
        }
        return -1;
    }

    public Instances coveredBy(Instances instances) {
        Instances instances2 = new Instances(instances, instances.numInstances());
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (this.resultRule(instance) == -1) continue;
            instances2.add(instance);
        }
        instances2.compactify();
        return instances2;
    }

    public Instances notCoveredBy(Instances instances) {
        Instances instances2 = new Instances(instances, instances.numInstances());
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (this.resultRule(instance) != -1) continue;
            instances2.add(instance);
        }
        instances2.compactify();
        return instances2;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.test != null) {
                stringBuffer.append("If ");
                Test test = this.test;
                while (test != null) {
                    if (test.attr == -1) {
                        stringBuffer.append("?");
                    } else {
                        stringBuffer.append(String.valueOf(this.instances.attribute(test.attr).name()) + " = " + this.instances.attribute(test.attr).value(test.val));
                    }
                    if (test.next != null) {
                        stringBuffer.append("\n   and ");
                    }
                    test = test.next;
                }
                stringBuffer.append(" then ");
            }
            stringBuffer.append(String.valueOf(this.instances.classAttribute().value(this.classification)) + "\n");
            if (this.next != null) {
                stringBuffer.append(this.next.toString());
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print Prism classifier!";
        }
    }
}

