/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import java.util.Enumeration;
import jaws.corePackage.Attribute;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.DistributionClassifier;
import jaws.evaluationPackage.Evaluation;

public class NaiveBayes
extends DistributionClassifier {
    private static double normConst = Math.sqrt(Math.PI * 2);
    private double[][][] theCounts;
    private double[][] theMeans;
    private double[][] theDevs;
    private double[] thePriors;
    private Instances theInstances;

    public void buildClassifier(Instances instances) throws Exception {
        double d;
        Attribute attribute;
        Object object;
        Object object2;
        int n = 0;
        if (instances.classAttribute().isNumeric()) {
            throw new Exception("Naive Bayes: Class is numeric!");
        }
        this.theInstances = new Instances(instances, 0, 0);
        this.theCounts = new double[instances.numClasses()][instances.numAttributes() - 1][0];
        this.theMeans = new double[instances.numClasses()][instances.numAttributes() - 1];
        this.theDevs = new double[instances.numClasses()][instances.numAttributes() - 1];
        this.thePriors = new double[instances.numClasses()];
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            int n2;
            object2 = (Attribute)enumeration.nextElement();
            if (((Attribute)object2).isNominal()) {
                n2 = 0;
                while (n2 < instances.numClasses()) {
                    this.theCounts[n2][n] = new double[((Attribute)object2).numValues()];
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < instances.numClasses()) {
                    this.theCounts[n2][n] = new double[1];
                    ++n2;
                }
            }
            ++n;
        }
        object2 = instances.enumerateInstances();
        while (object2.hasMoreElements()) {
            Instance instance = (Instance)object2.nextElement();
            if (instance.classIsMissing()) continue;
            object = instances.enumerateAttributes();
            n = 0;
            while (object.hasMoreElements()) {
                attribute = (Attribute)object.nextElement();
                if (!instance.isMissing(attribute)) {
                    if (attribute.isNominal()) {
                        double[] dArray = this.theCounts[(int)instance.classValue()][n];
                        int n3 = (int)instance.value(attribute);
                        dArray[n3] = dArray[n3] + 1.0;
                    } else {
                        double[] dArray = this.theMeans[(int)instance.classValue()];
                        int n4 = n;
                        dArray[n4] = dArray[n4] + instance.value(attribute);
                        double[] dArray2 = this.theCounts[(int)instance.classValue()][n];
                        dArray2[0] = dArray2[0] + 1.0;
                    }
                }
                ++n;
            }
            int n5 = (int)instance.classValue();
            this.thePriors[n5] = this.thePriors[n5] + 1.0;
        }
        Enumeration enumeration2 = instances.enumerateAttributes();
        n = 0;
        while (enumeration2.hasMoreElements()) {
            object = (Attribute)enumeration2.nextElement();
            if (((Attribute)object).isNumeric()) {
                int n6 = 0;
                while (n6 < instances.numClasses()) {
                    if (this.theCounts[n6][n][0] < 2.0) {
                        throw new Exception("attribute " + ((Attribute)object).name() + ": less than two values for class " + instances.classAttribute().value(n6));
                    }
                    double[] dArray = this.theMeans[n6];
                    int n7 = n;
                    dArray[n7] = dArray[n7] / this.theCounts[n6][n][0];
                    ++n6;
                }
            }
            ++n;
        }
        object2 = instances.enumerateInstances();
        while (object2.hasMoreElements()) {
            object = (Instance)object2.nextElement();
            if (((Instance)object).classIsMissing()) continue;
            enumeration2 = instances.enumerateAttributes();
            n = 0;
            while (enumeration2.hasMoreElements()) {
                attribute = (Attribute)enumeration2.nextElement();
                if (!((Instance)object).isMissing(attribute) && attribute.isNumeric()) {
                    double[] dArray = this.theDevs[(int)((Instance)object).classValue()];
                    int n8 = n;
                    dArray[n8] = dArray[n8] + (this.theMeans[(int)((Instance)object).classValue()][n] - ((Instance)object).value(attribute)) * (this.theMeans[(int)((Instance)object).classValue()][n] - ((Instance)object).value(attribute));
                }
                ++n;
            }
        }
        enumeration2 = instances.enumerateAttributes();
        n = 0;
        while (enumeration2.hasMoreElements()) {
            object = (Attribute)enumeration2.nextElement();
            if (((Attribute)object).isNumeric()) {
                int n9 = 0;
                while (n9 < instances.numClasses()) {
                    if (this.theDevs[n9][n] <= 0.0) {
                        throw new Exception("attribute " + ((Attribute)object).name() + ": standard deviation is 0 for class " + instances.classAttribute().value(n9));
                    }
                    double[] dArray = this.theDevs[n9];
                    int n10 = n;
                    dArray[n10] = dArray[n10] / (this.theCounts[n9][n][0] - 1.0);
                    this.theDevs[n9][n] = Math.sqrt(this.theDevs[n9][n]);
                    ++n9;
                }
            }
            ++n;
        }
        enumeration2 = instances.enumerateAttributes();
        n = 0;
        while (enumeration2.hasMoreElements()) {
            object = (Attribute)enumeration2.nextElement();
            if (((Attribute)object).isNominal()) {
                int n11 = 0;
                while (n11 < instances.numClasses()) {
                    d = Utils.sum(this.theCounts[n11][n]);
                    int n12 = 0;
                    while (n12 < ((Attribute)object).numValues()) {
                        this.theCounts[n11][n][n12] = (this.theCounts[n11][n][n12] + 1.0) / (d + (double)((Attribute)object).numValues());
                        ++n12;
                    }
                    ++n11;
                }
            }
            ++n;
        }
        d = Utils.sum(this.thePriors);
        int n13 = 0;
        while (n13 < instances.numClasses()) {
            this.thePriors[n13] = (this.thePriors[n13] + 1.0) / (d + (double)instances.numClasses());
            ++n13;
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        return Utils.maxIndex(this.distributionForInstance(instance));
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        int n = 0;
        while (n < instance.numClasses()) {
            dArray[n] = 1.0;
            Enumeration enumeration = instance.enumerateAttributes();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                if (!instance.isMissing(attribute)) {
                    if (attribute.isNominal()) {
                        int n3 = n;
                        dArray[n3] = dArray[n3] * this.theCounts[n][n2][(int)instance.value(attribute)];
                    } else {
                        int n4 = n;
                        dArray[n4] = dArray[n4] * this.normalDens(instance.value(attribute), this.theMeans[n][n2], this.theDevs[n][n2]);
                    }
                }
                ++n2;
            }
            int n5 = n;
            dArray[n5] = dArray[n5] * this.thePriors[n];
            ++n;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        try {
            var1_1 = new StringBuffer();
            var1_1.append("Naive Bayes");
            var3_3 = 0;
            block2: while (true) {
                if (var3_3 >= this.theInstances.numClasses()) {
                    return var1_1.toString();
                }
                var1_1.append("\n\nClass " + this.theInstances.classAttribute().value(var3_3) + ": P(C) = " + Utils.doubleToString(this.thePriors[var3_3], 10, 8) + "\n\n");
                var4_5 = this.theInstances.enumerateAttributes();
                var2_4 = 0;
                block3: while (true) {
                    block9: {
                        if (!var4_5.hasMoreElements()) {
                            ++var3_3;
                            continue block2;
                        }
                        var5_6 = (Attribute)var4_5.nextElement();
                        var1_1.append("Attribute " + var5_6.name() + "\n");
                        if (!var5_6.isNominal()) break block9;
                        var6_7 = 0;
                        if (true) ** GOTO lbl39
                    }
                    var1_1.append("Mean: " + Utils.doubleToString(this.theMeans[var3_3][var2_4], 10, 8) + "\t");
                    var1_1.append("Standard Deviation: " + Utils.doubleToString(this.theDevs[var3_3][var2_4], 10, 8));
                    while (true) {
                        var1_1.append("\n\n");
                        ++var2_4;
                        continue block3;
                        break;
                    }
                    break;
                }
                break;
            }
        }
        catch (Exception var1_2) {
            return "Can't print Naive Bayes classifier!";
        }
        do {
            var1_1.append(var5_6.value(var6_7) + "\t");
            ++var6_7;
lbl39:
            // 2 sources

        } while (var6_7 < var5_6.numValues());
        var1_1.append("\n");
        var6_7 = 0;
        while (true) {
            if (var6_7 >= var5_6.numValues()) ** continue;
            var1_1.append(Utils.doubleToString(this.theCounts[var3_3][var2_4][var6_7], 10, 8) + "\t");
            ++var6_7;
        }
    }

    private final double normalDens(double d, double d2, double d3) {
        double d4 = d - d2;
        return 1.0 / (normConst * d3) * Math.exp(-(d4 * d4 / (2.0 * d3 * d3)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            NaiveBayes naiveBayes = new NaiveBayes();
            System.out.println(Evaluation.evaluateModel(naiveBayes, stringArray));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

