/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import java.util.Enumeration;
import jaws.classifierPackage.Tree;
import jaws.corePackage.Attribute;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Classifier;
import jaws.evaluationPackage.Evaluation;

public class Id3
extends Classifier {
    private Tree tree;

    public double classifyInstance(Instance instance) {
        return this.descendTree(this.tree, instance);
    }

    public int descendTree(Tree tree, Instance instance) {
        if (tree.isLeaf) {
            return tree.classification;
        }
        Attribute attribute = tree.splittingAttribute;
        int n = attribute.isNominal() ? (int)instance.value(attribute) : (instance.value(attribute) < tree.splittingValue ? 0 : 1);
        return this.descendTree(tree.children[n], instance);
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (instances.classAttribute().isNumeric()) {
            throw new Exception("Id3 can't handle a numeric class!");
        }
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            Enumeration enumeration2 = instances.enumerateInstances();
            while (enumeration2.hasMoreElements()) {
                if (!((Instance)enumeration2.nextElement()).isMissing(attribute)) continue;
                throw new Exception("Id3 can't handle attributes with missing values!");
            }
        }
        instances.deleteWithMissingClass();
        this.tree = Id3.makeTree(instances);
    }

    public static Tree makeTree(Instances instances) throws Exception {
        Object object;
        double d = 0.0;
        double d2 = 0.0;
        int n = -1;
        double[] dArray = new double[2];
        if (instances.numInstances() == 0) {
            return new Tree(instances);
        }
        int n2 = instances.classIndex();
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            double d3;
            object = (Attribute)enumeration.nextElement();
            if (((Attribute)object).isNominal()) {
                d3 = Id3.gainNominal((Attribute)object, n2, instances);
            } else {
                dArray = Id3.gainNumeric((Attribute)object, n2, instances);
                d3 = dArray[0];
            }
            if (!(d3 > d)) continue;
            d = d3;
            n = ((Attribute)object).index();
            if (((Attribute)object).isNominal()) continue;
            d2 = dArray[1];
        }
        if (n == -1 || !(d > 0.0)) {
            return new Tree(instances);
        }
        Attribute attribute = instances.attribute(n);
        object = new Tree(instances, attribute, d2);
        if (attribute.isNominal()) {
            int n3 = 0;
            while (n3 < attribute.numValues()) {
                ((Tree)object).children[n3] = Id3.makeTree(Id3.select(instances, attribute, d2, n3));
                ++n3;
            }
        } else {
            ((Tree)object).children[0] = Id3.makeTree(Id3.select(instances, attribute, d2, 0));
            ((Tree)object).children[1] = Id3.makeTree(Id3.select(instances, attribute, d2, 1));
        }
        return object;
    }

    public static double gainNominal(Attribute attribute, int n, Instances instances) throws Exception {
        int[][] nArray = new int[attribute.numValues()][instances.classAttribute().numValues()];
        int[] nArray2 = new int[instances.classAttribute().numValues()];
        int n2 = 0;
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            int[] nArray3 = nArray[(int)instance.value(attribute)];
            int n3 = (int)instance.classValue();
            nArray3[n3] = nArray3[n3] + 1;
            int n4 = (int)instance.classValue();
            nArray2[n4] = nArray2[n4] + 1;
            ++n2;
        }
        double d = 0.0;
        int n5 = 0;
        while (n5 < attribute.numValues()) {
            d += Id3.info(nArray[n5]);
            ++n5;
        }
        return (Id3.info(nArray2) - d) / (double)n2;
    }

    public static double[] gainNumeric(Attribute attribute, int n, Instances instances) throws Exception {
        double[] dArray = new double[2];
        dArray[0] = -1.0;
        double[] dArray2 = dArray;
        instances.sort(attribute);
        int[] nArray = new int[instances.classAttribute().numValues()];
        int[] nArray2 = new int[instances.classAttribute().numValues()];
        int n2 = 0;
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            int n3 = (int)((Instance)enumeration.nextElement()).classValue();
            nArray2[n3] = nArray2[n3] + 1;
            ++n2;
        }
        double d = Id3.info(nArray2);
        int n4 = 0;
        boolean bl = false;
        do {
            double d2;
            double d3 = instances.instance(n4).value(attribute);
            double d4 = 0.0;
            do {
                int n5;
                int n6 = n5 = (int)instances.instance(n4).classValue();
                nArray[n6] = nArray[n6] + 1;
                int n7 = n5;
                nArray2[n7] = nArray2[n7] - 1;
                if (++n4 == instances.numInstances()) {
                    bl = true;
                    continue;
                }
                d4 = instances.instance(n4).value(attribute);
            } while (!bl && d4 == d3);
            if (bl || !((d2 = (d - Id3.info(nArray) - Id3.info(nArray2)) / (double)n2) > dArray2[0])) continue;
            dArray2[0] = d2;
            dArray2[1] = (d3 + d4) / 2.0;
        } while (!bl);
        return dArray2;
    }

    public static Instances select(Instances instances, Attribute attribute, double d, int n) {
        Instances instances2 = new Instances(instances, instances.numInstances());
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (attribute.isNominal()) {
                if (n != (int)instance.value(attribute)) continue;
                instances2.add(instance);
                continue;
            }
            if (!(n == 0 && instance.value(attribute) < d) && (n != 1 || !(instance.value(attribute) > d))) continue;
            instances2.add(instance);
        }
        instances2.compactify();
        return instances2;
    }

    public String toString() {
        return "Id3 tree\n--------\n" + this.tree.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Id3(), stringArray));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            return;
        }
    }

    private static double info(int[] nArray) {
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        while (n2 < nArray.length) {
            d -= Id3.xlogx(nArray[n2]);
            n += nArray[n2];
            ++n2;
        }
        return d + Id3.xlogx(n);
    }

    private static double xlogx(int n) {
        if (n == 0) {
            return 0.0;
        }
        return (double)n * Utils.log2(n);
    }
}

