###########################################################################
#
# win32 makefile -- src/w32server
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = d:\home\dl\gsdl
STLPATH = d:\home\dl\stl\stlport

AR = lib
CC = cl
RSC = rc
CPPFLAGS =
LDFLAGS =
DEFS = -DNZDL -DQUIET -D__WIN32__ -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H \
       -DSHORT_SUFFIX -DPARADOCNUM -DHAVE_CONFIG_H -D__STL_NO_NEW_IOSTREAMS \
       -DGSDLSERVER -DGSDLUSAGELOG
INCLUDES = -I$(GSDLHOME)\src\w32server -I$(GSDLHOME)\src\recpt -I$(GSDLHOME)\lib \
	   -I$(GSDLHOME)\src\colservr -I$(GSDLHOME)\packages\mg \
	   -I$(GSDLHOME)\packages\mg\lib -I$(GSDLHOME)\packages\mg\src\text \
	   -I$(GSDLHOME)\packages\wingdbm -I$(STLPATH) -I$(GSDLHOME)\packages\wincrypt

LIBS = $(GSDLHOME)\packages\wingdbm\gdbm.lib $(GSDLHOME)\packages\wincrypt\crypt.lib \
       $(GSDLHOME)\lib\gsdllib.lib $(GSDLHOME)\packages\mg\src\text\libtextin.lib \
       $(GSDLHOME)\packages\mg\lib\libmg.lib \
       kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib \
       shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib


COMPILE = $(CC) -c $(CPPFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) $(LDFLAGS) -o $@

.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 

HEADERS = cgiwrapper.h conftools.h d_winsock.h fnord.h httpreq.h httpsend.h \
          httpsrv.h locate.h netio.h parse.h settings.h startbrowser.h \
	  wincgiutils.h

SOURCES = cgiwrapper.cpp conftools.cpp d_winsock.cpp fnord.cpp httpreq.cpp httpsend.cpp \
          httpsrv.cpp locate.cpp netio.cpp parse.cpp settings.cpp startbrowser.cpp \
	  wincgiutils.cpp

OBJECTS = cgiwrapper.obj conftools.obj d_winsock.obj fnord.obj httpreq.obj httpsend.obj \
          httpsrv.obj locate.obj netio.obj parse.obj settings.obj startbrowser.obj \
	  wincgiutils.obj server.res

#RECPTOBJECTS = $(GSDLHOME)\src\recpt\receptionist.obj \
#	       $(GSDLHOME)\src\recpt\cgiargs.obj \
#               $(GSDLHOME)\src\recpt\action.obj \
#               $(GSDLHOME)\src\recpt\browserclass.obj \
#               $(GSDLHOME)\src\recpt\converter.obj \
#	        $(GSDLHOME)\src\recpt\recptconfig.obj \
#               $(GSDLHOME)\src\recpt\cgiutils.obj \
#               $(GSDLHOME)\src\recpt\OIDtools.obj \
#               $(GSDLHOME)\src\recpt\browsetools.obj \
#               $(GSDLHOME)\src\recpt\htmlgen.obj \
#               $(GSDLHOME)\src\recpt\statusaction.obj \
#               $(GSDLHOME)\src\recpt\pageaction.obj \
#               $(GSDLHOME)\src\recpt\comtypes.obj \
#               $(GSDLHOME)\src\recpt\recptproto.obj \
#               $(GSDLHOME)\src\recpt\pingaction.obj \
#               $(GSDLHOME)\src\recpt\queryaction.obj \
#               $(GSDLHOME)\src\recpt\documentaction.obj \
#               $(GSDLHOME)\src\recpt\extlinkaction.obj \
#               $(GSDLHOME)\src\recpt\buildaction.obj \
#               $(GSDLHOME)\src\recpt\htmlutils.obj \
#               $(GSDLHOME)\src\recpt\querytools.obj \
#               $(GSDLHOME)\src\recpt\formattools.obj \
#               $(GSDLHOME)\src\recpt\tipaction.obj \
#               $(GSDLHOME)\src\recpt\authenaction.obj \
#               $(GSDLHOME)\src\recpt\infodbclass.obj \
#               $(GSDLHOME)\src\recpt\userdb.obj \
#               $(GSDLHOME)\src\recpt\usersaction.obj \
#               $(GSDLHOME)\src\recpt\vlistbrowserclass.obj \
#               $(GSDLHOME)\src\recpt\hlistbrowserclass.obj \
#               $(GSDLHOME)\src\recpt\datelistbrowserclass.obj \
#               $(GSDLHOME)\src\recpt\invbrowserclass.obj \
#               $(GSDLHOME)\src\recpt\pagedbrowserclass.obj \
#               $(GSDLHOME)\src\recpt\htmlbrowserclass.obj \
#               $(GSDLHOME)\src\recpt\delhistoryaction.obj \
#               $(GSDLHOME)\src\recpt\historydb.obj

#LIBRARYOBJECTS = $(GSDLHOME)\src\recpt\nullproto.obj

#COLSERVROBJECTS = $(GSDLHOME)\src\colservr\mgq.obj \
#                  $(GSDLHOME)\src\colservr\mgsearch.obj \
#                  $(GSDLHOME)\src\colservr\querycache.obj \
#                  $(GSDLHOME)\src\colservr\queryinfo.obj \
#                  $(GSDLHOME)\src\colservr\collectserver.obj \
#                  $(GSDLHOME)\src\colservr\colservrconfig.obj \
#                  $(GSDLHOME)\src\colservr\maptools.obj \
#                  $(GSDLHOME)\src\colservr\filter.obj \
#                  $(GSDLHOME)\src\colservr\source.obj \
#                  $(GSDLHOME)\src\colservr\browsefilter.obj \
#                  $(GSDLHOME)\src\colservr\queryfilter.obj \
#                  $(GSDLHOME)\src\colservr\mggdbmsource.obj \
#                  $(GSDLHOME)\src\colservr\phrasesearch.obj \
#                  $(GSDLHOME)\src\colservr\phrasequeryfilter.obj

RECPTOBJECTS = ..\recpt\receptionist.obj \
	       ..\recpt\cgiargs.obj \
               ..\recpt\action.obj \
               ..\recpt\browserclass.obj \
               ..\recpt\converter.obj \
	       ..\recpt\recptconfig.obj \
               ..\recpt\cgiutils.obj \
               ..\recpt\OIDtools.obj \
               ..\recpt\browsetools.obj \
               ..\recpt\htmlgen.obj \
               ..\recpt\statusaction.obj \
               ..\recpt\pageaction.obj \
               ..\recpt\comtypes.obj \
               ..\recpt\recptproto.obj \
               ..\recpt\pingaction.obj \
               ..\recpt\queryaction.obj \
               ..\recpt\documentaction.obj \
               ..\recpt\extlinkaction.obj \
               ..\recpt\buildaction.obj \
               ..\recpt\htmlutils.obj \
               ..\recpt\querytools.obj \
               ..\recpt\formattools.obj \
               ..\recpt\tipaction.obj \
               ..\recpt\authenaction.obj \
               ..\recpt\infodbclass.obj \
               ..\recpt\userdb.obj \
               ..\recpt\usersaction.obj \
               ..\recpt\vlistbrowserclass.obj \
               ..\recpt\hlistbrowserclass.obj \
               ..\recpt\datelistbrowserclass.obj \
               ..\recpt\invbrowserclass.obj \
               ..\recpt\pagedbrowserclass.obj \
               ..\recpt\htmlbrowserclass.obj \
               ..\recpt\delhistoryaction.obj \
               ..\recpt\historydb.obj

LIBRARYOBJECTS = ..\recpt\nullproto.obj

COLSERVROBJECTS = ..\colservr\mgq.obj \
                  ..\colservr\mgsearch.obj \
                  ..\colservr\querycache.obj \
                  ..\colservr\queryinfo.obj \
                  ..\colservr\collectserver.obj \
                  ..\colservr\colservrconfig.obj \
                  ..\colservr\maptools.obj \
                  ..\colservr\filter.obj \
                  ..\colservr\source.obj \
                  ..\colservr\browsefilter.obj \
                  ..\colservr\queryfilter.obj \
                  ..\colservr\mggdbmsource.obj \
                  ..\colservr\phrasesearch.obj \
                  ..\colservr\phrasequeryfilter.obj

EXEC = server.exe

all: $(EXEC)

clean:
	del *.obj
	del $(EXEC)

install:
	copy $(EXEC) $(GSDLHOME)\$(EXEC)

LIBRARY_OBJS = $(OBJECTS) $(RECPTOBJECTS) $(LIBRARYOBJECTS) $(COLSERVROBJECTS)
server.exe: $(LIBRARY_OBJS)
	    $(LINK) $(LIBRARY_OBJS) $(LIBS) 


SOURCE = $(GSDLHOME)\src\w32server\newgsdl.bmp
SOURCE = $(GSDLHOME)\src\w32server\resource.h
SOURCE = $(GSDLHOME)\src\w32server\server.ico
SOURCE = $(GSDLHOME)\src\w32server\gsdlcol.bmp
SOURCE = $(GSDLHOME)\src\w32server\server.rc
DEP_RSC_SERVE=\
	"$(GSDLHOME)\src\w32server\gsdlcol.bmp"\
	"$(GSDLHOME)\src\w32server\newgsdl.bmp"\
	"$(GSDLHOME)\src\w32server\server.ico"\

server.res : $(SOURCE) $(DEP_RSC_SERVE) "$(GSDLHOME)\src\w32server"
   $(RSC) /l 0x409 /fo"$(GSDLHOME)\src\w32server\server.res" /i "$(GSDLHOME)\src\w32server" \
 /d "NDEBUG" $(SOURCE)


"$(GSDLHOME)\src\w32server\server.res" : $(SOURCE) $(DEP_RSC_SERVE) "$(GSDLHOME)\src\w32server"
   $(RSC) /l 0x409 /fo"$(GSDLHOME)\src\w32server\server.res" /i "$(GSDLHOME)\src\w32server" \
 /d "NDEBUG" $(SOURCE)

