/*
Copyright (C) 1996

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The author can be contacted via Email at bmorin@wpi.edu
*/
#include "text_t.h"
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#pragma hdrstop
#include "netio.h"
#include "settings.h"
#include "httpreq.h"
#include "httpsrv.h"
#include "locate.h"

//Private Functions

/*
Function Name: HTTP Server Answer
Purpose: Answers messages saying that a connection is ready to start
*/
void HTTPServerAnswer();

//Module Vars
static SOCKET ServerSocket = INVALID_SOCKET;

static HWND MsgWindow;

/******************************************************************************/
// returns 0 on success, and a WSA error otherwise
int StartHTTPServer(HWND PassedMsgWindow) {

  MsgWindow = PassedMsgWindow;
  //Create the server socket
  return CreateListeningSocket(gsdl_port_num, MsgWindow, HTTP_SERVER_MSG, ServerSocket);
}

/******************************************************************************/
void EndHTTPServer()
{
  //Stop the listening socket
  DestroyListeningSocket(ServerSocket, MsgWindow);
}

/******************************************************************************/
void ProcessHTTPServerMsg(WPARAM Socket, LPARAM MsgInfo) {
	log_message("accept message arrived\n");
	if (Socket != ServerSocket) {
		if (gsdl_keep_log || gsdl_show_console) log_message("Incorrect socket sent in message");
		}
	switch (WSAGETSELECTEVENT(MsgInfo)) {
		case FD_ACCEPT:
			switch (WSAGETSELECTERROR(MsgInfo)) {
				case WSAENETDOWN:
					LogCriticalError("1","Network Down");
					break;
				default: //No Error
					HTTPServerAnswer();
				}
			break;
		}
}

/******************************************************************************/
void HTTPServerAnswer() {
	SOCKADDR_IN ClientSockAddr;
	SOCKET ClientSocket;
	int AddrLen = sizeof(SOCKADDR_IN);
	RequestThreadMessageT Parameters;
  while (AnswerListeningSocket(ServerSocket, ClientSocket, ClientSockAddr, AddrLen) == 0) {
    log_message("Answering socket\n");
	  //Call the thread procedure to handle the connection
    Parameters.ClientSockAddr = ClientSockAddr;
  	Parameters.ClientSocket = ClientSocket;
  	Parameters.AddrLen = AddrLen;
    RequestThread(&Parameters);
  }
}
	
