/**********************************************************************
 *
 * recptproto.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "recptproto.h"
#include <assert.h>


// add collection server to protocol
void recptproto::add_collection (const text_t &/*collection*/, void * /*recpt*/, 
				 const text_t &/*gsdlhome*/, const text_t &/*gdbmhome*/) {
}

void recptproto::remove_collection (const text_t &/*collection*/, ostream &/*logout*/) {
}

// configure should be called for each line in the configuration file
void recptproto::configure (const text_t &/*key*/, const text_tarray &/*cfgline*/) {
}

// init should be called after the configuration but before any other
// functions are called. If init returns false a message will be written
// out to the log file and no other output should be produced.
bool recptproto::init (ostream &/*logout*/) {
  return true;
}

// get site name should return the name of the site used.
// This is trivially empty in the case of a null protocol.  If a remote
// connection to a site is being used then this should return the name
// used to label a site
text_t recptproto::get_site_name() {
  return "";
}

// get_protocol_name should return the name of this protocol (e.g. recptproto)
// that can be used to do run time type identification and display information
// about the protocol.
text_t recptproto::get_protocol_name () {
  return "recptproto";
}

// get_collection_list returns the list of collections that
// this protocol knows about
void recptproto::get_collection_list (text_tarray &collist, comerror_t &err, 
				      ostream &/*logout*/) {
  collist.erase(collist.begin(),collist.end());
  err = noError;
}

// has_collection sets 'hascollection' to be true if the protocol
// can communicate with the collection (i.e. it is within its 
// collection list). This function should be implemented in as
// efficient time as possible as it will be called for each page
// access and for each protocol.
void recptproto::has_collection (const text_t &/*collection*/, bool &hascollection, 
				 comerror_t &err, ostream &/*logout*/) {
  hascollection = false;
  err = noError;
}

// sets 'wassuccess' to be true if a successful ping was done to
// the given collection.
void recptproto::ping (const text_t &/*collection*/, bool &wassuccess, 
		       comerror_t &err, ostream &/*logout*/) {
  wassuccess = false; // no collections are supported by this class
  err = noError;
}

// obtains general information about the collection
void recptproto::get_collectinfo (const text_t &/*collection*/, 
				  ColInfoResponse_t &/*collectinfo*/,
				  comerror_t &err, ostream &/*logout*/) {
  err = protocolError;
}

// gets a list of all the filters
void recptproto::get_filterinfo (const text_t &/*collection*/,
				 InfoFiltersResponse_t &/*reponse*/,
				 comerror_t &err, ostream &/*logout*/) {
  err = protocolError;
}

// gets all the filter options for a particular filter
void recptproto::get_filteroptions (const text_t &/*collection*/,
				    const InfoFilterOptionsRequest_t &/*request*/,
				    InfoFilterOptionsResponse_t &/*response*/, 
				    comerror_t &err, ostream &/*logout*/) {
  err = protocolError;
}

// filters (search or browse) a result set
void recptproto::filter (const text_t &/*collection*/,
			 FilterRequest_t &/*request*/,
			 FilterResponse_t &/*response*/,
			 comerror_t &err, ostream &/*logout*/) {
  err = protocolError;
}

void recptproto::get_document (const text_t &/*collection*/,
			       const DocumentRequest_t &/*request*/,
			       DocumentResponse_t &/*response*/,
			       comerror_t &err, ostream &/*logout*/) {
  err = protocolError;
}







// therecptproto remains the property of the calling code but
// should not be deleted until it is removed from this list.
void recptprotolistclass::addrecptproto (recptproto *therecptproto) {
  // can't add a protocol that doesn't exist
  assert (therecptproto != NULL);
  if (therecptproto == NULL) return;

  recptprotoptr rpp;
  rpp.p = therecptproto;

  recptprotoptrs.push_back(rpp);
}

// getrecptproto will return NULL if a recptproto for the given colelction
// could not be found
recptproto *recptprotolistclass::getrecptproto (const text_t &collection, 
						ostream &logout) {
  iterator here = recptprotoptrs.begin ();
  iterator end = recptprotoptrs.end ();
  bool hascollection;
  comerror_t err;

  while (here != end) {
    assert ((*here).p != NULL);
    if ((*here).p != NULL) {
      (*here).p->has_collection (collection, hascollection, err, logout);
      if ((err == noError) && (hascollection == true)) return (*here).p;
    }
    
    here++;
  }
  
  return NULL;
}
