/**********************************************************************
 *
 * querytools.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef QUERYTOOLS_H
#define QUERYTOOLS_H

#include "cgiargs.h"
#include "recptproto.h"

void set_queryfilter_options (FilterRequest_t &request, const text_t &querystring,
			      cgiargsclass &args);

void set_queryfilter_options (FilterRequest_t &request, const text_t &querystring1,
			      const text_t &querystring2, cgiargsclass &args);

// don't hassle the function name ... it's been a long day ;)
void set_more_queryfilter_options (FilterRequest_t &request, cgiargsclass &args);

void format_querystring (text_t &querystring, int querymode);

void add_dates(text_t &querystring, int startdate, int enddate, 
	       int startbc, int endbc);

void get_phrases (const text_t &querystring, text_tarray &phrases);

void add_ands(text_t& querystring, int querytype);

// search history tool
text_t escape_quotes(const text_t &querystring);

// some query parsing functions for form processing (only for mgpp collections)
void parse_reg_query_form(text_t &formattedstring, cgiargsclass &args);
void parse_adv_query_form(text_t &formattedstring, cgiargsclass &args);

void addqueryelem(text_t &querystring, text_t &tag, 
		  text_t &query, text_t combine);
text_t addstemcase(text_t &terms, text_t &stem, text_t &fold);
text_t formatelem(text_t &text);

#endif




