/**********************************************************************
 *
 * pagedbrowserclass.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef PAGEDBROWSERCLASS_H
#define PAGEDBROWSERCLASS_H

#include "browserclass.h"

class pagedbrowserclass : public browserclass {
protected:

public:

  pagedbrowserclass ();
  virtual ~pagedbrowserclass ();

  // returns the name that specifies the browserclass type
  virtual text_t get_browser_name ();

  void load_metadata_defaults (text_tset &metadata);

  virtual void processOID (cgiargsclass &args, recptproto *collectproto,
			   ostream &logout);


  virtual int output_section_group (ResultDocInfo_t &section, cgiargsclass &args,
				    const text_t &collection, int colnumber, format_t *formatlistptr, 
				    bool use_table, text_tset &metadata, bool &getParents,
				    recptproto *collectproto, displayclass &disp, 
				    outconvertclass &outconvert, ostream &textout, ostream &logout);

  virtual int output_section_group (FilterResponse_t &sections, cgiargsclass &args,
				    const text_t &collection, int colnumber, format_t *formatlistptr, 
				    bool use_table, text_tset &metadata, bool &getParents,
				    recptproto *collectproto, displayclass &disp, 
				    outconvertclass &outconvert, ostream &textout, ostream &logout);

};

#endif
