/**********************************************************************
 *
 * pageaction.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "OIDtools.h"
#include "pageaction.h"
#include "receptionist.h"
#include <time.h>

pageaction::pageaction () {

  status_disabled = true;
  collector_disabled = true;
  recpt = NULL;

  // this action uses cgi variables "a", "p", and "hp"
  cgiarginfo arg_ainfo;
  arg_ainfo.shortname = "a";
  arg_ainfo.longname = "action";
  arg_ainfo.multiplechar = true;
  arg_ainfo.defaultstatus = cgiarginfo::weak;
  arg_ainfo.argdefault = "p";
  arg_ainfo.savedarginfo = cgiarginfo::must;
  argsinfo.addarginfo (NULL, arg_ainfo);

  arg_ainfo.shortname = "p";
  arg_ainfo.longname = "page";
  arg_ainfo.multiplechar = true;
  arg_ainfo.defaultstatus = cgiarginfo::weak;
  arg_ainfo.argdefault = "home";
  arg_ainfo.savedarginfo = cgiarginfo::must;
  argsinfo.addarginfo (NULL, arg_ainfo);

  arg_ainfo.shortname = "hp";
  arg_ainfo.longname = "html page";
  arg_ainfo.multiplechar = true;
  arg_ainfo.defaultstatus = cgiarginfo::weak;
  arg_ainfo.argdefault = "";
  arg_ainfo.savedarginfo = cgiarginfo::mustnot;
  argsinfo.addarginfo (NULL, arg_ainfo);
}

pageaction::~pageaction () {
}

bool pageaction::check_cgiargs (cgiargsinfoclass &/*argsinfo*/, cgiargsclass &/*args*/, 
				ostream &/*logout*/) {
  // don't want to check anything yet.
  return true;
}

void pageaction::get_cgihead_info (cgiargsclass &/*args*/, recptprotolistclass * /*protos*/,
				   response_t &response,text_t &response_data, 
				   ostream &/*logout*/) {
  response = content;
  response_data = "text/html";
}

void pageaction::set_homeextra_macro (displayclass &disp, recptprotolistclass *protos, 
				      ostream &logout) {
  text_t homeextra = "<center><table width=_pagewidth_><tr valign=top>\n";
  bool found_valid_col = false;
  
  recptprotolistclass::iterator rprotolist_here = protos->begin();
  recptprotolistclass::iterator rprotolist_end = protos->end();
  while (rprotolist_here != rprotolist_end) {
    if ((*rprotolist_here).p != NULL) {

      text_tarray collist;
      comerror_t err;
      (*rprotolist_here).p->get_collection_list (collist, err, logout);
      if (err == noError) {
	text_tarray::iterator collist_here = collist.begin();
	text_tarray::iterator collist_end = collist.end();

	int count = 0;
	bool first = true;
	while (collist_here != collist_end) {
	  ColInfoResponse_t *cinfo = recpt->get_collectinfo_ptr ((*rprotolist_here).p, *collist_here, logout);
	  
	  if (cinfo != NULL) {
	    if (cinfo->isPublic && (cinfo->buildDate > 0)) {

	      text_t coll_type = "&ct=";
	      if (cinfo->buildType == "mgpp") {
		coll_type += "1";
	      }
	      else {
		coll_type += "0";
	      }
	      found_valid_col = true;
 	      FilterResponse_t response;
	      text_tset metadata;
	      metadata.insert ("collectionname");
	      metadata.insert ("iconcollection");
	      metadata.insert ("iconcollectionsmall");
	      text_t collectionname = *collist_here;
	      text_t alt = collectionname;

	      if (get_info ("collection", *collist_here, metadata, false, 
			    (*rprotolist_here).p, response, logout)) {
		if (!response.docInfo[0].metadata["collectionname"].values[0].empty())
		  alt = response.docInfo[0].metadata["collectionname"].values[0];
		
		text_t iconurl;
		iconurl.clear();

		if (!response.docInfo[0].metadata["iconcollectionsmall"].values[0].empty()) {
		  iconurl = response.docInfo[0].metadata["iconcollectionsmall"].values[0];
		} else if (!response.docInfo[0].metadata["iconcollection"].values[0].empty()) {
		  iconurl = response.docInfo[0].metadata["iconcollection"].values[0];
		}

		if (!iconurl.empty())
		  {
		    // check to see URL is local to colserver
		    text_t::iterator iconurl_head = iconurl.begin();
		    text_t iconhead = substr(iconurl_head,iconurl_head+16);
		    if (iconhead=="_httpcollection_")
		      {
			// local and using _httpcollection_
			text_t icontail = substr(iconurl_head+16,iconurl.end());
			iconurl = "http://" + cinfo->httpdomain 
			  + cinfo->httpprefix + "/collect/" 
			  + *collist_here + "/" + icontail;
		      }
		    else if (iconurl[0]=='/')
		      {
			// local but with full path
			iconurl = "http://" + cinfo->httpdomain + iconurl;
		      }

		    collectionname 
		      = "<img width=150 border=1 src=\"" + iconurl + "\" alt=\"" + alt + "\">";
		  }
		else
		  {
		    collectionname = alt;
		  }

	      }
	      if ((count%3 == 0) && (!first))
		homeextra += "</tr><tr valign=top>\n";
	      
	      text_t optsite = "";
	      text_t site_name = (*rprotolist_here).p->get_site_name ();
	      if (!site_name.empty()) { optsite = "site="+site_name+"&"; }

	      text_t link = "<a href=\"_gwcgi_?"+optsite+"a=p&p=about&c=" + *collist_here + coll_type+"\">";

	      if (!cinfo->receptionist.empty()) 
		link = "<a href=\"" + cinfo->receptionist + "\">";
	      
	      homeextra += "<td>" + link + collectionname + "</a></td>\n";
	      
	      count ++;
	      first = false;
	    }
	  }
	  collist_here ++;
	}

	for (; count%3 != 0; count ++) homeextra += "<td></td>\n";
      }
    }
    homeextra += "</td></tr>\n<tr>\n";
    rprotolist_here ++;
  }

  if (!found_valid_col) {
    homeextra += "<td>No valid (i.e. built and public) collections are available</td>\n";
  }
  homeextra += "</tr></table></center>\n";
  disp.setmacro ("homeextra", "home", homeextra); 
}

void pageaction::define_internal_macros (displayclass &disp, cgiargsclass &args, 
					 recptprotolistclass *protos, ostream &logout) {

  // define_internal_macros sets the following macros:

  // _numdocs_             the number of documents in the collection

  // _builddate_           the date last built

  // if page is "home"
  // _homeextra_           this is the list of available collections and collection info
  //                       to be displayed on the home page


  // if page is "preferences"
  // _collectionoption_    collections to search/browse (if cross-collection-searching is on)

  // _htmloptions_         set to _htmloptionson_ if DocumentUseHTML is set

  // _PreferencesDocsFromWeb_ set to 1 if corresponding format option is set

  // _languageoption_      interface languages to select from (dependant on PreferenceLanguages)

  // _encodingoption_      encodings to select from

  // if page is "about"
  // _textsubcollections_  the text on which subcollections make up the collection (if 
  //                       cross-collection searching is being used

  // _textbrowseoptions_   the 'how to find information' text in the about and help pages

  // _numbrowseoptions_    the number of browsing options 


  // if page is "help"
  // _textbrowseoptions_   the 'how to find information' text in the about and help pages

  // _numbrowseoptions_    the number of browsing options 

  // _topicreadingdocs_    this section of the help text differs depending on what type of 
  // _textreadingdocs_     collection it is (e.g. html collection, bibliographic collection etc.)
  // _texthelpreadingdocs_ 

  // _textgocollector_     set to "" if collector is disabled in main.cfg
  // _textgoadmin_         set to "" if status is disabled in main.cfg

  
  if (recpt == NULL) {
    logout << "ERROR (pageaction::define_internal_macros): This action does not contain\n"
	   << "      information about any receptionists. The method set_receptionist was\n"
	   << "      probably not called from the module which instantiated this action.\n";
    return;
  }

  text_t &arg_p = args["p"];
  text_t &arg_c = args["c"];
  ColInfoResponse_t *cinfo = NULL;

  recptproto* collectproto = protos->getrecptproto (arg_c, logout);
  if (collectproto != NULL) {
    cinfo = recpt->get_collectinfo_ptr (collectproto, arg_c, logout);

    disp.setmacro ("numdocs", "Global", cinfo->numDocs);
    unsigned long current_time = time(NULL);
    unsigned long builddate = (current_time - cinfo->buildDate) / 86400;
    disp.setmacro ("builddate", "Global", builddate);

  }

  if (arg_p == "home") {
    set_homeextra_macro (disp, protos, logout);
    if (status_disabled) disp.setmacro ("textgoadmin", "home", "");
    if (collector_disabled) disp.setmacro ("textgocollector", "home", "");
  }

  else if (arg_p == "preferences") {
    
    // _collectionoption_

    if (args["ccs"] == "1" && collectproto != NULL && (cinfo->ccsCols.size() > 1)) {
      text_t collectionoption = "_textcollectionoption_";
      text_tarray::const_iterator col_here = cinfo->ccsCols.begin();
      text_tarray::const_iterator col_end = cinfo->ccsCols.end();
      int count = 0;
      while (col_here != col_end) {
	text_t colname;
	if (*col_here == arg_c) {
	    colname = cinfo->collectionmeta["collectionname"];
	} else {
	  ColInfoResponse_t *this_cinfo = recpt->get_collectinfo_ptr (collectproto, *col_here, logout);
	  if (this_cinfo == NULL) {col_here ++; continue;}
	  colname = this_cinfo->collectionmeta["collectionname"];
	}

	count ++;
	collectionoption += "<input type=checkbox name=\"cc\" value=\"" + 
	  *col_here + "\" onClick=\"updatecc(\'" + *col_here + "\');\"> " +
	  colname + "<br>\n";
	col_here ++;
      }
      
      if (count > 1)
	disp.setmacro ("collectionoption", "preferences", collectionoption);
    }

    // _htmloptions_
    
    text_tmap::const_iterator it = cinfo->format.find ("DocumentUseHTML");
    if ((it != cinfo->format.end()) && ((*it).second == "true")) {
      disp.setmacro ("htmloptions", "preferences", "_htmloptionson_");


      // _PreferenceDocsFromWeb_

      it = cinfo->format.find ("PreferenceDocsFromWeb");
      if ((it == cinfo->format.end()) || ((*it).second == "true"))
	disp.setmacro ("PreferenceDocsFromWeb", "preferences", "1");
    }

    // _languageoption_
    // Create the "interface language" selection box for the preferences page.
    // You can use something like "format PreferenceLanguages en|fr|zn" from within
    // a collect.cfg file to use only a subset of the available languages for
    // any given collection. This facility is kind of ugly though and should be
    // replaced by something better when the configuration files are tidied up (as
    // should all the other "format Preference..." options).
    
    text_t &arg_l = args["l"];
    const recptconf &configinfo = recpt->get_configinfo();
    // put languages in another map to sort them by longname
    text_tmap languages;
    languageinfo_tmap::const_iterator thislang = configinfo.languages.begin();
    languageinfo_tmap::const_iterator endlang = configinfo.languages.end();
    while (thislang != endlang) {
      languages[(*thislang).second.longname] = (*thislang).first;
      thislang++;
    }
    text_tmap::iterator tlang = languages.begin();
    text_tmap::iterator elang = languages.end();

    text_t languageoption;
    it = cinfo->format.find ("PreferenceLanguages");
    if ((it != cinfo->format.end()) && (!(*it).second.empty())) {
      text_tset pref_langs;
      splitchar ((*it).second.begin(), (*it).second.end(), '|', pref_langs);
      if (pref_langs.size() > 1) {
	while (tlang != elang) {
	  if (pref_langs.find((*tlang).second) != pref_langs.end()) {
	    languageoption += "<option value=\"" + (*tlang).second + "\"";
	    if ((*tlang).second == arg_l) languageoption += " selected";
	    languageoption += ">" + (*tlang).first + "\n";
	  }
	  tlang ++;
	}
      }

    } else {
      while (tlang != elang) {
	languageoption += "<option value=\"" + (*tlang).second + "\"";
	if ((*tlang).second == arg_l) languageoption += " selected";
	languageoption += ">" + (*tlang).first + "\n";
	tlang ++;
      }
    }
    if (!languageoption.empty()) {
      languageoption = "<select name=\"l\" onChange=\"updatel();\">\n" + languageoption;
      languageoption += "</select>\n";
      disp.setmacro ("languageoption", "preferences", languageoption);
    }

    // _encodingoption_
    // create the "encoding" selection box for the preferences page
    if (configinfo.encodings.size() > 1) {
      text_t &arg_w = args["w"];
      text_t encodingoption;
      text_tmap::const_iterator thisenc = configinfo.encodings.begin();
      text_tmap::const_iterator endenc = configinfo.encodings.end();
      while (thisenc != endenc) {
	encodingoption += "<option value=\"" + (*thisenc).second + "\"";
	if ((*thisenc).second == arg_w) encodingoption += " selected";
	encodingoption += ">" + (*thisenc).first + "\n";
	thisenc ++;
      }

      encodingoption = "<select name=\"w\" onChange=\"updatew();\">\n" + encodingoption;
      encodingoption += "</select>\n";
      disp.setmacro ("encodingoption", "preferences", encodingoption);
    }
    
  } else if (arg_p == "about" || arg_p == "help") {
    if (collectproto == NULL) return;
    
    // _textbrowseoptions_ and _numbrowseoptions_
    
    FilterResponse_t response;
    text_tset metadata;
    metadata.insert ("Title");
    bool getParents = false;
    get_children ("", args["c"], metadata, getParents, collectproto, response, logout);

    disp.setmacro ("numbrowseoptions", "help", response.docInfo.size()+1);

    ResultDocInfo_tarray::iterator here = response.docInfo.begin();
    ResultDocInfo_tarray::iterator end = response.docInfo.end();

    // we're assuming that we've always got a search button
    text_t shorttext = "<ul><li>_textSearchshort_\n";
    text_t longtext = "_textSearchlong_";

    while (here != end) {
      text_t title = (*here).metadata["Title"].values[0];

      text_t stext, ltext;
      disp.expandstring ("help", "_text" + title + "short_", stext);
      if (stext == ("_text" + title + "short_")) {
	shorttext += "<li>_help:textdefaultshorttext_";
	longtext += "_help:textdefaultlongtext_";
      } else {
	shorttext += "<li>_help:text" + title + "short_";
	longtext += "_help:text" + title + "long_";
      }

      here ++;
    }
    shorttext += "</ul>\n";
    if (response.docInfo.size() > 1) disp.setmacro ("textbrowseoptions", "help", shorttext + longtext);
    else disp.setmacro ("textbrowseoptions", "help", longtext);

    if (arg_p == "help") {

      // _topicreadingdocs_  _textreadingdocs_  _texthelpreadingdocs_
          
      // if HTML collection there's no how to read document text
      text_tmap::const_iterator it = cinfo->format.find ("HelpNoDocs");
      if ((it != cinfo->format.end()) && ((*it).second == "true")) {
	disp.setmacro ("topicreadingdocs", "help", "");
	disp.setmacro ("texthelpreadingdocs", "help", "");
      }
      it = cinfo->format.find ("HelpBibDocs");
      if ((it != cinfo->format.end()) && ((*it).second == "true")) {
	disp.setmacro ("texthelpreadingdocs", "help", "_bibtexthelpreadingdocs_");
	disp.setmacro ("textreadingdocs", "help", "_bibtextreadingdocs_");
      }
      it = cinfo->format.find ("HelpBookDocs");
      if ((it != cinfo->format.end()) && ((*it).second == "true")) {
	disp.setmacro ("texthelpreadingdocs", "help", "_booktexthelpreadingdocs_");
	disp.setmacro ("textreadingdocs", "help", "_booktextreadingdocs_");
      }

    }
    if (arg_p == "about") {

      // _textsubcollections_
      if (args["ccs"] == "1" && (cinfo->ccsCols.size() > 1)) {
	text_t textsubcollections = "_textsubcols1_(" + text_t(cinfo->ccsCols.size()) + ")";
	text_tarray::const_iterator here = cinfo->ccsCols.begin();
	text_tarray::const_iterator end = cinfo->ccsCols.end();
	bool first = true;
	int count = 0;
	while (here != end) {
	  if (*here == arg_c) {
	    if (!first) textsubcollections += "<br>";
	    textsubcollections += "\n" + cinfo->collectionmeta["collectionname"] + "\n";
	  } else {
	    ColInfoResponse_t *this_cinfo = recpt->get_collectinfo_ptr (collectproto, *here, logout);
	    if (this_cinfo == NULL) {here ++; continue;}
	    if (!first) textsubcollections += "<br>";
	    textsubcollections += "\n" + this_cinfo->collectionmeta["collectionname"] + "\n";
	  }
	  count ++;
	  first = false;
	  here ++;
	}
	textsubcollections += "_textsubcols2_";
	if (count > 1) 
	  disp.setmacro ("textsubcollections", "about", textsubcollections);
      }
    }
  }
}

bool pageaction::do_action (cgiargsclass &args, recptprotolistclass * /*protos*/, 
			    browsermapclass * /*browsers*/, displayclass &disp, 
			    outconvertclass &outconvert, ostream &textout, 
			    ostream &/*logout*/) {

  text_t &arg_p = args["p"];

  textout << outconvert << disp << ("_" + arg_p + ":header_\n")
	  << ("_" + arg_p + ":content_\n")
	  << ("_" + arg_p + ":footer_\n");

  return true;
}

void pageaction::configure (const text_t &key, const text_tarray &cfgline) {
  if ((key == "status") && (cfgline.size() == 1) && 
      (cfgline[0] == "true" || cfgline[0] == "on" || cfgline[0] == "enabled")) {
    status_disabled = false;
  } else if ((key == "collector") && (cfgline.size() == 1) && 
	     (cfgline[0] == "true" || cfgline[0] == "on" || cfgline[0] == "enabled")) {
    collector_disabled = false;
  } else {
    // call the parent class to deal with the things which
    // are not dealt with here
    action::configure (key, cfgline);
  }
}
