/**********************************************************************
 *
 * librarymain.cpp -- 
 * Copyright (C) 1999  The New Zaland Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "receptionist.h"
#include "cgiwrapper.h"
#include "fileutil.h"
#include "nullproto.h"
// z39.50 stuff - johnmcp
#if defined(USE_Z3950)
#include "z3950proto.h"
#endif
#include "collectserver.h"
#include "filter.h"
#include "browsefilter.h"
#include "mgqueryfilter.h"
#include "mgppqueryfilter.h"
#include "infodbclass.h"
#include "mggdbmsource.h"
#include "mgsearch.h"
#include "mgppsearch.h"
#include "collectset.h"
#include <assert.h>

#include "action.h"
#include "statusaction.h"
#include "pageaction.h"
#include "pingaction.h"
#include "queryaction.h"
#include "documentaction.h"
#include "authenaction.h"
#include "usersaction.h"
#include "extlinkaction.h"
#include "tipaction.h"
#include "collectoraction.h"

#include "browserclass.h"
#include "vlistbrowserclass.h"
#include "hlistbrowserclass.h"
#include "datelistbrowserclass.h"
#include "invbrowserclass.h"
#include "pagedbrowserclass.h"
#include "htmlbrowserclass.h"
#include "phindbrowserclass.h"

int main () {
  receptionist recpt;
  nullproto    nproto;
  collectset  *cservers;
#if defined(USE_Z3950)
  /*#ifndef __WIN32__*/
  z3950proto   zproto;
#endif
  text_t       gsdlhome;

  cservers = new collectset(gsdlhome);

  // GRB: removed 7/9/2000; perhaps needs to be here!site_cfg_read (gsdlhome);

  // set up the null protocol
  nproto.set_collectset(cservers);

  // configure the receptionist server list
  cservers->setReceptionistServers(recpt, gsdlhome);  
  
  
  /*
  text_t collectdir = filename_cat (gsdlhome, "collect");
  text_tarray collections;
  read_dir (collectdir, collections);

  text_tarray::const_iterator thiscol = collections.begin();
  text_tarray::const_iterator endcol = collections.end();

  while (thiscol != endcol) {

    // ignore the modelcol
    if (*thiscol == "modelcol") {
      thiscol ++;
      continue;
    }
    
    // create collection server and add to null protocol
    nproto.add_collection (*thiscol, &recpt, gsdlhome, gsdlhome);
    
    confin.close();
// #endif ? does this tie in with a WIN32 ifdef?

    collectserver *cserver = new collectserver();
    gdbmclass *gdbmhandler = new gdbmclass();

    // add a null filter
    filterclass *filter = new filterclass ();
    cserver->add_filter (filter);
    
    // add a browse filter
    browsefilterclass *browsefilter = new browsefilterclass();
    browsefilter->set_gdbmptr (gdbmhandler);

    cserver->add_filter (browsefilter);  

    if (buildtype == "mg") {
       mgsearchclass *mgsearch = new mgsearchclass();
 
       // add a query filter
       mgqueryfilterclass *queryfilter = new mgqueryfilterclass();
       queryfilter->set_gdbmptr (gdbmhandler);
       queryfilter->set_mgsearchptr (mgsearch);
       cserver->add_filter (queryfilter);
       
       // add a mg and gdbm source
       mggdbmsourceclass *mggdbmsource = new mggdbmsourceclass ();
       mggdbmsource->set_gdbmptr (gdbmhandler);
       mggdbmsource->set_mgsearchptr (mgsearch);
       cserver->add_source (mggdbmsource);
    }
#ifndef __WIN32__

    else if (buildtype == "mgpp") {
      
      mgppsearchclass *mgsearch = new mgppsearchclass();

      // add a query filter
      mgppqueryfilterclass *queryfilter = new mgppqueryfilterclass();
      queryfilter->set_gdbmptr (gdbmhandler);
      queryfilter->set_mgsearchptr (mgsearch);
      cserver->add_filter (queryfilter);
      
      // add a mg and gdbm source
      mggdbmsourceclass *mggdbmsource = new mggdbmsourceclass ();
      mggdbmsource->set_gdbmptr (gdbmhandler);
      mggdbmsource->set_mgsearchptr (mgsearch);
      cserver->add_source (mggdbmsource);
   
    }
#endif    

    // inform collection server and everything it contains about its
    // collection name
    cserver->configure ("collection", *thiscol);
  
    // configure receptionist's collectinfo structure 
    text_tarray colinfo;
    colinfo.push_back (*thiscol);
    colinfo.push_back (gsdlhome);
    colinfo.push_back (gsdlhome);
    recpt.configure ("collectinfo", colinfo);
    
    nproto.add_collectserver (cserver);
    thiscol ++;
  }
  */

  // add the protocol to the receptionist
  recpt.add_protocol (&nproto);

  // z39.50 stuff - johnmcp
#if defined(USE_Z3950)
  /*#ifndef __WIN32__*/
  // add the z39.50 server information. Read in the file
  // etc/recpt/z3950.cfg for list of servers and their databases.
  text_t z3950cfg = filename_cat (gsdlhome, "etc");
  z3950cfg = filename_cat (z3950cfg, "recpt");
  z3950cfg = filename_cat (z3950cfg, "z3950.cfg");
#ifdef USE_FASTCGI
  // currently can't use z39.50 if fastcgi used
#warning  "Disabling z39.50 support as fastcgi is in use"
  if (0) {
#else
  if (file_exists(z3950cfg)) {
#endif
    text_t z3950err = filename_cat (gsdlhome, "etc", "z3950log.txt");
    zproto.read_config_file(z3950cfg,z3950err);
    // only add this protocol if we have any servers configured.
    if (zproto.getServerCount()>0)
      recpt.add_protocol (&zproto);
  }
#endif

  // the list of actions. Note: these actions will become invalid
  // at the end of this function.
  tipaction atipaction;
  recpt.add_action (&atipaction);

  statusaction astatusaction;
  astatusaction.set_receptionist (&recpt);
  recpt.add_action (&astatusaction);

  pageaction apageaction;
  apageaction.set_receptionist (&recpt);
  recpt.add_action (&apageaction);

  pingaction apingaction;
  recpt.add_action (&apingaction);

  queryaction aqueryaction;
  aqueryaction.set_receptionist (&recpt);
  recpt.add_action (&aqueryaction);

  documentaction adocumentaction;
  adocumentaction.set_receptionist (&recpt);
  recpt.add_action (&adocumentaction);

  usersaction ausersaction;
  recpt.add_action (&ausersaction);

  extlinkaction anextlinkaction;
  recpt.add_action (&anextlinkaction);

  authenaction aauthenaction;
  aauthenaction.set_receptionist(&recpt);
  recpt.add_action (&aauthenaction);

  collectoraction acollectoraction;
  acollectoraction.set_receptionist (&recpt);
  recpt.add_action(&acollectoraction);

  // list of browsers
  vlistbrowserclass avlistbrowserclass;
  recpt.add_browser (&avlistbrowserclass);
  recpt.setdefaultbrowser ("VList");

  hlistbrowserclass ahlistbrowserclass;
  recpt.add_browser (&ahlistbrowserclass);

  datelistbrowserclass adatelistbrowserclass;
  recpt.add_browser (&adatelistbrowserclass);

  invbrowserclass ainvbrowserclass;
  recpt.add_browser (&ainvbrowserclass);

  pagedbrowserclass apagedbrowserclass;
  recpt.add_browser (&apagedbrowserclass);

  htmlbrowserclass ahtmlbrowserclass;
  recpt.add_browser (&ahtmlbrowserclass);

  phindbrowserclass aphindbrowserclass;
  recpt.add_browser (&aphindbrowserclass);

  cgiwrapper (recpt, "");
  delete cservers;
  return 0;
}

