/**********************************************************************
 *
 * historydb.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef HISTORYDB_H
#define HISTORYDB_H

#include "infodbclass.h"
#include "text_t.h"
#include "recptproto.h"
#include "cgiargs.h"

/*
struct HistRecord {
  text_t entry;
  bool save;
};

struct ltinttext_t
{
  bool operator()(const text_t &t1, const text_t &t2) const
  { return t1.getint() < t2.getint(); }
};


typedef map<text_t, HistRecord, ltinttext_t> HistRecordmap;

*/
// returns true on success (in which case historyinfo will contain
// the information for this history)
bool get_history_info (const text_t &userid, text_tarray &historyinfo, 
		       const text_t &gsdlhome, ostream &logout);

// returns true on success
bool set_history_info (const text_t &userid, const text_t &historyinfo, 
		       const text_t &gsdlhome, bool display);

// delete all history for one user
bool delete_all_history_info (const text_t &userid, const text_t &gsdlhome);

// retrieves the value of an arg (key) from a list of cgi args
// in the form a=q&b=1&...
void parse_saved_args(text_t &args, text_t key, text_t &value);

// extracts out the components of an entry in the database
// currently:
// numdocs cgiargs
void split_saved_query(text_t &query,  text_t &numdocs, text_t &cgiargs);

// takes the cgiarg string, and outputs it in some form useful
// to the user
void format_user_info (text_t &cgiargs, text_t &info, 
		       cgiargsclass &args,
		       recptprotolistclass *protos, ostream &logout);

#endif
