/**********************************************************************
 *
 * converter.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef CONVERTER_H
#define CONVERTER_H


#include "gsdlconf.h"
#include "text_t.h"
#include "gsdlunicode.h"

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\map>
#elif defined(GSDL_USE_STL_H)
#  include <map.h>
#else
#  include <map>
#endif


// inconverter and outconverter ARE NOT destroyed by this class
// they should be destroyed by the code which created them after
// no more pointers to the class exist.
//
// The above condition enables the class to be copied without
// copying the converters which might contain a lot of data (and
// be of an unknown derived type).
class converterinfo {
public:
  text_t name;
  inconvertclass *inconverter;
  rzwsoutconvertclass *outconverter;

  converterinfo() {inconverter=NULL; outconverter=NULL;}
};

bool operator==(const converterinfo &x, const converterinfo &y);
bool operator<(const converterinfo &x, const converterinfo &y);


typedef map<text_t, converterinfo, lttext_t> convertmap;

// convertinfoclass is used to store a number of converters
// indexing them by their name
class convertinfoclass {
protected:
  convertmap converters;

public:
  // type support for convertmap
  typedef convertmap::iterator iterator;
  typedef convertmap::const_iterator const_iterator;
  typedef convertmap::reference reference;
  typedef convertmap::const_reference const_reference;
  typedef convertmap::size_type size_type;
  typedef convertmap::difference_type difference_type;
  typedef convertmap::const_reverse_iterator const_reverse_iterator;
  typedef convertmap::reverse_iterator reverse_iterator;
  
  // constructors
  convertinfoclass () {}

  // basic container support
  iterator begin () {return converters.begin();}
  const_iterator begin () const {return converters.begin();}
  iterator end () {return converters.end();}
  const_iterator end () const {return converters.end();}

  void erase(iterator pos) {converters.erase(pos);}
  void erase(iterator first, iterator last) {converters.erase(first, last);}
  convertinfoclass &operator=(const convertinfoclass &x) 
    {converters=x.converters;return *this;}

  bool empty () const {return converters.empty();}
  size_type size() const {return converters.size();}

  const_iterator find(text_t &key) {return converters.find(key);}

  // added functionality
  void clear () {converters.erase(converters.begin(),converters.end());}

  // the converters within converterinfo become the property of
  // of this class after add_converter has been called. The converters
  // remain the responsability of the calling code and will not be
  // deleted by this class.
  void add_converter (const text_t &name, inconvertclass *inconverter,
		      rzwsoutconvertclass *outconverter);

  // get_inconverter will return NULL if the convert could not be found
  inconvertclass *get_inconverter (const text_t &name);

  // get_outconverter will return NULL if the convert could not be found
  rzwsoutconvertclass *get_outconverter (const text_t &name);
};




#endif
