/**********************************************************************
 *
 * cgiutils.h -- general cgi utilities
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef CGIUTILS_H
#define CGIUTILS_H

#include "gsdlconf.h"
#include "text_t.h"
#include "cgiargs.h"


// convert %xx and + to their appropriate equivalents
void decode_cgi_arg (text_t &argstr);

// split up the cgi arguments
void split_cgi_args (const cgiargsinfoclass &argsinfo, text_t argstr, 
		     cgiargsclass &args);

// turns any '-' in a cgi argument into "(-)"
text_t minus_safe (const text_t &intext);

// returns the encoded version of a cgi argument
text_t cgi_safe (const text_t &intext);

// check_save_conf_str checks the configuration string for
// the saved args and makes sure it does not conflict with
// the information about the arguments. If an error is encountered
// it will return false and the program should not produce any
// output.
bool check_save_conf_str (const text_t &saveconf, 
			  const cgiargsinfoclass &argsinfo,
			  ostream &logout);

// create_save_conf_str will create a configuration string
// based on the information in argsinfo. This method of configuration
// is not recomended as small changes can produce large changes in
// the resulting configuration string (for instance a totally different
// ordering). Only arguments which "must" be saved are included in
// the resulting string.
text_t create_save_conf_str (const cgiargsinfoclass &argsinfo,
			     ostream &logout);

// expand_compress_args will expand the compressed arguments based
// on compressconf placing the results in args if they are not
// already defined. If it encounters an error it will return false
// and output more information to logout.
bool expand_save_args (const cgiargsinfoclass &argsinfo,
		       const text_t &saveconf, 
		       cgiargsclass &args,
		       ostream &logout);

// adds the default values for those arguments which have not
// been specified
void add_default_args (const cgiargsinfoclass &argsinfo,
		       cgiargsclass &args,
		       ostream &logout);

// compress_save_args will compress the arguments and return
// them in compressed_args. If an error was encountered
// compressed_args will be set to to "", an error will be
// written to logout, and the function will return false.
bool compress_save_args (const cgiargsinfoclass &argsinfo,
			 const text_t &saveconf,
			 cgiargsclass &args,
			 text_t &compressed_args,
			 outconvertclass &outconvert,
			 ostream &logout);

// args_tounicode converts any arguments which are not in unicode
// to unicode using inconvert
void args_tounicode (cgiargsclass &args, inconvertclass &inconvert);

text_t gsdl_getenv (const text_t &name, text_tmap &fcgienv);

#endif
