/**********************************************************************
 *
 * browserclass.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: browserclass.h,v 1.7 2001/01/25 18:26:44 cs025 Exp $
 *
 *********************************************************************/


#ifndef BROWSERCLASS_H
#define BROWSERCLASS_H

#include "gsdlconf.h"
#include "text_t.h"
#include "cgiargs.h"
#include "display.h"
#include "recptproto.h"
#include "formattools.h"

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\iostream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#else
#  include <iostream>
#endif


class browserclass {
protected:

public:
  browserclass ();
  virtual ~browserclass ();

  // configure should be called once for each configuration line
  virtual void configure (const text_t &key, const text_tarray &cfgline);

  // init should be called after all the configuration is done but
  // before any other methods are called
  virtual bool init (ostream &logout);

  // returns the name that specifies the browserclass type
  virtual text_t get_browser_name ();
  
  virtual void processOID (cgiargsclass &args, recptproto *collectproto, ostream &logout);
  
  // load_metadata_defaults should be called before
  // doing protocol call to get metadata for OID to
  // be displayed by this browserclass. it adds fields
  // to the metadata set that are needed by browserclass
  // during display
  virtual void load_metadata_defaults (text_tset &metadata);

  virtual text_t get_default_formatstring ();

  void set_filter_options (FilterRequest_t &request, cgiargsclass &args);
  
  // output_section_group returns the number of tabs to add before displaying the
  // next section group
  // The first version takes one result of a search/query action, the
  // second takes all the results; ResultDocInfo_t is actually a child struct
  // of FilterResponse_t items.  The second version tends to output parts of an
  // abstract structure (e.g. for a table of contents/classifier list, the first
  // for an individual document
  virtual int output_section_group (ResultDocInfo_t &section, cgiargsclass &args,
				    const text_t &collection, int colnumber, 
				    format_t *formatlistptr, bool use_table, 
				    text_tset &metadata, bool &getParents,
				    recptproto *collectproto, displayclass &disp, 
				    outconvertclass &outconvert, ostream &textout, 
				    ostream &logout);

  virtual int output_section_group (FilterResponse_t &sections, cgiargsclass &args,
				    const text_t &collection, int colnumber, 
				    format_t *formatlistptr, bool use_table, 
				    text_tset &metadata, bool &getParents,
				    recptproto *collectproto, displayclass &disp, 
				    outconvertclass &outconvert, ostream &textout, 
				    ostream &logout);
};


// The browserptr function does not 'own' the browser. The 
// browser should be deleted by the code which created it.
class browserptr {
public:
  browserclass *b;

  browserptr () {b=NULL;}
};

bool operator==(const browserptr &x, const browserptr &y);
bool operator<(const browserptr &x, const browserptr &y);

typedef map<text_t, browserptr, lttext_t> browserptrmap;

// contains a list of browsers indexed by their name
class browsermapclass {
protected:
  browserptrmap browserptrs;
  text_t defaultbrowser;

public:
  // type support for browserptrmap
  typedef browserptrmap::iterator iterator;
  typedef browserptrmap::const_iterator const_iterator;
  typedef browserptrmap::reference reference;
  typedef browserptrmap::const_reference const_reference;
  typedef browserptrmap::size_type size_type;

  typedef browserptrmap::difference_type difference_type;
  typedef browserptrmap::const_reverse_iterator const_reverse_iterator;
  typedef browserptrmap::reverse_iterator reverse_iterator;
  
  // basic container support
  iterator begin () {return browserptrs.begin();}
  const_iterator begin () const {return browserptrs.begin();}
  iterator end () {return browserptrs.end();}
  const_iterator end () const {return browserptrs.end();}

  void erase(iterator pos) {browserptrs.erase(pos);}
  void erase(iterator first, iterator last) {browserptrs.erase(first, last);}
  browsermapclass &operator=(const browsermapclass &x) {browserptrs=x.browserptrs;return *this;}

  bool empty () const {return browserptrs.empty();}
  size_type size() const {return browserptrs.size();}


  // added functionality
  void clear () {browserptrs.erase(browserptrs.begin(),browserptrs.end());}

  // thebrowserclass remains the property of the calling code but
  // should not be deleted until it is removed from this list.
  void addbrowser (browserclass *thebrowserclass);

  // getbrowser will return NULL if the browser could not be found
  browserclass *getbrowser (const text_t &key);

  void setdefaultbrowser (const text_t &browsername);

  browserclass *get_default_browser ();
};


#endif
