/**************************************************************************
 *
 * TextEl.h -- Data structures for parsed documents
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: TextEl.h,v 1.1 2000/01/14 02:17:47 sjboddie Exp $
 *
 **************************************************************************/

#ifndef TEXTEL_H
#define TEXTEL_H

#include "UCArray.h"
#include "FileBuf.h"


enum TextElType {OpenTagE, CloseTagE, TextE};

class TextEl {
protected:
  bool ReadTextTag (FileBuf &buf, TextEl &el);
public:
  TextElType elType;
  UCArray tagName;
  UCArray text; // complete text, including tag

  TextEl () { Clear (); }
  void Clear ();
};


typedef vector<TextEl> TextElArray;


// compatMode parses documents similar to "old mg" -- ie with
// C-b between documents and C-c between paragraphs

// returns true if a text element could be read
bool ReadTextEl (FileBuf &buf, TextEl &el,
		 bool compatMode, bool &compatInPara);

// looks for an opening docTag and reads all text elements up
// to a corresponding closing docTag. note that this does not
// hierarchically parse the document so you can't nest documents.
// returns true if a document could be found
bool ReadDoc (FileBuf &buf, const UCArray &docTag,
	      TextElArray &doc, unsigned long &docLen,
	      bool compatMode=false);

#endif
