/**************************************************************************
 *
 * IndexData.h -- Information needed for querying
 * Copyright (C) 1999 Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: IndexData.h,v 1.1 2000/01/14 02:17:39 sjboddie Exp $
 *
 **************************************************************************/

#ifndef INDEXDATA_H
#define INDEXDATA_H

#include <stdio.h>
#include "invf.h"
#include "FIvfLevelInfo.h"
#include "FragLevelConvert.h"
#include "Weights.h"


class IndexData {
public:
  // general information
  char basePath[512];
  char filename[512];
  FIvfLevel levels;
  
  // blocked dictionary
  FILE *dictFile;
  block_dict_header bdh;
  block_idx biWords;
  block_idx biTags;

  // stem indexes
  FILE *stem1File;
  FILE *stem2File;
  FILE *stem3File;
  stem_idx_header sih1;
  stem_idx_header sih2;
  stem_idx_header sih3;
  block_idx sii1;
  block_idx sii2;
  block_idx sii3;

  // inverted file
  FILE *invfFile;
  invf_file_header ifh;

  // weights
  FILE *approxWeightsFile;
  FILE *exactWeightsFile;

  // level specific information
  UCArray curLevel; // last level that was loaded
  unsigned long curLevelNum;
  FragLevelConvert levelConverter;
  ApproxWeightsData weightData;
  
  IndexData ();
  ~IndexData ();

  // LoadData will only load the data if it has not been loaded before
  bool LoadData (const char *_basePath, const char *_filename);
  bool UnloadData ();

  bool LoadLevel (const UCArray &level);
  bool UnloadLevel ();
};


#endif
