/**************************************************************************
 *
 * QueryParser.h -- Query parser for a simple query language
 * Copyright (C) 2000  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: GSDLQueryParser.h,v 1.3 2000/12/07 22:36:32 kjm18 Exp $
 *
 **************************************************************************/

#ifndef GSDLQUERYPARSER_H
#define GSDLQUERYPARSER_H

#include "UCArray.h"
#include "MGQuery.h"

// returns NULL if the query could not be parsed
// defaultBoolCOmbine determines if individual terms are combined using
// AND or OR in the absence of specified operators.
// defaultStemMethod used to set stemming and casefolding for terms where
// its not set explicitly in the query string. THe defaultStemMethod value
// should be set using the values from the preferences page
QueryNode *ParseQuery (const UCArray &queryStr, int defaultBoolCombine,
		       int defaultStemMethod);

#endif
