/**************************************************************************
 *
 * GSDLQueryLex.h -- Lexical analyser for a simple query language, for GSDL
 * Copyright (C) 2000  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: GSDLQueryLex.h,v 1.1 2000/04/18 04:09:10 kjm18 Exp $
 *
 **************************************************************************/

#ifndef GSDLQUERYLEX_H
#define GSDLQUERYLEX_H

#include "UCArray.h"


// note: white space is ignored
enum LexType {NoTypeE, OpenBracketE, CloseBracketE, TermE, AndOpE, OrOpE,
	      NotOpE, NearOpE, QuoteE, IntegerE, TermWeightE, StemMethodE,
	      RangeE, AtE, TagE, OpenSquareBracketE, CloseSquareBracketE};

struct LexEl {
  LexType lexType;
  UCArray text;
  int num; // for IntegerE

  void Clear () {
    lexType = NoTypeE;
    UCArrayClear (text);
    num = 0;
  }
  LexEl () { Clear (); }
};


// returns true if another lexical element could be parsed.
bool ParseLexEl (UCArray::const_iterator &here,
		 UCArray::const_iterator end,
		 LexEl &el);


#endif










