/**************************************************************************
 *
 * bitio_m_mems.h -- Macros for bitio to memory (random access)
 * Copyright (C) 1994  Neil Sharman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: bitio_m_mems.h,v 1.1 2000/01/14 02:17:01 sjboddie Exp $
 *
 **************************************************************************
 *
 *  This file contains macros for doing bitwise input and output on an array 
 *  of chars. These routines are slower than the ones in "mem" files. but 
 *  with these routines you can mix reads and writes, or multiple writes,  on
 *  the array of chars at the same time and guarantee them to work, also you 
 *  can seek to a point and do a write. The decode and encode macros cannot 
 *  detect when the end off the character is reached and just continue 
 *  processing.
 *
 **************************************************************************/

#ifndef H_BITIO_M_MEMS
#define H_BITIO_M_MEMS

#include "bitio_m_abstract.h"


class mems_bitio_buffer : public bitio_buffer {
protected:
  unsigned char *base;
  unsigned long  pos;
  
public:
  mems_bitio_buffer();
  mems_bitio_buffer(unsigned char *readbuffer, long _pos);
  void seek(unsigned long topos);
  void error();
  long add00(long b);
  long addff(long b);
  int  bit();
  //  int  bitOffset();
  void done();

  unsigned long position();

  void encodeStart();
  void encodeBit(int b);
  void encodeDone();
  void flush();
};


/*#define ENCODE_START(b,p)						\
  {									\
    mems_bitio_buffer buffer(b, p);

#define ENCODE_CONTINUE(b)						\
  {									\
    mems_bitio_buffer buffer;                                          \
    buffer.unpause(b);

#define ENCODE_PAUSE(b)	buffer.pause(&b);}

#define ENCODE_FLUSH buffer.flush();


#define ENCODE_DONE buffer.encodeDone();}


#define DECODE_START(b,p)						\
  {		                                                        \
    mems_bitio_buffer buffer(b, p);

#define DECODE_CONTINUE(b)						\
  {									\
    mems_bitio_buffer buffer;                                          \
    buffer.unpause(b);

#define DECODE_ADD_FF(b) b = buffer.addff(b);

#define DECODE_ADD_00(b) b = buffer.add00(b);

#define DECODE_BIT buffer.bit()

#define DECODE_DONE buffer.done();}

#define DECODE_PAUSE(b) buffer.pause(&b);}
*/

#endif
