/**********************************************************************
 *
 * mgqueryfilter.h -- queryfilter for old mg
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mgqueryfilter.h,v 1.3 2000/11/16 03:19:13 nzdl Exp $
 *
 *********************************************************************/


#ifndef MGQUERYFILTER_H
#define MGQUERYFILTER_H

#include "queryfilter.h"

// resultsorderer_t is used to sort the query results
struct resultsorderer_t {
  bool compare_phrase_match;
  bool compare_terms_match;
  bool compare_doc_weight;
  docresultmap *docset;

  resultsorderer_t();
  void clear();
  bool operator()(const int &t1, const int &t2) const;
};



class mgqueryfilterclass : public queryfilterclass {
protected:
  
  int num_phrases;

  void get_phrase_terms (const text_t &querystring, 
			 const termfreqclassarray &orgterms,
			 vector<termfreqclassarray> &phrases);

  // do aditional query processing
  virtual void post_process (const queryparamclass &queryparams,
			     queryresultsclass &queryresults);

  // do query that might involve multiple sub queries
  // mgsearchptr and gdbmptr are assumed to be valid
  void do_multi_query (const FilterRequest_t &request,
		       const vector<queryparamclass> &query_params,
		       queryresultsclass &multiresults,
		       comerror_t &err, ostream &logout);

  virtual void sort_doc_results (const FilterRequest_t &request,
				 docresultsclass &docs);

  virtual void mg_parse_query_params (const FilterRequest_t &request,
				      vector<queryparamclass> &query_params,
				      int &startresults, int &endresults,
				      text_t &phrasematch, ostream &logout);

  
public:
  mgqueryfilterclass ();
  virtual ~mgqueryfilterclass ();

  void filter (const FilterRequest_t &request,
	       FilterResponse_t &response,
	       comerror_t &err, ostream &logout);
};


#endif

