/************************************************************
 * 
 * Collection set
 *
 ************************************************************/

#ifndef COLLECTSET_H
#define COLLECTSET_H

#include "collectserver.h"
#include "cnfgable.h"
#include "receptionist.h" // Added 8/9/200 to permit receptionist configuration

class collectset : public configurable
{
 protected:
  collectservermapclass cservers;
  int                   noofservers;
  text_t                httpdomain;
  text_t                httpprefix;

 public:
  collectset(text_t &gsdlhome);
  // this constructor is used by the local library
  collectset() {}

  ~collectset();

  // initialise the collections
  bool init(ostream &logout);

  // configure all the servers as supplied
  void configure (const text_t &key, const text_tarray &cfgline);

  // Add/remove collections
  void collectset::remove_collection (const text_t &collection, ostream &logout);
  void collectset::add_collection (const text_t &collection, void *recpt, 
				  const text_t &gsdlhome, const text_t &gdbmhome);

  // return the total number of servers in the set
  int size();

  void getCollectionList(text_tarray &collist);

  // return the component map
  collectservermapclass servers();

  // configure a receptionist with the list of servers
  void setReceptionistServers(receptionist &recpt, text_t &gsdlhome);

  // return an individual collection server
  collectserver *getCollectServer(const text_t &collection)
    {
      return cservers.getcollectserver(collection);
    }
};

#endif
