/**********************************************************************
 *
 * corbaconv_text_t.mpp -- conversion support text_t <-> corba_text_t
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: corbaconv_text_t.h,v 1.2 2001/01/25 18:26:43 cs025 Exp $
 *
 *********************************************************************/


#ifndef CORBACONV_TEXT_T_H
#define CORBACONV_TEXT_T_H

#include "text_t.h"

// Inherit from text_t
// Provide support to convert from corba_text_t to text_t and vice versa

class corbaconv_text_t : public text_t {
  
public:
  // constructors
  corbaconv_text_t (corbatext_t t);

  void setCorbatext(corbatext_t ct);
  void getCorbatext(corbatext_t &ct) const;
  void fillUsString(usString *us) const;

  static void setCorbatext(text_t& t, corbatext_t ct);
  static void getCorbatext(const text_t& t, corbatext_t &ct);
  static void fillUsString(const text_t& t, usString *us);
};


inline void corbaconv_text_t::setCorbatext(corbatext_t ct) 
{ 
  setCorbatext(*this,ct); 
}

inline void corbaconv_text_t::getCorbatext(corbatext_t& ct) const
{ 
  getCorbatext(*this,ct); 
}

inline void corbaconv_text_t::fillUsString(usString *us) const
{
  fillUsString(*this,us);
}

#endif
