###########################################################################
#
# ArcPlug.pm --
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

# plugin which recurses through an archives.inf file
# (i.e. the file generated in the archives directory
# when an import is done), processing each file it finds 

package ArcPlug;

use util;
use BasPlug;
use plugin;
use arcinfo;

BEGIN {
    @ISA = ('BasPlug');
}

sub new {
    my ($class) = @_;
    my $self = new BasPlug ("ArcPlug", @_);

    return bless $self, $class;
}

# return 1 if this class might recurse using $pluginfo
sub is_recursive {
    my $self = shift (@_);

    return 1;
}

# return number of files processed, undef if can't process
# Note that $base_dir might be "" and that $file might 
# include directories
sub read {
    my $self = shift (@_);
    my ($pluginfo, $base_dir, $file, $metadata, $processor, $maxdocs) = @_;
    my $outhandle = $self->{'outhandle'};

    my $count = 0;

    # see if this has a archives information file within it
    my $archive_info_filename = &util::filename_cat($base_dir,$file,"archives.inf");

    if (-e $archive_info_filename) {

	# found an archives.inf file
	print $outhandle "ArcPlug: processing $archive_info_filename\n";

	# read in the archives information file
	my $archive_info = new arcinfo ();
	$archive_info->load_info ($archive_info_filename);
	
	my $file_list = $archive_info->get_file_list();

	# process each file
	foreach my $subfile (@$file_list) {
	    last if ($maxdocs != -1 && $count >= $maxdocs);

	    my $tmp = &util::filename_cat ($file, $subfile->[0]);
	    next if $tmp eq $file;
	    # note: metadata is not carried on to the next level
	    $count += &plugin::read ($pluginfo, $base_dir, $tmp, {}, $processor, $maxdocs);
	}

	return $count;
    }

    # wasn't an archives directory, someone else will have to process it
    return undef;
}

1;
