###########################################################################
#
# colcfg.pm --
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

# reads in a collection configuration file

package colcfg;

use cfgread;


# the collection configuration file data is stored in the form
#
# {'creator'}->string
# {'public'}->string
# {'beta'}->string
# {'defaultindex'}->string
# {'importdir'}->string
# {'archivedir'}->string
# {'cachedir'}->string
# {'builddir'}->string
# {'removeold'}->string
# {'textcompress'}->string
# {'buildtype'}->string

# {'maintainer'}->array of strings
# {'languages'}->array of strings
# {'indexsubcollections'}->array of strings
# {'indexes'}->array of strings
# {'dontbuild'}->array of strings
# {'dontgdbm'}->array of strings
# {'mirror'}->array of strings
# {'phind'}->array of strings
# {'levels'}->array of strings (for mgpp eg Section, Paragraph)

# {'subcollection'}->hash of key-value pairs
# {'collectionmeta'}->hash of key-value pairs

# {'plugin'}->array of arrays of strings
# {'classify'}->array of arrays of strings

sub read_collect_cfg {
    my ($filename) = @_;

    return &cfgread::read_cfg_file ($filename, 
				    q/^(creator|public|beta|defaultindex|importdir|/ .
					q/archivedir|cachedir|builddir|removeold|textcompress|buildtype)$/,
				    q/(maintainer|languages|indexsubcollections|/ .
				       q/indexes|dontbuild|dontgdbm|mirror|phind|levels)$/,
				    q/^(subcollection|collectionmeta)$/,
				    q/^(plugin|classify)$/);
}

sub write_collect_cfg {
    my ($filename, $data) = @_;

    &cfgread::write_cfg_file($filename, $data,
			     q/^(creator|public|beta|defaultindex|importdir|/ .
				 q/archivedir|cachedir|builddir|removeold|textcompress|buildtype)$/,
			     q/^(maintainer|languages|indexsubcollections|/ .
				 q/indexes|dontbuild|dontgdbm|levels)$/,
			     q/^(subcollection|collectionmeta)$/,
			     q/^(plugin|classify)$/);
}


# the build configuration file data is stored in the form
#
# {'builddate'}->string
# {'buildtype'}->string
# {'metadata'}->array of strings
# {'languages'}->array of strings
# {'numdocs'}->string
# {'numwords'}->string
# {'numbytes'}->string
# {'indexfields'}->array of strings

sub read_build_cfg {
    my ($filename) = @_;

    return &cfgread::read_cfg_file ($filename, 
				    q/^(builddate|buildtype|numdocs|numwords|numbytes)$/, 
				    q/^(metadata|languages|indexfields)$/);
}

sub write_build_cfg {
    my ($filename, $data) = @_;

    &cfgread::write_cfg_file($filename, $data,
			     q/^(builddate|buildtype|numdocs|numwords|numbytes)$/, 
			     q/^(metadata|languages|indexfields)$/);
}


1;
