#!/usr/bin/perl -w

# count-lines.pl - a quick script for counting
# the number of times each line appears in a file.
# Useful for building keyphrase-frequency files
# (see README for instructions).

while (<>) {
    chomp;
    if ($_ =~ /./) { 
	s/\s/ /g;
	$counter{$_}++; 
    } else { 
	$counter{"_blank_"}++; 
    }
}

foreach $k (sort keys(%counter)) {
    print "$k\t$counter{$k}\n";
}

