# nzdlhome.dm
#
# This file defines the homepage of the New Zealand Digital Library Project
# as it appears on Http://www.nzdl.org. It is designed to override the default
# homepage (defined in home.dm), so it should appear last in the "macrofiles"
# section of the main.cfg file.
#

package home

#######################################################################
# java images/scripts
#######################################################################

# the _javalinks_ macros are the flashy image links at the top right of
# the page. this is overridden here as we don't want 'home' 
# links on this page

_javalinks_ {}
_javalinks_ [v=1] {}



#######################################################################
# icons
#######################################################################

_iconnzdl_ {<img src="_httpiconnzdl_" width=_widthnzdl_ height=_heightnzdl_ alt="The New Zealand Digital Library">}
_icongbull_ {<img src="_httpicongbull_">}
_iconpdf_ {<img src="_httpiconpdf_">}

_iconselectcollection_ {<img src="_httpiconselcolgr_" width=_widthselcolgr_ height=_heightselcolgr_ alt=_altselcolgr_>}

## "reference collections" ## green_bar_left_aligned ## selcolrf ##
_httpiconselcolrf_ {_httpimg_/selcolrf.gif}
_widthselcolrf_ {537}
_heightselcolrf_ {17}
_altselcolrf_ {"Reference collections"}

## "humanitarian and UN collections" ## green_bar_left_aligned ## selcolun ##
_httpiconselcolun_ {_httpimg_/selcolun.gif}
_widthselcolun_ {537}
_heightselcolun_ {17}
_altselcolun_ {"Humanitarian and UN collections"}

## "demonstration collections" ## green_bar_left_aligned ## selcolde ##
_httpiconselcolde_ {_httpimg_/selcolde.gif}
_widthselcolde_ {537}
_heightselcolde_ {17}
_altselcolde_ {"Demonstration collections"}

_iconselectrf_ {<img src="_httpiconselcolrf_" width=_widthselcolrf_ height=_heightselcolrf_ alt=_altselcolrf_>}
_iconselectun_ {<img src="_httpiconselcolun_" width=_widthselcolun_ height=_heightselcolun_ alt=_altselcolun_>}
_iconselectde_ {<img src="_httpiconselcolde_" width=_widthselcolde_ height=_heightselcolde_ alt=_altselcolde_>}

_iconmusiclibrary_ {<img src="_httpicontmusic_" border=1 alt="meldex music library">}


#######################################################################
# http macros 
#
# These contain the url without any quotes
#######################################################################

_httpicongbull_ {_httpimg_/gbull.gif}

_httpiconpdf_ {_httpimg_/pdf.gif}

_httpicontmusic_ {_httpimg_/meldexsm.gif}


#######################################################################
# page content                     
#######################################################################

_pagetitle_ {_textpagetitle_}
_imagethispage_ {}
_imagecollection_ {<center>_iconnzdl_</center>}

_content_ {
_nzdlcollectionlist_
<center>_iconblankbar_</center>

<p><center><h2>_textprojhead_</h2></center>

<table border=0 cellpadding=5>

<tr valign=top>
<td>
<table><tr valign=middle><td>_icongbull_</td><td><a href="mailto:_mailaddr_">_textfb_</a></td></tr></table>
<table><tr valign=middle><td>_icongbull_</td><td><a href="http://www.nzdl.org/html/people.html">People</a></td></tr></table>
</td>
<td>_textprojinfo_</td>
</tr>

<tr>
<td></td>
<th align=left>_titlesoftwareinfo_</th>
</tr>
<tr valign=top>
<td>
<table><tr valign=middle><td>_icongbull_</td><td><a href="_httppagex_(gsdl)">About<br>Greenstone</a></td></tr></table>
<table><tr valign=middle><td>_icongbull_</td><td><a href="http://www.nzdl.org/html/DOWNLOAD.html">Download<br>Greenstone</a></td></tr></table>
<table><tr valign=middle><td>_icongbull_</td><td><a href="http://www.nzdl.org/html/trouble.html">Installation<br>Guide</a></td><td><img src="http://www.nzdl.org/images/new2.gif"></td></tr></table>
<table><tr valign=middle><td>_iconpdf_</td><td><a href="_gsdl:httpgsdlmanual_">Manual</a></td></tr></table>
<table><tr valign=middle><td>_iconpdf_</td><td><a href="_httppublications_/NZDLtext.pdf">_textinfosheet_</a></td></tr></table>

</td>
<td>_textsoftwareinfo_</td>
</tr>

<tr>
<td></td>
<th align=left>_titleresearchinfo_</th>
</tr>
<tr valign=top>
<td>
<table><tr valign=middle><td>_icongbull_</td><td><a href="http://www.nzdl.org/html/research.html">Research</a></td></tr></table>
<table><tr valign=middle><td>_icongbull_</td><td><a href="http://www.nzdl.org/html/projects.html">Projects</a></td></tr></table>
<table><tr valign=middle><td>_icongbull_</td><td><a href="http://www.nzdl.org/html/software.html">Software<br>Downloads</a></td></tr></table>
<table><tr valign=middle><td>_icongbull_</td><td><a href="http://www.cs.waikato.ac.nz/~nzdl/publications/">Publications</a></td></tr></table>
</td>
<td>_textresearchinfo_</td>
</tr>

<tr valign=top>
<td>
<table><tr valign=middle><td>_icongbull_</td><td><a href="http://nzdl2.cs.waikato.ac.nz/~jrm21/library.cgi">Z39.50<br>demo</a></td><td><img src="http://www.nzdl.org/images/new2.gif"></td></tr></table>
</td><td>
We have an experimental facility for searching Z39.50 collections using
Greenstone.  Ultimately we plan a full bibliographic search facility, with
the ability to combine tests on different fields, and to be able to search
multiple collections, including cross-searching Greenstone and Z39.50
collections.
</td>
</tr>

<tr>
<td></td>
<th align=left>_titleaffiliateinfo_</th>
</tr>
<tr valign=top>
<td>
<img src="_httpimg_/ghproj.jpg" alt="Global Help Projects" width=100 height=90>
</td>
<td>_textaffiliateinfo_</td>
</tr></table></p>

_iconblankbar_
<table>
<tr valign=top>
<td>_textpoem_</td>
<td>_imagegreenstone_</td>
</tr></table>
<p>_textgreenstone_

<p>
_nzdlpagefooter_ 
<br>April 2000
}



#######################################################################
# English language text macros
#######################################################################
_textpagetitle_ {New Zealand Digital Library}
_textprojhead_ {The New Zealand Digital Library Project}

_textprojinfo_ {
<p>
The New Zealand Digital Library project is a research programme at
The University of Waikato whose aim is to develop the underlying
technology for digital libraries and make it available publicly so that
others can use it to create their own collections. 
<p>
Our web site provides several document collections, including historical
documents, humanitarian and development information, computer
science technical reports and bibliographies, literary works, and
magazines. All are available over the Web, and can be accessed
through searching and browsing interfacees provided by the
Greenstone digital library software. Behind the query interface lies a
huge collection providing gigabytes of information. We hope you find
what you want, or at least something intriguing!
}

_titlesoftwareinfo_ {The Greenstone software}

_textsoftwareinfo_ {
<p>
The Greenstone Digital Library software provides a new way of
organizing information and making it available over the Internet or on
CD-ROM. It is open-source software, available under the terms of the
Gnu public license. 
<p>
A digital library is made up of a set of collections. Each collection of
information comprises several (typically several thousand, or even
several million) documents, which share a uniform searching and
browsing interface. Collections can be organized in many different
ways while retaining a strong family resemblance. 

<p><a href="mailto:majordomo@colosys.net">Subscribe to the Greenstone
mailing list</a> (type "subscribe greenstone" in the <u>body</u> of the email)

<p align=right>
<a href="_httppagex_(gsdl)">More...</a>
}

_titleresearchinfo_ {Our research}

_textresearchinfo_ {
<p>
The goal of our research program is to explore the potential of
internet-based digital libraries. Our vision is to develop systems that
automatically impose structure on anarchic, uncatalogued, distributed
repositories of information, thereby providing information consumers
with effective tools to locate what they need and to peruse it
conveniently and comfortably. 
<p>
Project members are actively working on techniques for creating,
managing, and and mainatining collections; extracting metadata from
legacy documents; analysing library usage and user needs; Maori,
Arabic and Chinese language systems; internationalising the library
interface; optical music recognition and musical collections; novel
interfaces for formulating queries and visualising results; novel
interfaces for browsing metadata; text mining for keyphrases,
acronyms, and other metadata; keyphrase extraction and
phrase-based browsing; and other research topics. 
<p align=right>
<a href="_httppagex_(research)">More...</a>
}

_titleaffiliateinfo_ {Our affiliates}

_textaffiliateinfo_ {
<p>
<a href="http://www.globalprojects.org">Global Help Projects</a>
is a registered charity responsible for the
Humanity Libraries Project that provides universal low-cost
information access through co-operation between UN Agencies,
universities and NGOs. Global Help Projects collaborate extensively
with the NZDL project, and use the Greenstone software. 
<p>
<a href="http://www.digilibs.com">DigiLib Systems Limited</a>
is an innovative software company that
creates international digital libraries. As a major contributor to the
Greenstone Digital Library Software they are able to build, customize,
and extend digital libraries to meet exacting needs. Please contact them
for an obligation free quote. 
<p>
<a name="mirrors"></a>
The following websites are among those currently using Greenstone,
either to make their own collections available, 
or to mirror New Zealand Digital Library content.
Some are still under development.
<ul>
<li><a href="http://canada.nzdl.org/~nzdl/cgi-bin/library">Canadian Mirror (CISTI)</a>
<li><a href="http://gene.rutgers.edu/cgi-bin/library">Rutgers University</a>
<li><a href="http://csdl1.mdx.ac.uk/">Middlesex University</a>
<li><a href="http://laraine.unidata.ucar.edu/projects/coohl/htdig/cgi-bin/library">Unidata</a>
</ul> 
}


#######################################################################
# The collection display
# A hand-crafted alternative to the _homeextra_ macro
#######################################################################

_nzdlgwcgi_ {http://www.nzdl.org/fast-cgi-bin/library}
#_nzdlgwcgi_ {http://www.nzdl.org/cgi-bin/library}
_nzdlhttpprefix_ {http://www.nzdl.org/gsdl}

_nzdlcollection_ {http://www.nzdl.org/fast-cgi-bin/library?a=p&p=about&c=_1_}
#_nzdlcollection_ {http://www.nzdl.org/cgi-bin/library?a=p&p=about&c=_1_}
_nzdlcollectionimage_ {<img width=150 border=1 src="_nzdlhttpprefix_/collect/_1_/images/_2_" alt=_3_>}

_collectionlink_ {<a href="_nzdlcollection_(_4_)">_nzdlcollectionimage_(_1_,_2_,_3_)</a>}


_nzdlcollectionlist_ {
<center>
<p>_iconselectrf_
<p>_collectactive_
<p>_iconselectun_
<p>_collectfao_
<p>_iconselectde_
<p>_collectrest_
</center>
}

_collectactive_ {
<table width=537>
<tr valign=top>
<td align=center>
<p>_collectionlink_(arabic,  arabic.gif,  "Arabic text collection", arabic&l=ar&nw=u)
<p>_collectionlink_(chinese, chinsm.jpg,  "Chinese text collection", chinese&l=zh&nw=u)
<p>_collectionlink_(gberg,   gbergsm.gif, "Project Gutenberg Collection", gberg)
</td>


<td align=center>
<p><a href="http://www.nzdl.org/fast-cgi-bin/niupepalibrary?a=p&p=about&c=niupepa&l=mi&nw=u"><img width=150 border=1 src="_nzdlhttpprefix_/collect/niupepa/images/niupepsm.gif" alt="Niupepa: M&auml;ori Newspapers"></a>
<p><a href="http://nzdl2.cs.waikato.ac.nz/cgi-bin/gwmm?c=meldex&a=page&p=coltitle"><img src="_nzdlhttpprefix_/images/meldexsm.gif" border=1 alt="Meldex music library"></a>
<p><a href="_nzdlgwcgi_?a=p&p=about&c=musvid"><img width=150 border=1 src="http://www.cosc.canterbury.ac.nz/~davidb/gsdl/collect/musvid/images/musvid_frontpage.gif" alt="Music Videos"></a>
<p><a href="http://www.nzdl.org/fast-cgi-bin/cstrlibrary?a=p&p=about"><img width=150 border=1 src="_nzdlhttpprefix_/collect/cstr/images/cstrsm.gif" alt="Computer Science Technical Reports"></a>
<p>_collectionlink_(csbib, csbibsm.gif, "Computer Science Bibliographies", csbib)
</td>

<td align=center>
<p>_collectionlink_(whist, whist\_logo\_small.gif, "Women&#039;s History Primary Source Documents", whist)
<p>_collectionlink_(ohist, ohist\_title\_small.gif, "Hamilton Public Library Youth Oral History Collection", ohist)
<p>_collectionlink_(hcibib, hcibibsm.gif, "The HCI Bibliography", hcibib)
</td>
</tr></table>
}


_collectfao_ {
<table width=537>
<tr valign=top>
<td align=center>
<p>_collectionlink_(fao1, fao.gif,   "The FAO Web site", fao1)
<p>_collectionlink_(hdl,  hdlsm.gif, "Humanity Development Library", hdl)
<p>_collectionlink_(envl, welsm.gif, "World Environment Library", envl)
<p>_collectionlink_(aginfo, aginfo.gif, "Agricultural Information Modules", aginfo)
</td>
<td align=center>
<p>_collectionlink_(mhl,  mhlsm.gif,   "Medical and Health Library", mhl)
<p>_collectionlink_(fnl,  fnlsm.gif,   "Food and Nutrition Library", fnl)
<p>_collectionlink_(paho, pahosml.gif, "Virtual Disaster Library", paho)

<p>_collectionlink_(povsem, povsem_front.gif, "Poverty Alleviation", povsem)
<p>_collectionlink_(ipc, ipcsm.gif, "Indigenous Peoples", ipc)

</td>
<td align=center>
<p>_collectionlink_(ccgi,   ccgism.gif,   "Collection on Critical Global Issues", ccgi)
<p>_collectionlink_(tulane, tulanesm.gif, "Biblioth&egrave;que pour le d&eacute;veloppement", tulane)
<p>_collectionlink_(unesco, unescosm.gif, "Sahel point Doc", unesco)
</td>
</tr>
</table>
}


_collectrest_ {
<table width=537>
<tr valign=top>

<td align=center>
<p><a href="http://nzdl2.cs.waikato.ac.nz/cgi-bin/library?a=p&p=about&c=scms"><img width=150 border=1 src="http://nzdl2.cs.waikato.ac.nz/gsdl/collect/scms/images/scms.gif" alt="Search Waikato's School of Computing and Mathematical Sciences"></a>
</td>

<td align=center>
<p>_collectionlink_(acrodemo, acrodemosm.gif, "AGRIS: acronym extraction demo", acrodemo)
<p>_collectionlink_(folktale, folktalesm.gif, "Folktales: language extraction demo", folktale)
<p>_collectionlink_(dlmail, dlmailsm.gif, "DLmail: email plugin demonstration", dlmail)
</td>

<td align=center>
<p>_collectionlink_(tcc, tccsm.gif, "The Computists&#039; Weekly", tcc)
<p>_collectionlink_(tidbits, tidbitsm.gif, "TidBITS", tidbits)
</td>

</tr>
</table>
}

# bbc no longer public
#<p>_collectionlink_(bbc1, bbc_home.gif, "BBC archives (1900-1985)", bbc1)
