######################################################################
#
# English Language text and icon macros 
#
######################################################################
#
# This is the main macro file for translation when creating an 
# interface in another language.
#
# Under the 'text macros' comments are text macros of the form:
# _macroname_[l=ar] {macro value}
# Everything between the[l=ar] {} is the text to be translated. This text 
# may itself contain macros (i.e. characters other than space between
# underscore characters, e.g. _about:numdocs_ or _textpage_). These
# macro names occurring within text shouldn't be translated but should
# be left as they are. Underscores or curly brackets occurring 
# naturally within the text should be escaped with a leading backslash
# (i.e. '\_', '\{' or '\}).
#
# Under the 'icons' comments are macros concerned with displaying
# icons which themselves contain text.
# Above each macro (or group of macros) for an icon is a comment line
# that looks something like '## "HOME" ## top_nav_button ## chome ##'.
# The first field of the comment ("HOME" in this case) is the text
# that appears in the english version of the icon. This is the text
# that must be translated, nothing needs to be done to the macros 
# themselves. The other two fields of the comments are used by 
# automatic icon generating software which reads the newly translated
# file and generates appropriate icons.
#
# Comment lines (other than those described above) need not be 
# translated (i.e. any lines beginning with '#', like this line).
#
# The simplest way to translate this file is to save it as something
# else (e.g. french.dm) and work through translating all the text
# macro values and icon comments.
#
######################################################################


######################################################################
# Global (base) package
package Global
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultcontent_[l=ar] { لم يتمكن الحصول على الصفحة المطلوبة يرجو استعمال الزر "وراء" أو الزر "موقع" في أعلى الصفحة للرجوع إلى المكتبة الإلكترونية قرينستون.}

_textdefaulttitle_[l=ar] {خطأ جسدل}

_collectionextra_[l=ar] { هذه المجموعة تحتوي على:_about:numdocs_ وثيقة. 
آخر مرة تم بناؤها _about:builddate_ يوم من قبل. }

_textimagecollection_[l=ar] {}
_textimageabout_[l=ar] {حول الصفحة}
_textimagehome_[l=ar] {الصفحة الرئيسية}
_textimagehelp_[l=ar] {صفحة المساعدة}
_textimagepref_[l=ar] {صفحة الخيارات}
_textimagegreenstone_[l=ar] {برنامج المكتبة الإلكترونية قرينستون}

_textimagesearch_[l=ar] {البحث عن مصطلح معين}
_textimageTitle_[l=ar] {استعرض العناوين حسب الترتيب الهجائي}
_textimageList_[l=ar] {استعرض الوثيقة}
_textimageCreator_[l=ar] {استعرض المؤلفين حسب الترتيب الهجائي}
_textimageSeries_[l=ar] {استعرض حسب الإصدار}
_textimageDate_[l=ar] {استعرض حسب التاريخ}
_textimageSubject_[l=ar] {استعرض حسب صنف الموضوع }
_textimageOrganization_[l=ar] {استعرض حسب اسم المنظمة}
_textimageHowto_[l=ar] {استعرض كيف يتم التصنيف}
_textimageTopic_[l=ar] {استعرض مواضيع خاصة}
_textimageBrowse_[l=ar] {استعرض}
_textimagePeople_[l=ar] {استعرض المساهمون حسب الترتيب الهجائي}

_texticontabsearchgreen_[l=ar] {بحث}
_texticontabdategreen_[l=ar] {التواريخ}
_texticontabseriesgreen_[l=ar] {السلاسل}
_texticontabauthorgreen_[l=ar] {المؤلفون أ-ي}
_texticontabtitlegreen_[l=ar] {العناوين أ-ي}
_texticontablistgreen_[l=ar] {عرض}
_texticontabsubjectgreen_[l=ar] {محاور}
_texticontaborggreen_[l=ar] {منظمة}
_texticontabhowgreen_[l=ar] {كيف}
_texticontabtopicgreen_[l=ar] {مواضيع}
_texticontabbrwsegreen_[l=ar] {استعرض}
_texticontabPeoplegreen_[l=ar] {المساهمون أ-ي}

_texticontext_[l=ar] {شاهد الوثيقة}
_texticonclosedbook_[l=ar] {افتح هذه الوثيقة و شاهد الفهرس}
_texticonnext_[l=ar] {إلى الجزء القادم}
_texticonprev_[l=ar] {إلى الجزء السابق}

_page_[l=ar] {الصفحة}
_pages_[l=ar] {الصفحات}
_of_[l=ar] { من }
_vol_[l=ar] {حجم}
_num_[l=ar] {رقم}

_textmonth00_[l=ar] {}
_textmonth01_[l=ar] {يناير}
_textmonth02_[l=ar] {فبراير}
_textmonth03_[l=ar] {مارس}
_textmonth04_[l=ar] {أبريل}
_textmonth05_[l=ar] {مايو}
_textmonth06_[l=ar] {حزيران}
_textmonth07_[l=ar] {يونيو}
_textmonth08_[l=ar] {أغسطس}
_textmonth09_[l=ar] {سبتمبر}
_textmonth10_[l=ar] {أكتوبر}
_textmonth11_[l=ar] {نوفمبر}
_textmonth12_[l=ar] {ديسمبر}

_Document_[l=ar] {الوثيقة}
_Section_[l=ar] {الجزء}
_Paragraph_[l=ar] {فقرة}

_magazines_[l=ar] {المجلات}

_nzdlpagefooter_[l=ar] {<p>_iconblankbar_
<p><a href="_gwcgi_">مشروع المكتبة الإلكترونية لنيوزيلندا</a>
<br><a href="http://www.cs.waikato.ac.nz/cs">مركز الإعلام الآلي مركز الإعلام الآلي</a>, 
<a href="http://www.waikato.ac.nz">جامعة وايكاتو</a>, نيوزيلندا}

#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "الموقع" ## top_nav_button ## chome ##
_httpiconchomeof_[l=ar] {_httpimg_/ar/chomeof.gif}
_httpiconchomeon_[l=ar] {_httpimg_/ar/chomeon.gif}
_widthchomex_[l=ar] {42}
_heightchomex_[l=ar] {20}

## " مساعدة" ## top_nav_button ## chelp ##
_httpiconchelpof_[l=ar] {_httpimg_/ar/chelpof.gif}
_httpiconchelpon_[l=ar] {_httpimg_/ar/chelpon.gif}
_widthchelpx_[l=ar] {50}
_heightchelpx_[l=ar] {20}

## "الخيارات" ## top_nav_button ## cpref ##
_httpiconcprefof_[l=ar] {_httpimg_/ar/cprefof.gif}
_httpiconcprefon_[l=ar] {_httpimg_/ar/cprefon.gif}
_widthcprefx_[l=ar] {58}
_heightcprefx_[l=ar] {20}

## "مساعدة" ## green_title ## h_help ##
_httpiconhhelp_[l=ar] {_httpimg_/ar/h\_help.gif}

## "المؤلفون أ-ي" ## nav_bar_button ## tauth ##
_httpicontauthgr_[l=ar] {_httpimg_/ar/tauthgr.gif}
_httpicontauthof_[l=ar] {_httpimg_/ar/tauthof.gif}
_httpicontauthon_[l=ar] {_httpimg_/ar/tauthon.gif}

## "السلاسل" ## nav_bar_button ## tser ##
_httpicontsergr_[l=ar] {_httpimg_/ar/tsergr.gif}
_httpicontserof_[l=ar] {_httpimg_/ar/tserof.gif}
_httpicontseron_[l=ar] {_httpimg_/ar/tseron.gif}

## "التواريخ" ## nav_bar_button ## tdate ##
_httpicontdategr_[l=ar] {_httpimg_/ar/tdategr.gif}
_httpicontdateof_[l=ar] {_httpimg_/ar/tdateof.gif}
_httpicontdateon_[l=ar] {_httpimg_/ar/tdateon.gif}

## "المواضيع" ## nav_bar_button ## tsubj ##
_httpicontsubjgr_[l=ar] {_httpimg_/ar/tsubjgr.gif}
_httpicontsubjon_[l=ar] {_httpimg_/ar/tsubjon.gif}
_httpicontsubjof_[l=ar] {_httpimg_/ar/tsubjof.gif}

## "المنظمة" ## nav_bar_button ## torg ##
_httpicontorggr_[l=ar] {_httpimg_/ar/torggr.gif}
_httpicontorgon_[l=ar] {_httpimg_/ar/torgon.gif}
_httpicontorgof_[l=ar] {_httpimg_/ar/torgof.gif}
_widthtorgx_[l=ar] {87}

## "كيف" ## nav_bar_button ## thow ##
_httpiconthowgr_[l=ar] {_httpimg_/ar/thowgr.gif}
_httpiconthowon_[l=ar] {_httpimg_/ar/thowon.gif}
_httpiconthowof_[l=ar] {_httpimg_/ar/thowof.gif}

## "المواد" ## nav_bar_button ## ttopic ##
_httpiconttopicgr_[l=ar] {_httpimg_/ar/ttopicgr.gif}
_httpiconttopicon_[l=ar] {_httpimg_/ar/ttopicon.gif}
_httpiconttopicof_[l=ar] {_httpimg_/ar/ttopicof.gif}

## "استعرض" ## nav_bar_button ## tbrwse ##
_httpicontbrwsegr_[l=ar] {_httpimg_/ar/tbrwsegr.gif}
_httpicontbrwseon_[l=ar] {_httpimg_/ar/tbrwseon.gif}
_httpicontbrwseof_[l=ar] {_httpimg_/ar/tbrwseof.gif}

## "ابحث" ## nav_bar_button ## tsrch ##
_httpicontsrchgr_[l=ar] {_httpimg_/ar/tsrchgr.gif}
_httpicontsrchof_[l=ar] {_httpimg_/ar/tsrchof.gif}
_httpicontsrchon_[l=ar] {_httpimg_/ar/tsrchon.gif}

## "العناوين أ-ي" ## nav_bar_button ## ttitl ##
_httpiconttitlgr_[l=ar] {_httpimg_/ar/ttitlgr.gif}
_httpiconttitlof_[l=ar] {_httpimg_/ar/ttitlof.gif}
_httpiconttitlon_[l=ar] {_httpimg_/ar/ttitlon.gif}

## "المساهمون" ## nav_bar_button ## tpeop ##
_httpicontpeopgr_[l=ar] {_httpimg_/ar/tpeopgr.gif}
_httpicontpeopof_[l=ar] {_httpimg_/ar/tpeopof.gif}
_httpicontpeopon_[l=ar] {_httpimg_/ar/tpeopon.gif}
_widthtpeopx_[l=ar] {87}



######################################################################
# 'about' page
package about
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textabcol_[l=ar] {حول هذه المجموعة}

_textsubcols1_[l=ar] {<p> المجموعة الكاملة تحتوي على _1_ جزء مجموعة:<blockquote>}

_textsubcols2_[l=ar] {</blockquote>
تستطيع أن تتحقق  (و تصحح) أي مجموعة أنت بصدد الإستعمال في صفحة الخيارات}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "حول" ## green_title ## h_about ##
_httpiconhabout_[l=ar] {_httpimg_/h\_about.gif}
_widthhabout_[l=ar] {200}
_heighthabout_[l=ar] {57}



######################################################################
# document package
package document
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textTitlepage_[l=ar] {_texticonhtitle_}
_textCreatorpage_[l=ar] {_texticonhauth_}
_textSubjectpage_[l=ar] {_texticonhsubj_}
_textSeriespage_[l=ar] {_texticonhser_}
_textDatepage_[l=ar] {_texticonhdate_}
_textHowtopage_[l=ar] {_texticonhhow_}
_textOrganizationpage_[l=ar] {_texticonhorg_}
_textBrowsepage_[l=ar] {_texticonhbrwse_}
_textPeoplepage_[l=ar] {_texticonhpeople_}

_texticonhtitle_[l=ar] {العناوين أ-ي}
_texticonhauth_[l=ar] {المؤلفون أ-ي}
_texticonhsubj_[l=ar] {المواضيع}
_texticonhser_[l=ar] {السلاسل}
_texticonhdate_[l=ar] {التواريخ}
_texticonhhow_[l=ar] {كيف}
_texticonhorg_[l=ar] {المنظمات}
_texticonhbrwse_[l=ar] {استعرض}
_texticonhpeople_[l=ar] {المساهمون أ-ي}

_texticonopenbookshelf_[l=ar] {أغلق هذا الجزء من المكتبة}
_texticonclosedbookshelf_[l=ar] {افتح هذا الجزء من المكتبة و شاهد محتواه}
_texticonopenbook_[l=ar] {أغلق هذا الكتاب}
_texticonclosedfolder_[l=ar] {افتح هذا الملف و استعرض محتواه}
_texticonclosedfolder2_[l=ar] { افتح الفصل:}
_texticonopenfolder_[l=ar] {أغلق هذا الملف}
_texticonopenfolder2_[l=ar] { أغلق الجزء:}
_texticonsmalltext_[l=ar] {شاهد هذا الجزء من النص}
_texticonsmalltext2_[l=ar] { شاهد النص: }
_texticonpointer_[l=ar] {الجزء الحالي}
_texticondetach_[l=ar] {افتح هذه الصفحة في نافذة جديدة}
_texticonhighlight_[l=ar] {أظهر كلمات البحث}
_texticonnohighlight_[l=ar] {لا تظهر كلمات البحث}
_texticoncontracttoc_[l=ar] {قوض الفهرس}
_texticonexpandtoc_[l=ar] {أبسط الفهرس}
_texticonexpandtext_[l=ar] {أعرض كل النص}
_texticoncontracttext_[l=ar] {لا تعرض إلا نص الجزء المختار}
_texticonwarning_[l=ar] {<b> إشعار: </b>}
_texticoncont_[l=ar] { واصل؟}

_textltwarning_[l=ar] {
<p><center>
<table cellspacing=0 cellpadding=0 width=_pagewidth_>
<tr valign=top><td>_iconwarning_ التوسع في النص هنا سيجلب للمستعرض كميات كبيرة من المعلومات للعرض _imagecont_
</td></tr></table></center>
}

_textgoto_[l=ar] {اذهب إلى الصفحة}
_textintro_[l=ar] { <i>( النص الإفتتاحي)</i>}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "العناوين أ-ي" ## green_title ## h_title ##
_httpiconhtitle_[l=ar] {_httpimg_/ar/h\_title.gif}

## "المؤلفون أ-ي" ## green_title ## h_auth ##
_httpiconhauth_[l=ar] {_httpimg_/ar/h\_auth.gif}

## "المواضيع" ## green_title ## h_subj ##
_httpiconhsubj_[l=ar] {_httpimg_/ar/h\_subj.gif}

## "السلاسل" ## green_title ## h_ser ##
_httpiconhser_[l=ar] {_httpimg_/ar/h\_ser.gif}

## "التواريخ" ## green_title ## h_date ##
_httpiconhdate_[l=ar] {_httpimg_/ar/h\_date.gif}

## "كيف" ## green_title ## h_how ##
_httpiconhhow_[l=ar] {_httpimg_/ar/h\_how.gif}

## "المواد" ## green_title ## h_topic ##
_httpiconhtopic_[l=ar] {_httpimg_/ar/h\_topic.gif}

## "المنظمة" ## green_title ## h_org ##
_httpiconhorg_[l=ar] {_httpimg_/ar/h\_org.gif}
_widthhorg_[l=ar] {200}

## "استعرض" ## green_title ## h_brwse ##
_httpiconhbrwse_[l=ar] {_httpimg_/ar/h\_brwse.gif}

## "المساهمون" ## green_title ## h_people ##
_httpiconhpeople_[l=ar] {_httpimg_/ar/h\_people.gif}

## "واصل؟" ## top_nav_button ## cont ##
_httpiconcontoff_[l=ar] {_httpimg_/ar/contoff.gif}
_httpiconconton_[l=ar] {_httpimg_/ar/conton.gif}
_widthcontx_[l=ar] {36}

## "توسع في النص" ## document_button ## eallt ## 
_httpiconealltof_[l=ar] {_httpimg_/ar/ealltof.gif}
_httpiconeallton_[l=ar] {_httpimg_/ar/eallton.gif}
_widthealltx_[l=ar] {86}

## "قوض المحتوى" ## document_button ## econc ##
_httpiconeconcof_[l=ar] {_httpimg_/ar/econcof.gif}
_httpiconeconcon_[l=ar] {_httpimg_/ar/econcon.gif}
_widtheconcx_[l=ar] {85}

## "أفصل" ## document_button ## edtch ##
_httpiconedtchof_[l=ar] {_httpimg_/ar/edtchof.gif}
_httpiconedtchon_[l=ar] {_httpimg_/ar/edtchon.gif}

## "توسع في المحتوى" ## document_button ## eexpc ##
_httpiconeexpcof_[l=ar] {_httpimg_/ar/eexpcof.gif}
_httpiconeexpcon_[l=ar] {_httpimg_/ar/eexpcon.gif}
_widtheexpcx_[l=ar] {101}

## "قوض النص" ## document_button ## etsec ##
_httpiconetsecof_[l=ar] {_httpimg_/ar/etsecof.gif}
_httpiconetsecon_[l=ar] {_httpimg_/ar/etsecon.gif}

## "الإظهار" ## document_button ## ehl ##
_httpiconehlof_[l=ar] {_httpimg_/ar/ehlof.gif}
_httpiconehlon_[l=ar] {_httpimg_/ar/ehlon.gif}

## "عدم الإظهار" ## document_button ## enhl ##
_httpiconenhlof_[l=ar] {_httpimg_/ar/enhlof.gif}
_httpiconenhlon_[l=ar] {_httpimg_/ar/enhlon.gif}


######################################################################
# 'search' page
package query
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# this if statement produces the text 'results n1 - nn for query: querystring' or 
# 'No matches for query: querystring', depending on whether or not there were
# any matches
_textquerytitle_[l=ar] {_If_(_thislast_, النتائج _thisfirst_ - _thislast_ للطلب:  _cgiargq_, لا يوجد مقابل للطلب: _cgiargq_)}
_textnoquerytitle_[l=ar] {صفحة البحث}

_texticonthispage_[l=ar] {ابحث}
_textsome_[l=ar] {_If_(_cgiargb_, مصنف, بعض)}
_textall_[l=ar] {_If_(_cgiargb_, بوليان, كل)}
_texticonqueryresultsbar_[l=ar] {}
_textfreqmsg1_[l=ar] { عدد الكلمات: }
_textpostprocess_[l=ar] {_If_(_quotedquery_,<br><i> بعد التحليل لايحاد _quotedquery_</i>
)}

_textmorethan_[l=ar] { أكثر من}
_textapprox_[l=ar] {حول}
_textnodocs_[l=ar] { لا يوجد ملف يقابل الطلب. }
_text1doc_[l=ar] {1 ملف يطابق الطلب.}
_textlotsdocs_[l=ar] { ملفات يطابقون الطلب.}
_textmatches_[l=ar] {المطابقات}
_textbeginsearch_[l=ar] {ابدأ البحث}

_textsimplesearch_[l=ar] { ابحث عن _If_(_hselection_, _hselection_)_If_(_jselection_,_textjselect_)_If_(_gselection_, في _gselection_ المستوى)_If_(_nselection_, في _nselection_ اللغة) 
التي تحتوي على _querytypeselection_ الكلمات }

_textadvancedsearch_[l=ar] { ابحُث _If_(_hselection_, _hselection_, _defaultindextext_)_If_(_jselection_,_textjselect_)_If_(_gselection_, في_gselection_ المستوى)_If_(_nselection_, في _nselection_ اللغة) 
التي تحتوي على _querytypeselection_ الكلمات }

_textjselect_[l=ar] {_If_(_hselection_, من) _jselection_}

_textstemon_[l=ar] { (تجاهل نهاية الكلمات)}
_textclearhistory_[l=ar] {افرغ المقيد}
_textexpand_[l=ar] {توسع}
_textcontract_[l=ar] {قوض}
_textsearchhistory_[l=ar] {ابحث في المقيد}
_textquery_[l=ar] {الطلب}
_textresults_[l=ar] {النتائج}
_textview_[l=ar] {شاهد}
_textnohistory_[l=ar] {البحث في المقيد ليس متوفر}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "ابحث" ## green_title ## h_search ##
_httpiconhsearch_[l=ar] {_httpimg_/ar/h\_search.gif}

## "النتائج" ## green_bar_left_aligned ## qryresb ##
_httpiconqryresb_[l=ar] {_httpimg_/ar/qryresb.gif}


## "اعرض" ## hand_made ##
_httpicondisplay_[l=ar] {_httpimg_/ar/display.gif}


######################################################################
# 'preferences' page
package preferences
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsearchprefs_[l=ar] {الخيارات في البحث}
_textcollectionprefs_[l=ar] {الخيارات في المجموعة}
_textpresentationprefs_[l=ar] { الخيارات في التقديم}
_textpreferences_[l=ar] {الخيارات}
_textstem_[l=ar] {تجاهل نهاية الكلمات}
_textnostem_[l=ar] { كل الكلمة يجب أن تطابق }
_textprefop_[l=ar] { أعيد حتى _maxdocoption_ مطابق وكل صفحة تحتوي على _hitsperpageoption_ مطابق.}
_textextlink_[l=ar] { الحصول على صفحات الإنترنت الخارجية}
_textintlink_[l=ar] { مصدر الملفات تحصل عليها من}
_textlanguage_[l=ar] { لغة الواجهة:}
_textencoding_[l=ar] { رموز التخزين:}
_textformat_[l=ar] { صيغة الواجهة:}
_textall_[l=ar] {كل}
_textsimplemode_[l=ar] {طريقة الطلب البسيط}
_textadvancedmode_[l=ar] { طريقة الطلب المتقدمة (يمكن استعمال البحث البوليان المستعمل |, &, ! و القوسين)}
_textlinkinterm_[l=ar] {عبر صفحة وسطى}
_textlinkdirect_[l=ar] {اذهب إلى هناك}
_textdigitlib_[l=ar] {المكتبة الإلكترونية}
_textweb_[l=ar] {الإنترنت}
_textlangeng_[l=ar] {إنكليزي}
_textlanggerman_[l=ar] {ألماني}
_textlangmaori_[l=ar] {M_amn_ori}
_textlangchinese_[l=ar] {صيني}
_textgraphical_[l=ar] {تخطيطي}
_texttextual_[l=ar] {النص}
_textcollectionoption_[l=ar] {<p>
الفصول للانضمام:
<br>}
_textfcoption_[l=ar] {تحتوي على قضيب الاستعراض في أعلى صفحات النص}
_texthloption_[l=ar] {إظهار كلمات البحث في النص}
_texthistorydisplay_[l=ar] {عرض تاريخ البحث}


#------------------------------------------------------------
# icons
#------------------------------------------------------------

## "الخيارات" ## green_title ## h_pref ##
_httpiconhpref_[l=ar] {_httpimg_/ar/h\_pref.gif}


######################################################################
# 'delete search history' page
package delhistory
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdsh_[l=ar] {Delete Search History}

_textselectdelete_[l=ar] {<a href="_httpclearhistory_&hdh=1"> امحي كل السجلات </a>أو انتقي السجلات <select name=hmode><option value=save> لعدم المحي <option value=delete selected> امحي </select><br> السجلات بإدخال الأرقام المناسبة في العلبة,,<br> أو بالضغط على العلبة المقابلة لكل سجل.<br> الأرقام المقبولة هي 1, 2, 3, ... الخ }

_textclearselected_[l=ar] {المحي مختار}
_textselect_[l=ar] {اختار}
