#!/usr/bin/perl -w

###########################################################################
#
# classinfo.pl -- provide information about classifiers
#
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the 
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################


BEGIN {
    die "GSDLHOME not set\n" unless defined $ENV{'GSDLHOME'};
    die "GSDLOS not set\n" unless defined $ENV{'GSDLOS'};
    unshift (@INC, "$ENV{'GSDLHOME'}/perllib");
    unshift (@INC, "$ENV{'GSDLHOME'}/perllib/classify");
}

use strict;
use classify;
use util;
use parsargv;

sub print_usage {
    print STDERR "\n";
    print STDERR "classinfo.pl: Prints information about a classifier.\n\n";
    print STDERR "  usage: $0 [options] classifier\n\n";
    print STDERR "  options:\n";
    print STDERR "   -collect collection-name  Giving a collection name will make\n";
    print STDERR "         classinfo.pl look in collect/collection-name/perllib/classify\n";
    print STDERR "         first. If it doesn't find it there it will look in the general\n";
    print STDERR "         perllib/classify directory.\n\n";
}

&main ();

sub main {
    my $collect = "";

    # Parse command line
    if (!parsargv::parse(\@ARGV, 'collect.*/', \$collect)) {
	&print_usage();
	die "\n";
    }

    # Get classifier
    my $classifier = shift (@ARGV);
    if (!defined $classifier || $classifier eq "") {
	print STDERR "You must provide a classifier name\n";
	&print_usage();
	die "\n";
    }

    # make sure the classifier is loaded from the correct location - a hack.
    if ($collect ne "") {
	$ENV{'GSDLCOLLECTDIR'} = &util::filename_cat ($ENV{'GSDLHOME'}, "collect", $collect);
    } else {
	$ENV{'GSDLCOLLECTDIR'} = $ENV{'GSDLHOME'};
    }

    my $classinfo = &classify::load_classifiers ([[$classifier]]);
    my $classobj = shift @$classinfo;

    print STDERR "
$classifier info:

Options may be passed to any classifier by including them in your collect.cfg
configuration file.

Classifiers may take two types of options:

General options are defined within the base class (BasClas.pm) and are
inherited by any classifier that has been correctly derived from BasClas.

Specific options are defined within the classifier itself and are available
only to this particular classifier.

$classifier takes the following specific options:
";
    $classobj->print_usage();

    print STDERR "$classifier takes the following general options
";
    &BasClas::print_general_usage($classifier);

}




