#!/bin/sh

##  Install.sh -- Install Greenstone

cmd_cp="cp"
cmd_cpr="cp -r"
cmd_chmod="chmod"
cmd_mkdir="mkdir -p"
cmd_ln="ln -s"
cmd_mv="mv"
cmd_rm="rm -i"
cmd_rmr="rm -r"

thisdir=`pwd`
cd ..
cd_dir=`pwd`
cd "$thisdir"

# script must be run from within cdrom/unix directory
if [ ! -f "${thisdir}/Install.sh" ]; then
    echo "Install.sh must be run from the directory in which it resides"
    echo "Greenstone was not installed"
    exit 1
fi

# check that various important directories are on the cd
if [ ! -d "${cd_dir}/gsdl" ]; then
    echo
    echo "ERROR: Could not locate ${cd_dir}/gsdl"
     echo "Greenstone was not installed"
    exit 1
fi
if [ ! -d "${cd_dir}/Unix/bin/linux" ]; then
    echo
    echo "ERROR: Could not locate ${cd_dir}/Unix/bin/linux"
    echo "Greenstone was not installed"
    exit 1
fi


# install to /usr/local by default if user is "root", otherwise
# default to users home directory
gsdlos=`uname | tr A-Z a-z`
if [ "$gsdlos" = "linux" ]; then
    logname=`whoami`
else
    logname=""
fi
if [ "$logname" = "" ]; then
    logname=`logname`
fi
gsdlhome="/home/${logname}"
if [ "$logname" = "root" ]; then 
    gsdlhome="/usr/local"
fi

# get gsdlhome
echo
echo "This script will install Greenstone on your system. You may want"
echo "to skim through the Install.pdf document that resides in the docs"
echo "directory of this cd-rom before continuing with the installation."
echo
echo "Note that when prompted for input, hitting \"enter\" will select"
echo "the default (given in square brackets [] at the end of each question)."
echo
echo "Note also that Install.sh prints out information on any commands"
echo "it runs on your system in the form \"--> Install.sh: [command]\"."
echo
echo "It is assumed throughout this installation procedure that you"
echo "have a webserver installed on your system."
echo
echo "Continue? [y]"
printf "%s" "> "
read ans
if [ "$ans" != "" ] && [ "$ans" != "y" ]; then
    echo "Greenstone was not installed"
    exit 0
fi

echo
echo "Enter directory to install Greenstone into. A gsdl directory"
echo "will be created in this directory. [${gsdlhome}]" 
printf "%s" "> "
read ans
if [ "$ans" != "" ]; then
    gsdlhome="$ans"
fi

if [ ! -d "$gsdlhome" ]; then
    echo "Warning: The ${gsdlhome} directory does not exist."
    echo "Create it? [y]"
    printf "%s" "> "
    read ans
    if [ "$ans" = "" ]; then
	ans="y"
    fi
    if [ "$ans" = "y" ]; then
	echo "--> Install.sh: [$cmd_mkdir \"$gsdlhome\"]"
	$cmd_mkdir "$gsdlhome"
	if [ ! -d "$gsdlhome" ]; then
	    echo "ERROR: failed to create $gsdlhome directory"
	    echo "Greenstone was not installed"
	    exit 1
	fi
    else
	echo "Greenstone was not installed"
	exit 0
    fi
fi;


# from now on $gsdlhome includes the "/gsdl"
gsdlhome="${gsdlhome}/gsdl"

echo "--> Install.sh: [$cmd_mkdir \"${gsdlhome}\"]"
$cmd_mkdir "$gsdlhome"
if [ ! -d "$gsdlhome" ]; then
    echo "ERROR: failed to create $gsdlhome directory"
    echo "Greenstone was not installed"
    exit 1
fi
# set permissions on gsdlhome directory (not that we should need to)
echo "--> Install.sh: [$cmd_chmod u+rwx \"${gsdlhome}\"]"
$cmd_chmod u+rwx "$gsdlhome"


# create initial uninstall.sh
cd "$gsdlhome"
echo "#!/bin/sh" > uninstall.sh
echo "" >> uninstall.sh
echo "echo \"remove ${gsdlhome} directory? [y]\"" >> uninstall.sh
echo "read ans" >> uninstall.sh
echo "if [ \"\$ans\" = \"\" ] || [ \"\$ans\" = \"y\" ]; then" >> uninstall.sh
echo "   $cmd_rmr \"$gsdlhome\"" >> uninstall.sh
echo "fi" >> uninstall.sh
$cmd_chmod u+x uninstall.sh
cd "$thisdir"

echo
echo "If this installation fails or is cancelled, run the uninstall"
echo "script (${gsdlhome}/uninstall.sh) to clean up the partial"
echo "installation."
echo "Continue? [y]"
printf "%s" "> "
read ans
if [ "$ans" != "" ] && [ "$ans" != "y" ]; then
    echo "Greenstone was not installed"
    exit 0
fi

echo
echo "Installing Greenstone directory structure to ${gsdlhome}"
# copy gsdl directory across
echo "--> Install.sh: [$cmd_cpr \"${cd_dir}/gsdl/\"* \"$gsdlhome\"]"
$cmd_cpr "${cd_dir}/gsdl/"* "$gsdlhome"

# copy setup shell scripts across too
echo "--> Install.sh: [$cmd_cp \"${cd_dir}/src/Unix/setup.\"* \"$gsdlhome\"]"
$cmd_cp "${cd_dir}/src/Unix/setup."* "$gsdlhome"

# create the tmp directory
echo "--> Install.sh: [$cmd_mkdir \"$gsdlhome/tmp\"]"
$cmd_mkdir "$gsdlhome/tmp"

# make collect directory writable so we can install collections
echo "--> Install.sh: [$cmd_chmod u+rwx \"$gsdlhome/collect\"]"
$cmd_chmod u+rwx "$gsdlhome/collect"

# which collections do we want
cd "${cd_dir}/collect"
files=*
first="yes"
for file in $files
do
    if [ "$file" != "*" ] && [ "$file" != "dlpeople" ]; then
	if [ "$first" = "yes" ]; then
	    echo
	    echo "The Greenstone demonstration collection has been installed. Would you"
	    echo "like to install any other collections from the installation cd-rom? [y]"
	    read ans
	    if [ "$ans" != "" ] && [ "$ans" != "y" ]; then
		break
	    fi
	    first="no"
	fi

	echo
	echo "Install the $file collection? [y]"
	printf "%s" "> "
	read ans
	if [ "$ans" = "" ] || [ "$ans" = "y" ]; then
	    echo "--> Install.sh: [$cmd_cpr \"${cd_dir}/collect/$file\" \"${gsdlhome}/collect\"]"
	    $cmd_cpr "${cd_dir}/collect/$file" "${gsdlhome}/collect"
	fi
    fi
done

# set permissions
echo
echo "Setting permissions ..."
echo "--> Install.sh: [$cmd_chmod -R u+rw \"$gsdlhome\"]"
$cmd_chmod -R u+rw "$gsdlhome"
# gsdl/etc needs to be globally writable
echo "--> Install.sh: [$cmd_chmod -R a+w \"$gsdlhome/etc\"]"
$cmd_chmod -R a+w "$gsdlhome/etc"

# should gsdl/collect and gsdl/tmp be globally writable?
echo
echo "In order for end-user collection building to be enabled the"
echo "Greenstone cgi program must be able to write to the"
echo "${gsdlhome}/collect and ${gsdlhome}/tmp directories."
echo "On most systems this means they must be globally writable."
echo "Make these directories globally writable? [y]"
printf "%s" "> "
read ans
if [ "$ans" = "" ] || [ "$ans" = "y" ]; then
    echo "--> Install.sh: [$cmd_chmod -R a+w \"$gsdlhome/collect\"]"
    $cmd_chmod -R a+w "$gsdlhome/collect"
    echo "--> Install.sh: [$cmd_chmod -R a+w \"$gsdlhome/tmp\"]"
    $cmd_chmod -R a+w "$gsdlhome/tmp"
fi

# binaries or source code?
compile="yes"
if [ "$gsdlos" = "linux" ]; then
    echo
    echo "You may either install pre-compiled, statically linked linux [b]inaries"
    echo "or install and [c]ompile the Greenstone source code"

    found=no
    while [ "$found" = "no" ]; do
	echo "Enter \"[b]\" or \"c\""
	printf "%s" "> "
	read ans
	if [ "$ans" = "" ] || [ "$ans" = "b" ]; then
	    compile="no"
	    # install binaries
	    echo
	    echo "Installing linux binaries"
	    echo "--> Install.sh: [$cmd_cpr \"${cd_dir}/Unix/bin/linux\" \"${gsdlhome}/bin\" ]"
	    $cmd_cpr "${cd_dir}/Unix/bin/linux" "${gsdlhome}/bin"
	    echo "--> Install.sh: [$cmd_chmod a+x \"${gsdlhome}/bin/linux/\"*]"
	    $cmd_chmod a+x "${gsdlhome}/bin/linux/"*
	    echo "--> Install.sh: [$cmd_chmod -R u+rw \"${gsdlhome}/bin/linux\"]"
	    $cmd_chmod -R u+rw "${gsdlhome}/bin/linux"

	    # move library executable to cgi-bin
	    echo "--> Install.sh: [$cmd_mv \"${gsdlhome}/bin/linux/library\" \"${gsdlhome}/cgi-bin\"]"
	    $cmd_mv "${gsdlhome}/bin/linux/library" "${gsdlhome}/cgi-bin"
	    
	    found="yes"
	elif [ "$ans" = "c" ]; then
	    found="yes"
	fi
    done
fi

if [ "$compile" = "yes" ]; then
    # install source
    echo
    echo "Installing source code"
    echo "--> Install.sh [$cmd_cpr \"${cd_dir}/src/lib\" \"$gsdlhome\"]"
    $cmd_cpr "${cd_dir}/src/lib" "$gsdlhome"
    echo "--> Install.sh [$cmd_cpr \"${cd_dir}/src/packages\" \"$gsdlhome\"]"
    $cmd_cpr "${cd_dir}/src/packages" "$gsdlhome"
    echo "--> Install.sh [$cmd_cpr \"${cd_dir}/src/src\" \"$gsdlhome\"]"
    $cmd_cpr "${cd_dir}/src/src" "$gsdlhome"
    echo "--> Install.sh [$cmd_cpr \"${cd_dir}/src/Unix/\"* \"$gsdlhome\"]"
    $cmd_cpr "${cd_dir}/src/Unix/"* "$gsdlhome"
    echo "--> Install.sh: [$cmd_chmod -R u+rw \"$gsdlhome\"]"
    $cmd_chmod -R u+rw "$gsdlhome"
    echo "--> Install.sh: [$cmd_chmod a+x \"${gsdlhome}/configure\"]"
    $cmd_chmod a+x "${gsdlhome}/configure"
    echo "--> Install.sh: [$cmd_chmod a+x \"${gsdlhome}/packages/yaz/configure\"]"
    $cmd_chmod a+x "${gsdlhome}/packages/yaz/configure"

    # compile it
    echo "--> Install.sh: [cd $gsdlhome]"
    cd "$gsdlhome"
    echo "configuring ..."
    echo
    echo "--> Install.sh: [./configure]"
    ./configure
    echo "compiling ..."
    echo
    echo "--> Install.sh: [make]"
    make
    echo "installing ..."
    echo
    echo "--> Install.sh: [make install]"
    make install
    echo "--> Install.sh: [cd $thisdir]"
    cd "$thisdir"

    # check that things compiled ok
    if [ ! -f "${gsdlhome}/cgi-bin/library" ]; then
	echo 
	echo "ERROR: Compilation failed"
	echo "Greenstone was not installed successfully"
	echo "Run the uninstall script (${gsdlhome}/uninstall.sh)"
	echo "to clean up the partial installation."
	exit 1
    fi
fi


# try to find out hostname
if [ "$gsdlos" = "linux" ]; then
    hostname=`hostname -f`
    if [ "$hostname" = "" ]; then
	hostname=`hostname -i`
    fi
fi
if [ "$hostname" = "" ]; then
    hostname=`hostname`
fi
if [ "$hostname" = "" ]; then
    hostname="your-computer-name"
fi


# get cgi-bin directory
echo
echo
echo "Greenstone needs a valid cgi executable directory (normally called"
echo "cgi-bin on unix systems) from which to run."
echo "This may be either:"
echo " 1. The default Greenstone cgi-bin directory (${gsdlhome}/cgi-bin)."
echo "    If you use the Greenstone default you will need to configure"
echo "    your webserver to treat this directory as a cgi executable"
echo "    directory. For the Apache webserver you use the ScriptAlias"
echo "    directive to do this (details of how to configure your webserver"
echo "    will be displayed at the end of this installation procedure)."
if [ "$logname" != "root" ]; then
echo "    Note that you will probably need help from your system"
echo "    administrator to reconfigure your webserver."
fi
echo " 2. An existing cgi-bin directory. Normally a cgi-bin directory"
echo "    is created when your webserver is installed. Typically, this"
echo "    might be /home/httpd/cgi-bin, or /usr/local/apache/cgi-bin, or"
echo "    /var/lib/apache/cgi-bin."
if [ "$logname" != "root" ]; then
    echo "    Many systems also allow individual users to have their own"
    echo "    cgi-bin in /home/username/public_html/cgi-bin."
fi 
found=no
remind_cgi="no"
remind_cgi_nomove="no"
while [ "$found" = "no" ]; do
    echo "Enter \"[1]\" or \"2\""
    printf "%s" "> "
    read ans
    if [ "$ans" = "" ] || [ "$ans" = "1" ]; then
	found="option1"
	cgi_bin="${gsdlhome}/cgi-bin"
	# default gsdl cgi-bin, do nothing
	echo
	echo "Don't forget to configure your webserver to treat $cgi_bin"
	echo "as a cgi executable directory. Don't worry, you'll be"
	echo "reminded of this again at the end of the installation"
	echo "procedure"
	remind_cgi="yes"
    elif [ "$ans" = "2" ]; then
	found="option2"
	# external cgi-bin
	echo 
	echo "Enter existing cgi executable directory [/usr/local/apache/cgi-bin]"
	printf "%s" "> "
	read ans
	if [ "$ans" = "" ]; then
	    cgi_bin="/usr/local/apache/cgi-bin"
	else 
	    cgi_bin="$ans"
	fi
	if [ ! -d "$cgi_bin" ]; then
	    echo "Warning: The ${cgi_bin} directory does not exist."
	    echo "Create it? [y]"
	    printf "%s" "> "
	    read ans
	    if [ "$ans" = "" ] || [ "$ans" = "y" ]; then
		echo "--> Install.sh: [$cmd_mkdir \"$cgi_bin\"]"
		$cmd_mkdir "$cgi_bin"
		if [ -d "$cgi_bin" ]; then
		    echo "Don't forget to configure your webserver to treat $cgi_bin"
		    echo "as a cgi executable directory. Don't worry, you'll be"
		    echo "reminded of this again at the end of the installation"
		    echo "procedure"
		    remind_cgi="yes"
		else
		    echo "ERROR: failed to create $cgi_bin directory"
		    echo "Greenstone installation failed."
		    echo "Run the uninstall script (${gsdlhome}/uninstall.sh)"
		    echo "to clean up the partial installation."
		    exit 1
		fi
	    fi
	fi

	if [ ! -w "$cgi_bin" ]; then
	    echo
	    echo "Unable to write to $cgi_bin directory. You will need"
	    echo "to copy the contents of ${gsdlhome}/cgi-bin"
	    echo "to $cgi_bin after this installation is completed."
	    echo "You'll be reminded of this again at the end of the"
	    echo "installation procedure."
	    remind_cgi_nomove="yes"
	else
	    # install cgi-bin stuff (update the uninstall script first)
	    cd "$gsdlhome"
	    echo "#!/bin/sh" > uninstall.sh
	    echo "" >> uninstall.sh
	    echo "$cmd_rm \"${cgi_bin}/gsdlsite.cfg\"" >> uninstall.sh
	    echo "$cmd_rm \"${cgi_bin}/library\"" >> uninstall.sh
	    echo "echo \"remove ${gsdlhome} directory? [y]\"" >> uninstall.sh
	    echo "read ans" >> uninstall.sh
	    echo "if [ \"\$ans\" = \"\" ] || [ \"\$ans\" = \"y\" ]; then" >> uninstall.sh
	    echo "   $cmd_rmr \"$gsdlhome\"" >> uninstall.sh
	    echo "fi" >> uninstall.sh
	    $cmd_chmod u+x uninstall.sh
	    cd "$thisdir"

	    echo
	    echo "Installing Greenstone cgi programs in $cgi_bin"
	    echo "--> Install.sh: [$cmd_mv \"${gsdlhome}/cgi-bin/gsdlsite.cfg\" \"$cgi_bin\"]"
	    $cmd_mv "${gsdlhome}/cgi-bin/gsdlsite.cfg" "$cgi_bin"
	    echo "--> Install.sh: [$cmd_mv \"${gsdlhome}/cgi-bin/library\" \"$cgi_bin\"]"
	    $cmd_mv "${gsdlhome}/cgi-bin/library" "$cgi_bin"
	fi
    fi
done

# web address of cgi-bin
web_cgi="http://${hostname}/cgi-bin"
if [ "$found" = "option1" ]; then
    web_cgi="http://${hostname}/gsdl/cgi-bin"
fi
echo
echo "Please enter the web address of the $cgi_bin"
echo "directory. Typically this might be http://localhost/cgi-bin,"
echo "or http://127.0.0.1/cgi-bin, or http://your-computer-name/cgi-bin,"
echo "or http://nnn.nnn.nnn.nn/cgi-bin. [$web_cgi]"
printf "%s" "> "
read ans
if [ "$ans" != "" ]; then
    web_cgi="$ans"
fi

# get public_html directory
echo
echo
echo "In order for Greenstone to run, the $gsdlhome"
echo "directory and all it contains must be accessible from the web."
echo "To make this happen you may either:"
echo " 1. Configure your webserver so that $gsdlhome"
echo "    is itself accessible from the web."
if [ "$logname" != "root" ]; then
echo "    Note that you will probably need help from your system"
echo "    administrator to reconfigure your webserver."
fi
echo " 2. Provide an existing web accessible directory from which"
echo "    a symbolic link will be made to $gsdlhome."
echo "    When your server was installed a web accessible directory"
echo "    will have been created (the Apache webserver uses the"
echo "    DocumentRoot directive to define this directory). Typically"
echo "    this directory might be /home/httpd/html, or /usr/local/apache/htdocs,"
echo "    or /var/lib/apache/htdocs."
if [ "$logname" != "root" ]; then
    echo "    Many systems also allow individual users to have their own"
    echo "    web accessible directory in /home/username/public_html."
fi 
echo "    Note that your web server will need to be configured to allow"
echo "    symbolic links from within this directory. For the Apache"
echo "    server that means this directory must be configured with"
echo "    the SymLinksIfOwnerMatch or FollowSymLinks option (most Apache"
echo "    installations are configured this way by default)."
found="no"
remind_ph="no"
remind_ph_nolink="no"
while [ "$found" = "no" ]; do
    echo "Enter \"[1]\" or \"2\""
    printf "%s" "> "
    read ans
    if [ "$ans" = "" ] || [ "$ans" = "1" ]; then
	found="yes"
	public_html="$gsdlhome"
	# no link
	echo
	echo "Don't forget to configure your webserver to make $gsdlhome"
	echo "accessible from the web. You'll be reminded of this again"
	echo "at the end of this installation procedure."
	remind_ph="yes"
    elif [ "$ans" = "2" ]; then
	found="yes"
	# external public_html
	echo 
	public_html="/home/${logname}/public_html"
	if [ "$logname" = "root" ]; then
	    public_html="/usr/local/apache/htdocs"
	fi
	echo "Enter directory that is also accessible from the web [${public_html}]"
	printf "%s" "> "
	read ans
	if [ "$ans" != "" ]; then
	    public_html="$ans"
	fi
	# create link to gsdl (and update uninstall.sh)
	if [ -w "$public_html" ]; then
	    cd "$gsdlhome"
	    echo "#!/bin/sh" > uninstall.sh
	    echo "" >> uninstall.sh
	    echo "$cmd_rm \"$public_html/gsdl\"" >> uninstall.sh
	    echo "$cmd_rm \"${cgi_bin}/gsdlsite.cfg\"" >> uninstall.sh
	    echo "$cmd_rm \"${cgi_bin}/library\"" >> uninstall.sh
	    echo "echo \"remove ${gsdlhome} directory? [y]\"" >> uninstall.sh
	    echo "read ans" >> uninstall.sh
	    echo "if [ \"\$ans\" = \"\" ] || [ \"\$ans\" = \"y\" ]; then" >> uninstall.sh
	    echo "   $cmd_rmr \"$gsdlhome\"" >> uninstall.sh
	    echo "fi" >> uninstall.sh
	    $cmd_chmod u+x uninstall.sh
	    cd "$thisdir"

	    echo "--> Install.sh: [cd \"$public_html\"]"
	    cd "$public_html"
	    echo "--> Install.sh: [$cmd_ln \"$gsdlhome\" gsdl]"
	    $cmd_ln "$gsdlhome" gsdl
	    echo "--> Install.sh: [cd \"$thisdir\"]"
	    cd "$thisdir"
	else
	    echo
	    echo "Unable to write to $public_html directory. You will need"
	    echo "to create a link called gsdl from $public_html to"
	    echo "$gsdlhome after this installation is completed. You'll be"
	    echo "reminded of this again at the end of the installation"
	    echo "procedure."
	    old_ph=$public_html
	    remind_ph_nolink="yes"
	fi
	public_html="${public_html}/gsdl"
    fi
done


# get httpprefix
echo
echo "Enter the web address of the $public_html directory."
echo "This may be a relative url (e.g. \"/gsdl\") or a"
echo "complete url (e.g. \"http://${hostname}/gsdl\") [/gsdl]"
printf "%s" ">" 
httpprefix="/gsdl"
read ans
if [ "$ans" != "" ]; then
    httpprefix="$ans"
fi

# get initial password
echo
echo "In order to use end-user collection building or to access certain"
echo "parts of the administration pages you must have a password."
echo "A user with the username \"admin\" will be created for you with"
echo "the password you provide (i.e. to enter any pages requiring user"
echo "authentication enter the \"admin\" username and the password you"
echo "set here).\n";
pw=`${gsdlhome}/bin/${gsdlos}/getpw`
tmp="[admin]
<comment>
<enabled>true
<groups>administrator,colbuilder
<password>${pw}
<username>admin
----------------------------------------------------------------------"
echo "$tmp" | ${gsdlhome}/bin/${gsdlos}/txt2db "${gsdlhome}/etc/users.db"

# edit gsdlsite.cfg
cd "$cgi_bin"
sed "s|\(gsdlhome  *\)[^ ]*|\1${gsdlhome}|" gsdlsite.cfg > tmp123.txt && $cmd_mv tmp123.txt gsdlsite.cfg
sed "s|#*\(httpprefix  *\)[^ ]*|\1${httpprefix}|" gsdlsite.cfg > tmp123.txt && $cmd_mv tmp123.txt gsdlsite.cfg
sed "s|\(httpimg  *\)[^ ]*|\1${httpprefix}/images|" gsdlsite.cfg > tmp123.txt && $cmd_mv tmp123.txt gsdlsite.cfg

echo
echo
echo "Greenstone installation completed successfully."
if [ "$remind_cgi" = "yes" ]; then
    echo "  * Don't forget to configure your webserver to treat"
    echo "    $cgi_bin as a cgi executable directory."

    apache_web_cgi=`echo "$web_cgi" | sed "s|[^/]*//[^/]*||" | sed "s|/*$|/|"`
    cgi_bin_slash=`echo "$cgi_bin" | sed "s|/*$|/|"`
    cgi_bin_noslash=`echo "$cgi_bin" | sed "s|/*$||"`

    echo "    For the Apache webserver this means adding the following"
    echo "    ScriptAlias directive to your httpd.conf configuration file."
    echo
    echo "     ScriptAlias ${apache_web_cgi} \"${cgi_bin_slash}\""
    echo "     <Directory \"${cgi_bin_noslash}\">"
    echo "         AllowOverride None"
    echo "         Options None"
    echo "         Order allow,deny"
    echo "         Allow from all"
    echo "     </Directory>"
    echo
fi
if [ "$remind_cgi_nomove" = "yes" ]; then
    echo "  * Don't forget to move the contents of ${gsdlhome}/cgi-bin"
    echo "    to $cgi_bin"
    echo
fi
if [ "$remind_ph" = "yes" ]; then
    echo "  * Don't forget to configure your webserver to treat"
    echo "    $gsdlhome as a web accessible directory."
    
    apache_httpprefix=`echo "$httpprefix" | sed "s|[^/]*//[^/]*||" | sed "s|/*$|/|"`
    public_html_slash=`echo "$public_html" | sed "s|/*$|/|"`
    public_html_noslash=`echo "$public_html" | sed "s|/*$||"`
    
    echo "    For the Apache webserver this means adding the following"
    echo "    Alias directive to your httpd.conf configuration file."
    echo
    echo "     Alias ${apache_httpprefix} \"${public_html_slash}\""
    echo "     <Directory \"${public_html_noslash}\">"
    echo "         Options Indexes MultiViews FollowSymLinks"
    echo "         AllowOverride None"
    echo "         Order allow,deny"
    echo "         Allow from all"
    echo "     </Directory>"
    echo
fi
if [ "$remind_ph_nolink" = "yes" ]; then
    echo "  * Don't forget to create a link called gsdl from $old_ph"
    echo "    to ${gsdlhome}."
    echo
fi
echo "You may remove Greenstone from your system at any time by running"
echo "the ${gsdlhome}/uninstall.sh script."
echo "Access Greenstone by pointing a web browser at"
echo "   ${web_cgi}/library"
echo

exit 0
