/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.util.Enumeration;
import java.util.Vector;
import jaws.corePackage.Attribute;
import jaws.corePackage.FastVector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.Filter;

public class NominalToNumericFilter
extends Filter
implements OptionHandler {
    private int theClassIndex = -1;
    private double[][] theAvgClassValues = null;
    private int[][] theIndices = null;

    public boolean inputFormat(Instances instances) throws Exception {
        this.m_InputFormat = new Instances(instances, 0);
        if (this.theClassIndex > -1) {
            this.m_InputFormat.setClassIndex(this.theClassIndex);
        } else if (this.m_InputFormat.classIndex() < 0) {
            this.m_InputFormat.setClassIndex(this.m_InputFormat.numAttributes() - 1);
        }
        this.b_NewBatch = true;
        this.setOutputFormat();
        this.theAvgClassValues = null;
        this.theIndices = null;
        return this.m_InputFormat.classAttribute().isNominal();
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        if (this.theAvgClassValues != null || this.m_InputFormat.classAttribute().isNominal()) {
            this.convertInstance(instance);
            return true;
        }
        this.m_InputFormat.add(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.theAvgClassValues == null && this.m_InputFormat.classAttribute().isNumeric()) {
            this.computeAverageClassValues();
            this.setOutputFormat();
            int n = 0;
            while (n < this.m_InputFormat.numInstances()) {
                Instance instance = this.m_InputFormat.instance(n);
                this.convertInstance(instance);
                ++n;
            }
            this.m_InputFormat = new Instances(this.m_InputFormat, 0);
        }
        this.b_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tSets the class index.", "C", 1, "-C <col>"));
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            if (string.toLowerCase().equals("last")) {
                this.setClassIndex(0);
            } else if (string.toLowerCase().equals("first")) {
                this.setClassIndex(1);
            } else {
                this.setClassIndex(Integer.parseInt(string));
            }
        }
        if (this.m_InputFormat != null) {
            this.inputFormat(this.m_InputFormat);
        }
    }

    public int getClassIndex() {
        return this.theClassIndex + 1;
    }

    public void setClassIndex(int n) {
        this.theClassIndex = n - 1;
    }

    private void computeAverageClassValues() throws Exception {
        this.theAvgClassValues = new double[this.m_InputFormat.numAttributes()][0];
        this.theIndices = new int[this.m_InputFormat.numAttributes()][0];
        int n = 0;
        while (n < this.m_InputFormat.numAttributes()) {
            Attribute attribute = this.m_InputFormat.attribute(n);
            if (attribute.isNominal()) {
                this.theAvgClassValues[n] = new double[attribute.numValues()];
                double[] dArray = new double[attribute.numValues()];
                int n2 = 0;
                while (n2 < this.m_InputFormat.numInstances()) {
                    Instance instance = this.m_InputFormat.instance(n2);
                    if (!instance.classIsMissing() && !instance.isMissing(n)) {
                        int n3 = (int)instance.value(n);
                        dArray[n3] = dArray[n3] + instance.weight();
                        double[] dArray2 = this.theAvgClassValues[n];
                        int n4 = (int)instance.value(n);
                        dArray2[n4] = dArray2[n4] + instance.weight() * instance.classValue();
                    }
                    ++n2;
                }
                double d = Utils.sum(this.theAvgClassValues[n]);
                double d2 = Utils.sum(dArray);
                if (Utils.gr(d2, 0.0)) {
                    int n5 = 0;
                    while (n5 < attribute.numValues()) {
                        if (Utils.gr(dArray[n5], 0.0)) {
                            double[] dArray3 = this.theAvgClassValues[n];
                            int n6 = n5;
                            dArray3[n6] = dArray3[n6] / dArray[n5];
                        } else {
                            this.theAvgClassValues[n][n5] = d / d2;
                        }
                        ++n5;
                    }
                }
                this.theIndices[n] = Utils.sort(this.theAvgClassValues[n]);
            }
            ++n;
        }
    }

    private void setOutputFormat() throws Exception {
        if (this.m_InputFormat.classAttribute().isNominal()) {
            this.setOutputFormatNominal();
            return;
        }
        this.setOutputFormatNumeric();
    }

    private void convertInstance(Instance instance) throws Exception {
        if (this.m_InputFormat.classAttribute().isNominal()) {
            this.convertInstanceNominal(instance);
            return;
        }
        this.convertInstanceNumeric(instance);
    }

    private void setOutputFormatNominal() {
        try {
            int n = this.m_InputFormat.classIndex();
            FastVector fastVector = new FastVector();
            int n2 = 0;
            while (n2 < this.m_InputFormat.numAttributes()) {
                Attribute attribute = this.m_InputFormat.attribute(n2);
                if (!attribute.isNominal() || n2 == this.m_InputFormat.classIndex()) {
                    fastVector.addElement(attribute.copy());
                } else {
                    if (n2 < this.m_InputFormat.classIndex()) {
                        n += attribute.numValues() - 1;
                    }
                    int n3 = 0;
                    while (n3 < attribute.numValues()) {
                        StringBuffer stringBuffer = new StringBuffer("'" + NominalToNumericFilter.removeQuotes(attribute.name()) + "=");
                        stringBuffer.append(NominalToNumericFilter.removeQuotes(attribute.value(n3)));
                        stringBuffer.append("'");
                        fastVector.addElement(new Attribute(stringBuffer.toString()));
                        ++n3;
                    }
                }
                ++n2;
            }
            Instances instances = new Instances(this.m_InputFormat.relationName(), fastVector, 0);
            instances.setClassIndex(n);
            this.setOutputFormat(instances);
            return;
        }
        catch (Exception exception) {
            System.err.println("Problem setting new output format");
            System.exit(0);
            return;
        }
    }

    private void setOutputFormatNumeric() {
        if (this.theAvgClassValues == null) {
            this.setOutputFormat(null);
            return;
        }
        try {
            int n = this.m_InputFormat.classIndex();
            FastVector fastVector = new FastVector();
            int n2 = 0;
            while (n2 < this.m_InputFormat.numAttributes()) {
                Attribute attribute = this.m_InputFormat.attribute(n2);
                if (!attribute.isNominal() || n2 == this.m_InputFormat.classIndex()) {
                    fastVector.addElement(attribute.copy());
                } else {
                    if (n2 < this.m_InputFormat.classIndex()) {
                        n += attribute.numValues() - 2;
                    }
                    int n3 = 1;
                    while (n3 < attribute.numValues()) {
                        StringBuffer stringBuffer = new StringBuffer("'" + NominalToNumericFilter.removeQuotes(attribute.name()) + "=");
                        int n4 = n3;
                        while (n4 < attribute.numValues()) {
                            if (n4 > n3) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(NominalToNumericFilter.removeQuotes(attribute.value(this.theIndices[n2][n4])));
                            ++n4;
                        }
                        stringBuffer.append("'");
                        fastVector.addElement(new Attribute(stringBuffer.toString()));
                        ++n3;
                    }
                }
                ++n2;
            }
            Instances instances = new Instances(this.m_InputFormat.relationName(), fastVector, 0);
            instances.setClassIndex(n);
            this.setOutputFormat(instances);
            return;
        }
        catch (Exception exception) {
            System.err.println("Problem setting new output format");
            System.exit(0);
            return;
        }
    }

    private void convertInstanceNominal(Instance instance) throws Exception {
        Instance instance2 = new Instance(this.outputFormatPeek().numAttributes());
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_InputFormat.numAttributes()) {
            Attribute attribute = this.m_InputFormat.attribute(n2);
            if (!attribute.isNominal() || n2 == this.m_InputFormat.classIndex()) {
                instance2.setValue(n, instance.value(n2));
                ++n;
            } else {
                int n3;
                if (instance.isMissing(n2)) {
                    n3 = 0;
                    while (n3 < attribute.numValues()) {
                        instance2.setValue(n + n3, instance.value(n2));
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < attribute.numValues()) {
                        if (n3 == (int)instance.value(n2)) {
                            instance2.setValue(n + n3, 1.0);
                        } else {
                            instance2.setValue(n + n3, 0.0);
                        }
                        ++n3;
                    }
                }
                n += attribute.numValues();
            }
            ++n2;
        }
        instance2.setWeight(instance.weight());
        this.push(instance2);
    }

    private void convertInstanceNumeric(Instance instance) throws Exception {
        Instance instance2 = new Instance(this.outputFormatPeek().numAttributes());
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_InputFormat.numAttributes()) {
            Attribute attribute = this.m_InputFormat.attribute(n2);
            if (!attribute.isNominal() || n2 == this.m_InputFormat.classIndex()) {
                instance2.setValue(n, instance.value(n2));
                ++n;
            } else {
                int n3;
                if (instance.isMissing(n2)) {
                    n3 = 0;
                    while (n3 < attribute.numValues() - 1) {
                        instance2.setValue(n + n3, instance.value(n2));
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while ((int)instance.value(n2) != this.theIndices[n2][n3]) {
                        instance2.setValue(n + n3, 1.0);
                        ++n3;
                    }
                    while (n3 < attribute.numValues() - 1) {
                        instance2.setValue(n + n3, 0.0);
                        ++n3;
                    }
                }
                n += attribute.numValues() - 1;
            }
            ++n2;
        }
        instance2.setWeight(instance.weight());
        this.push(instance2);
    }

    private static final String removeQuotes(String string) {
        if (string.endsWith("'") || string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new NominalToNumericFilter(), stringArray);
                return;
            }
            Filter.filterFile(new NominalToNumericFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

