/*
 * Decompiled with CFR 0.152.
 */
package jaws.filterPackage;

import java.util.Enumeration;
import java.util.Vector;
import jaws.corePackage.Attribute;
import jaws.corePackage.FastVector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;
import jaws.filterPackage.Filter;

public class MergeTwoValuesFilter
extends Filter
implements OptionHandler {
    private int theAttIndex = -1;
    private int theFirstIndex = -1;
    private int theSecondIndex = -1;

    public boolean inputFormat(Instances instances) throws Exception {
        this.m_InputFormat = new Instances(instances, 0);
        if (this.theAttIndex < 0) {
            throw new Exception("No attribute chosen.");
        }
        if (!this.m_InputFormat.attribute(this.theAttIndex).isNominal()) {
            throw new Exception("Chosen attribute not nominal.");
        }
        if (this.m_InputFormat.attribute(this.theAttIndex).numValues() < 2) {
            throw new Exception("Chosen attribute has less than two values.");
        }
        if (this.theFirstIndex < 0) {
            throw new Exception("First value undefined.");
        }
        if (this.theSecondIndex < 0) {
            throw new Exception("Second value undefined.");
        }
        if (this.theSecondIndex <= this.theFirstIndex) {
            throw new Exception("The second index has to be greater than the first.");
        }
        this.b_NewBatch = true;
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        Instance instance2;
        if (this.m_InputFormat == null) {
            throw new Exception("No input instance format defined");
        }
        if (this.b_NewBatch) {
            this.resetQueue();
            this.b_NewBatch = false;
        }
        if ((int)(instance2 = (Instance)instance.copy()).value(this.theAttIndex) == this.theSecondIndex) {
            instance2.setValue(this.theAttIndex, (double)this.theFirstIndex);
        } else if ((int)instance2.value(this.theAttIndex) > this.theSecondIndex) {
            instance2.setValue(this.theAttIndex, instance2.value(this.theAttIndex) - 1.0);
        }
        this.push(instance2);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSets the attribute index.", "C", 1, "-C <col>"));
        vector.addElement(new Option("\tSets the first value's index.", "F", 1, "-F <col>"));
        vector.addElement(new Option("\tSets the second value's index.", "S", 1, "-S <col>"));
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string;
        String string2;
        String string3 = Utils.getOption('C', stringArray);
        if (string3.length() != 0) {
            if (string3.toLowerCase().equals("last")) {
                this.setAttIndex(0);
            } else if (string3.toLowerCase().equals("first")) {
                this.setAttIndex(1);
            } else {
                this.setAttIndex(Integer.parseInt(string3));
            }
        }
        if ((string2 = Utils.getOption('F', stringArray)).length() != 0) {
            if (string2.toLowerCase().equals("last")) {
                this.setFirstValueIndex(0);
            } else if (string2.toLowerCase().equals("first")) {
                this.setFirstValueIndex(1);
            } else {
                this.setFirstValueIndex(Integer.parseInt(string2));
            }
        }
        if ((string = Utils.getOption('S', stringArray)).length() != 0) {
            if (string.toLowerCase().equals("last")) {
                this.setSecondValueIndex(0);
            } else if (string.toLowerCase().equals("first")) {
                this.setSecondValueIndex(1);
            } else {
                this.setSecondValueIndex(Integer.parseInt(string));
            }
        }
        if (this.m_InputFormat != null) {
            this.inputFormat(this.m_InputFormat);
        }
    }

    public int getAttIndex() {
        return this.theAttIndex + 1;
    }

    public void setAttIndex(int n) {
        this.theAttIndex = n - 1;
    }

    public int getFirstValueIndex() {
        return this.theFirstIndex + 1;
    }

    public void setFirstValueIndex(int n) {
        this.theFirstIndex = n - 1;
    }

    public int getSecondValueIndex() {
        return this.theSecondIndex + 1;
    }

    public void setSecondValueIndex(int n) {
        this.theSecondIndex = n - 1;
    }

    private void setOutputFormat() {
        try {
            boolean bl = false;
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            FastVector fastVector = new FastVector(this.m_InputFormat.numAttributes());
            int n = 0;
            while (n < this.m_InputFormat.numAttributes()) {
                Attribute attribute = this.m_InputFormat.attribute(n);
                if (n != this.theAttIndex) {
                    fastVector.addElement(attribute.copy());
                } else {
                    if (attribute.value(this.theFirstIndex).endsWith("'")) {
                        bl = true;
                    }
                    if (attribute.value(this.theSecondIndex).endsWith("'")) {
                        bl2 = true;
                    }
                    if (bl || bl2) {
                        stringBuffer.append("'");
                    }
                    if (bl) {
                        stringBuffer.append(attribute.value(this.theFirstIndex).substring(1, attribute.value(this.theFirstIndex).length() - 1));
                    } else {
                        stringBuffer.append(attribute.value(this.theFirstIndex));
                    }
                    stringBuffer.append('_');
                    if (bl2) {
                        stringBuffer.append(attribute.value(this.theSecondIndex).substring(1, attribute.value(this.theSecondIndex).length() - 1));
                    } else {
                        stringBuffer.append(attribute.value(this.theSecondIndex));
                    }
                    if (bl || bl2) {
                        stringBuffer.append("'");
                    }
                    FastVector fastVector2 = new FastVector(attribute.numValues() - 1);
                    int n2 = 0;
                    while (n2 < attribute.numValues()) {
                        if (n2 == this.theFirstIndex) {
                            fastVector2.addElement(stringBuffer.toString());
                        } else if (n2 != this.theSecondIndex) {
                            fastVector2.addElement(attribute.value(n2));
                        }
                        ++n2;
                    }
                    fastVector.addElement(new Attribute(attribute.name(), fastVector2));
                }
                ++n;
            }
            Instances instances = new Instances(this.m_InputFormat.relationName(), fastVector, 0);
            instances.setClassIndex(this.m_InputFormat.classIndex());
            this.setOutputFormat(instances);
            return;
        }
        catch (Exception exception) {
            System.err.println("Problem setting new output format");
            System.exit(0);
            return;
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new MergeTwoValuesFilter(), stringArray);
                return;
            }
            Filter.filterFile(new MergeTwoValuesFilter(), stringArray);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

