/*
 * Decompiled with CFR 0.152.
 */
package jaws.corePackage;

import jaws.corePackage.Utils;

public final class SpecialFunctions {
    private static double log2 = Math.log(2.0);
    private static double[] cofLogGamma = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};

    public static double lnFactorial(double d) {
        return SpecialFunctions.lnGamma(d + 1.0);
    }

    public static double lnGamma(double d) {
        double d2 = d;
        double d3 = d + 5.5;
        d3 -= (d + 0.5) * Math.log(d3);
        double d4 = 1.000000000190015;
        int n = 0;
        while (n <= 5) {
            d4 += cofLogGamma[n] / (d2 += 1.0);
            ++n;
        }
        return -d3 + Math.log(2.5066282746310007 * d4 / d);
    }

    public static double log2Binomial(double d, double d2) throws ArithmeticException {
        if (Utils.gr(d2, d)) {
            throw new ArithmeticException("Can't compute binomial coefficient.");
        }
        return (SpecialFunctions.lnFactorial(d) - SpecialFunctions.lnFactorial(d2) - SpecialFunctions.lnFactorial(d - d2)) / log2;
    }

    public static double log2Multinomial(double d, double[] dArray) throws ArithmeticException {
        double d2 = 0.0;
        int n = 0;
        while (n < dArray.length) {
            if (Utils.gr(dArray[n], d)) {
                throw new ArithmeticException("Can't compute multinomial coefficient.");
            }
            d2 += SpecialFunctions.lnFactorial(dArray[n]);
            ++n;
        }
        return (SpecialFunctions.lnFactorial(d) - d2) / log2;
    }
}

