/*
 * Decompiled with CFR 0.152.
 */
package jaws.corePackage;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Random;
import jaws.corePackage.Attribute;
import jaws.corePackage.FastVector;
import jaws.corePackage.Instance;
import jaws.corePackage.Utils;

public class Instances
implements Serializable {
    private String theRelationName;
    private FastVector theAttributes;
    private FastVector theInstances;
    private int theClassIndex;

    public final void add(Instance instance) {
        Instance instance2 = new Instance(instance);
        instance2.setDataset(this);
        this.theInstances.addElement(instance2);
    }

    public void applyCostMatrix(double[][] dArray) throws Exception {
        double d = 0.0;
        if (this.theClassIndex < 0) {
            throw new Exception("Class index is negativ (not set)!");
        }
        if (dArray.length != this.numClasses()) {
            throw new Exception("Misclassification cost matrix has " + "wrong format!");
        }
        double[] dArray2 = new double[this.numClasses()];
        double[] dArray3 = new double[this.numClasses()];
        int n = 0;
        while (n < this.numInstances()) {
            int n2 = (int)this.instance(n).classValue();
            dArray3[n2] = dArray3[n2] + this.instance(n).weight();
            ++n;
        }
        double d2 = Utils.sum(dArray3);
        n = 0;
        while (n < this.numClasses()) {
            if (dArray[n].length != this.numClasses()) {
                throw new Exception("Misclassification cost matrix has " + "wrong format!");
            }
            if (!Utils.eq(dArray[n][n], 0.0)) {
                throw new Exception("Diagonal of misclassification cost " + "matrix not zero!");
            }
            double d3 = 0.0;
            int n3 = 0;
            while (n3 < this.numClasses()) {
                if (Utils.sm(dArray[n][n3], 0.0)) {
                    throw new Exception("Neg. weights in misclassification " + "cost matrix!");
                }
                d3 += dArray[n][n3];
                ++n3;
            }
            dArray2[n] = d3 * d2;
            d += d3 * dArray3[n];
            ++n;
        }
        n = 0;
        while (n < this.numClasses()) {
            int n4 = n++;
            dArray2[n4] = dArray2[n4] / d;
        }
        n = 0;
        while (n < this.numInstances()) {
            this.instance(n).setWeight(this.instance(n).weight() * dArray2[(int)this.instance(n).classValue()]);
            ++n;
        }
    }

    public final Attribute attribute(int n) {
        return (Attribute)this.theAttributes.elementAt(n);
    }

    public final Attribute attribute(String string) {
        int n = 0;
        while (n < this.numAttributes()) {
            if (this.attribute(n).name().equals(string)) {
                return this.attribute(n);
            }
            ++n;
        }
        return null;
    }

    public final boolean checkInstance(Instance instance) {
        if (instance.numAttributes() != this.numAttributes()) {
            return false;
        }
        int n = 0;
        while (n < this.numAttributes()) {
            if (!instance.isMissing(n) && (this.attribute(n).isNominal() || this.attribute(n).isString())) {
                if (!Utils.eq(instance.value(n), (int)instance.value(n))) {
                    return false;
                }
                if (Utils.sm(instance.value(n), 0.0) || Utils.gr(instance.value(n), this.attribute(n).numValues())) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public final Attribute classAttribute() throws Exception {
        if (this.theClassIndex < 0) {
            throw new Exception("Class index is negativ (not set)!");
        }
        return this.attribute(this.theClassIndex);
    }

    public final int classIndex() {
        return this.theClassIndex;
    }

    public final void compactify() {
        this.theInstances.trimToSize();
    }

    public final void delete(int n) {
        this.theInstances.removeElementAt(n);
    }

    public final void deleteWithMissing(int n) {
        FastVector fastVector = new FastVector(this.numInstances());
        int n2 = 0;
        while (n2 < this.numInstances()) {
            if (!this.instance(n2).isMissing(n)) {
                fastVector.addElement(this.instance(n2));
            }
            ++n2;
        }
        this.theInstances = fastVector;
    }

    public final void deleteWithMissing(Attribute attribute) {
        this.deleteWithMissing(attribute.index());
    }

    public final void deleteWithMissingClass() throws Exception {
        if (this.theClassIndex < 0) {
            throw new Exception("Class index is negativ (not set)!");
        }
        this.deleteWithMissing(this.theClassIndex);
    }

    public Enumeration enumerateAttributes() {
        return this.theAttributes.elements(this.theClassIndex);
    }

    public final Enumeration enumerateInstances() {
        return this.theInstances.elements();
    }

    public final boolean equalHeaders(Instances instances) {
        if (this.theClassIndex != instances.theClassIndex) {
            return false;
        }
        if (this.theAttributes.size() != instances.theAttributes.size()) {
            return false;
        }
        int n = 0;
        while (n < this.theAttributes.size()) {
            if (!this.attribute(n).equals(instances.attribute(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void deleteAttributeAt(int n) throws Exception {
        if (n < 0 || n >= this.theAttributes.size()) {
            throw new Exception("Can't delete attribute: index out of " + "range");
        }
        if (n == this.theClassIndex) {
            throw new Exception("Can't delete class attribute");
        }
        this.freshAttributeInfo();
        if (this.theClassIndex > n) {
            --this.theClassIndex;
        }
        this.theAttributes.removeElementAt(n);
        int n2 = n;
        while (n2 < this.theAttributes.size()) {
            Attribute attribute = (Attribute)this.theAttributes.elementAt(n2);
            attribute.setIndex(attribute.index() - 1);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numInstances()) {
            this.instance(n2).forceDeleteAttributeAt(n);
            ++n2;
        }
    }

    public void deleteStringAttributes() throws Exception {
        int n = 0;
        while (n < this.theAttributes.size()) {
            if (this.attribute(n).isString()) {
                this.deleteAttributeAt(n);
                continue;
            }
            ++n;
        }
    }

    public void insertAttributeAt(Attribute attribute, int n) throws Exception {
        if (n < 0 || n > this.theAttributes.size()) {
            throw new Exception("Can't insert attribute: index out " + "of range");
        }
        attribute = (Attribute)attribute.copy();
        this.freshAttributeInfo();
        attribute.setIndex(n);
        this.theAttributes.insertElementAt(attribute, n);
        int n2 = n + 1;
        while (n2 < this.theAttributes.size()) {
            Attribute attribute2 = (Attribute)this.theAttributes.elementAt(n2);
            attribute2.setIndex(attribute2.index() + 1);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.numInstances()) {
            this.instance(n2).forceInsertAttributeAt(n);
            ++n2;
        }
        if (this.theClassIndex >= n) {
            ++this.theClassIndex;
        }
    }

    public final Instance instance(int n) {
        return (Instance)this.theInstances.elementAt(n);
    }

    public final Instance lastInstance() {
        return (Instance)this.theInstances.lastElement();
    }

    public final double meanOrMode(int n) {
        if (this.attribute(n).isNumeric()) {
            double d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.numInstances()) {
                if (!this.instance(n2).isMissing(n)) {
                    d += this.instance(n2).weight();
                    d2 += this.instance(n2).weight() * this.instance(n2).value(n);
                }
                ++n2;
            }
            if (Utils.eq(d, 0.0)) {
                return 0.0;
            }
            return d2 / d;
        }
        if (this.attribute(n).isNominal()) {
            int[] nArray = new int[this.attribute(n).numValues()];
            int n3 = 0;
            while (n3 < this.numInstances()) {
                if (!this.instance(n3).isMissing(n)) {
                    int n4 = (int)this.instance(n3).value(n);
                    nArray[n4] = (int)((double)nArray[n4] + this.instance(n3).weight());
                }
                ++n3;
            }
            return Utils.maxIndex(nArray);
        }
        return 0.0;
    }

    public final double meanOrMode(Attribute attribute) {
        return this.meanOrMode(attribute.index());
    }

    public final int numAttributes() {
        return this.theAttributes.size();
    }

    public final int numClasses() throws Exception {
        if (this.theClassIndex < 0) {
            throw new Exception("Class index is negativ (not set)!");
        }
        if (!this.classAttribute().isNominal()) {
            return 1;
        }
        return this.classAttribute().numValues();
    }

    public final int numDistinctValues(int n) {
        double d = 0.0;
        int n2 = 0;
        if (this.attribute(n).isNumeric()) {
            this.sort(n);
            int n3 = 0;
            while (n3 < this.numInstances()) {
                if (this.instance(n3).isMissing(n)) break;
                if (n3 == 0 || Utils.gr(this.instance(n3).value(n), d)) {
                    d = this.instance(n3).value(n);
                    ++n2;
                }
                ++n3;
            }
            return n2;
        }
        return this.attribute(n).numValues();
    }

    public final int numDistinctValues(Attribute attribute) {
        return this.numDistinctValues(attribute.index());
    }

    public final int numInstances() {
        return this.theInstances.size();
    }

    public final double[][] readCostMatrix(InputStream inputStream) throws Exception {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(inputStream);
        double[][] dArray = new double[this.numClasses()][this.numClasses()];
        if (this.theClassIndex < 0) {
            throw new Exception("Class index is negativ (not set)!");
        }
        int n2 = 0;
        while (n2 < this.numClasses()) {
            int n3 = 0;
            while (n3 < this.numClasses()) {
                if (n2 != n3) {
                    dArray[n2][n3] = 1.0;
                }
                ++n3;
            }
            ++n2;
        }
        streamTokenizer.commentChar(37);
        streamTokenizer.eolIsSignificant(true);
        while (-1 != (n = streamTokenizer.nextToken())) {
            if (n == 10) continue;
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed " + "in cost file!");
            }
            double d = streamTokenizer.nval;
            if (!Utils.eq((int)d, d)) {
                throw new Exception("First number in line has to be " + "index of a class!");
            }
            if ((int)d >= this.numClasses()) {
                throw new Exception("Class index out of range!");
            }
            n = streamTokenizer.nextToken();
            if (-1 == n) {
                throw new Exception("Premature end of file!");
            }
            if (n == 10) {
                throw new Exception("Premature end of line!");
            }
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed " + "in cost file!");
            }
            double d2 = streamTokenizer.nval;
            if (!Utils.eq((int)d2, d2)) {
                throw new Exception("Second number in line has to be " + "index of a class!");
            }
            if ((int)d2 >= this.numClasses()) {
                throw new Exception("Class index out of range!");
            }
            if ((int)d2 == (int)d) {
                throw new Exception("Can't change diagonal of cost matrix!");
            }
            n = streamTokenizer.nextToken();
            if (-1 == n) {
                throw new Exception("Premature end of file!");
            }
            if (n == 10) {
                throw new Exception("Premature end of line!");
            }
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed " + "in cost file!");
            }
            double d3 = streamTokenizer.nval;
            if (!Utils.gr(d3, 0.0)) {
                throw new Exception("Only positive weights allowed!");
            }
            dArray[(int)d][(int)d2] = d3;
        }
        return dArray;
    }

    public final boolean readInstance(InputStream inputStream) throws IOException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(inputStream);
        this.initTokenizer(streamTokenizer);
        return this.getInstance(streamTokenizer, false);
    }

    public final void randomize(Random random) {
        int n = this.numInstances() - 1;
        while (n > 0) {
            this.swap(n, (int)(random.nextDouble() * (double)n));
            --n;
        }
    }

    public final String relationName() {
        return this.theRelationName;
    }

    public final void setClassIndex(int n) throws Exception {
        if (n >= this.numAttributes()) {
            throw new Exception("Class index to large!");
        }
        this.theClassIndex = n;
    }

    public final void sort(int n) {
        int n2 = this.numInstances() - 1;
        int n3 = 0;
        while (n3 <= n2) {
            if (this.instance(n2).isMissing(n)) {
                --n2;
                continue;
            }
            if (this.instance(n3).isMissing(n)) {
                this.swap(n3, n2);
                --n2;
            }
            ++n3;
        }
        this.quickSort(n, 0, n2);
    }

    public final void sort(Attribute attribute) {
        this.sort(attribute.index());
    }

    public final void stratify(int n) throws Exception {
        if (this.theClassIndex < 0) {
            throw new Exception("Class index is negativ (not set)!");
        }
        if (this.classAttribute().isNominal()) {
            int n2 = 1;
            while (n2 < this.numInstances()) {
                Instance instance = this.instance(n2 - 1);
                int n3 = n2;
                while (n3 < this.numInstances()) {
                    Instance instance2 = this.instance(n3);
                    if (instance.classValue() == instance2.classValue() || instance.classIsMissing() && instance2.classIsMissing()) {
                        this.swap(n2, n3);
                        ++n2;
                    }
                    ++n3;
                }
                ++n2;
            }
            this.stratStep(n);
        }
    }

    public final double sumOfWeights() {
        double d = 0.0;
        int n = 0;
        while (n < this.numInstances()) {
            d += this.instance(n).weight();
            ++n;
        }
        return d;
    }

    public Instances testCV(int n, int n2) throws Exception {
        int n3;
        int n4 = this.numInstances() / n;
        if (n2 < this.numInstances() % n) {
            ++n4;
            n3 = n2;
        } else {
            n3 = this.numInstances() % n;
        }
        Instances instances = new Instances(this, n4);
        int n5 = n2 * (this.numInstances() / n) + n3;
        this.copyInstances(n5, instances, n4);
        return instances;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@relation " + this.theRelationName + "\n\n");
        int n = 0;
        while (n < this.numAttributes()) {
            stringBuffer.append(this.attribute(n) + "\n");
            ++n;
        }
        stringBuffer.append("\n@data\n");
        n = 0;
        while (n < this.numInstances()) {
            stringBuffer.append(this.instance(n));
            if (n < this.numInstances() - 1) {
                stringBuffer.append('\n');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Instances trainCV(int n, int n2) throws Exception {
        int n3;
        int n4 = this.numInstances() / n;
        if (n2 < this.numInstances() % n) {
            ++n4;
            n3 = n2;
        } else {
            n3 = this.numInstances() % n;
        }
        Instances instances = new Instances(this, this.numInstances() - n4);
        int n5 = n2 * (this.numInstances() / n) + n3;
        this.copyInstances(0, instances, n5);
        this.copyInstances(n5 + n4, instances, this.numInstances() - n5 - n4);
        return instances;
    }

    public final double variance(int n) throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (!this.attribute(n).isNumeric()) {
            throw new Exception("Can't compute variance for numeric " + "attribute!");
        }
        int n2 = 0;
        while (n2 < this.numInstances()) {
            if (!this.instance(n2).isMissing(n)) {
                d += this.instance(n2).weight() * this.instance(n2).value(n);
                d2 += this.instance(n2).weight() * this.instance(n2).value(n) * this.instance(n2).value(n);
                d3 += this.instance(n2).weight();
            }
            ++n2;
        }
        if (Utils.smOrEq(d3, 1.0)) {
            return 0.0;
        }
        return (d2 - d * d / d3) / (d3 - 1.0);
    }

    public final double variance(Attribute attribute) throws Exception {
        return this.variance(attribute.index());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean getInstance(StreamTokenizer streamTokenizer, boolean bl) throws IOException {
        if (this.theAttributes.size() == 0) {
            this.errms(streamTokenizer, "no header information available");
        }
        double[] dArray = new double[this.numAttributes()];
        int n = 0;
        while (n < this.numAttributes()) {
            if (n == 0) {
                this.getFirstToken(streamTokenizer);
                if (streamTokenizer.ttype == -1) {
                    return false;
                }
            } else {
                this.getNextToken(streamTokenizer);
            }
            if (streamTokenizer.ttype != -3) {
                this.errms(streamTokenizer, "not a valid value");
            }
            if (streamTokenizer.sval.equals("?")) {
                dArray[n] = Instance.missingValue();
            } else if (this.attribute(n).isNominal()) {
                int n2 = this.attribute(n).indexOfValue(streamTokenizer.sval);
                if (n2 == -1) {
                    this.errms(streamTokenizer, "nominal value not declared in header");
                }
                dArray[n] = n2;
            } else if (this.attribute(n).isNumeric()) {
                try {
                    dArray[n] = Double.valueOf(streamTokenizer.sval);
                }
                catch (NumberFormatException numberFormatException) {
                    this.errms(streamTokenizer, "number expected");
                }
            } else {
                this.attribute(n).forceAddValue(streamTokenizer.sval);
                dArray[n] = (double)this.attribute(n).numValues() - 1.0;
            }
            ++n;
        }
        if (bl) {
            this.getLastToken(streamTokenizer);
        }
        this.add(new Instance(1.0, dArray));
        return true;
    }

    protected void readHeader(StreamTokenizer streamTokenizer) throws IOException {
        this.getFirstToken(streamTokenizer);
        if (streamTokenizer.ttype == -1) {
            this.errms(streamTokenizer, "premature end of file");
        }
        if (streamTokenizer.sval.equalsIgnoreCase("@relation")) {
            this.getNextToken(streamTokenizer);
            this.theRelationName = streamTokenizer.sval;
            this.getLastToken(streamTokenizer);
        } else {
            this.errms(streamTokenizer, "keyword @relation expected");
        }
        this.theAttributes = new FastVector();
        this.getFirstToken(streamTokenizer);
        if (streamTokenizer.ttype == -1) {
            this.errms(streamTokenizer, "premature end of file");
        }
        while (streamTokenizer.sval.equalsIgnoreCase("@attribute")) {
            this.getNextToken(streamTokenizer);
            String string = streamTokenizer.sval;
            this.getNextToken(streamTokenizer);
            if (streamTokenizer.ttype == -3) {
                if (streamTokenizer.sval.equalsIgnoreCase("real")) {
                    this.theAttributes.addElement(new Attribute(string, this.numAttributes()));
                    this.readTillEOL(streamTokenizer);
                } else if (streamTokenizer.sval.equalsIgnoreCase("integer")) {
                    this.theAttributes.addElement(new Attribute(string, this.numAttributes()));
                    this.readTillEOL(streamTokenizer);
                } else if (streamTokenizer.sval.equalsIgnoreCase("string")) {
                    this.theAttributes.addElement(new Attribute(string, null, this.numAttributes()));
                    this.readTillEOL(streamTokenizer);
                } else {
                    this.errms(streamTokenizer, "no valid attribute type or invalid " + "enumeration");
                }
            } else {
                FastVector fastVector = new FastVector();
                streamTokenizer.pushBack();
                if (streamTokenizer.nextToken() != 123) {
                    this.errms(streamTokenizer, "{ expected at beginning of enumeration");
                }
                while (streamTokenizer.nextToken() != 125) {
                    if (streamTokenizer.ttype == 10) {
                        this.errms(streamTokenizer, "} expected at end of enumeration");
                        continue;
                    }
                    if (streamTokenizer.ttype == 39) {
                        streamTokenizer.sval = this.quote(streamTokenizer.sval);
                    }
                    fastVector.addElement(streamTokenizer.sval);
                }
                if (fastVector.size() == 0) {
                    this.errms(streamTokenizer, "no nominal values found");
                }
                this.theAttributes.addElement(new Attribute(string, fastVector, this.numAttributes()));
            }
            this.getLastToken(streamTokenizer);
            this.getFirstToken(streamTokenizer);
            if (streamTokenizer.ttype != -1) continue;
            this.errms(streamTokenizer, "premature end of file");
        }
        if (!streamTokenizer.sval.equalsIgnoreCase("@data")) {
            this.errms(streamTokenizer, "keyword @data expected");
        }
        if (this.theAttributes.size() == 0) {
            this.errms(streamTokenizer, "no attributes declared");
        }
    }

    private final void copyInstances(int n, Instances instances, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            instances.add(this.instance(n + n3));
            ++n3;
        }
    }

    private final void errms(StreamTokenizer streamTokenizer, String string) throws IOException {
        throw new IOException(string + ", read " + streamTokenizer.toString());
    }

    private final void freshAttributeInfo() {
        this.theAttributes = (FastVector)this.theAttributes.copyElements();
    }

    private final void getFirstToken(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == 39) {
            streamTokenizer.sval = this.quote(streamTokenizer.sval);
            streamTokenizer.ttype = -3;
        }
    }

    private final void getLastToken(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != 10) {
            this.errms(streamTokenizer, "end of line expected");
        }
    }

    private final void getNextToken(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() == 10) {
            this.errms(streamTokenizer, "premature end of line");
        }
        if (streamTokenizer.ttype == -1) {
            this.errms(streamTokenizer, "premature end of file");
        } else if (streamTokenizer.ttype == 39) {
            streamTokenizer.sval = this.quote(streamTokenizer.sval);
            streamTokenizer.ttype = -3;
        }
    }

    private final void initTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.commentChar(37);
        streamTokenizer.quoteChar(39);
        streamTokenizer.ordinaryChar(123);
        streamTokenizer.ordinaryChar(125);
        streamTokenizer.eolIsSignificant(true);
    }

    private final String instancesAndWeights() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.numInstances()) {
            stringBuffer.append(this.instance(n) + " " + this.instance(n).weight());
            if (n < this.numInstances() - 1) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void quickSort(int var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = this.instance((var2_2 + var3_3) / 2).value(var1_1);
            var8_7 = var6_6 + 1.0E-6;
            var10_8 = var6_6 - 1.0E-6;
            ** GOTO lbl18
            {
                ++var4_4;
                do {
                    if (this.instance(var4_4).value(var1_1) < var10_8 && var4_4 < var3_3) continue block0;
                    while (this.instance(var5_5).value(var1_1) > var8_7 && var5_5 > var2_2) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    this.swap(var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl18:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    private final String quote(String string) {
        return "'".concat(string).concat("'");
    }

    private final void readTillEOL(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != 10) {
        }
        streamTokenizer.pushBack();
    }

    private final void stratStep(int n) {
        FastVector fastVector = new FastVector(this.theInstances.capacity());
        int n2 = 0;
        while (fastVector.size() < this.numInstances()) {
            int n3 = n2;
            while (n3 < this.numInstances()) {
                fastVector.addElement(this.instance(n3));
                n3 += n;
            }
            ++n2;
        }
        this.theInstances = fastVector;
    }

    private final void swap(int n, int n2) {
        this.theInstances.swap(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        Random random = new Random(2L);
        try {
            int n;
            int n2;
            if (stringArray.length > 2) {
                throw new Exception("Usage: Instances [<filename>] [<class index>]");
            }
            FastVector fastVector = new FastVector(2);
            fastVector.addElement("first_value");
            fastVector.addElement("second_value");
            FastVector fastVector2 = new FastVector(2);
            fastVector2.addElement(new Attribute("nominal_attribute", fastVector));
            fastVector2.addElement(new Attribute("numeric_attribute"));
            Instances instances = new Instances("test_set", fastVector2, 10);
            instances.add(new Instance(instances.numAttributes()));
            instances.add(new Instance(instances.numAttributes()));
            System.out.println("\nSet of instances created from scratch:\n");
            System.out.println(instances);
            if (stringArray.length >= 1) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                int n3 = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : 0;
                System.out.println("\nFirst five instances from file:\n");
                instances = new Instances(fileInputStream, 1);
                instances.setClassIndex(n3 - 1);
                n2 = 0;
                while (n2 < 5 && instances.readInstance(fileInputStream)) {
                    ++n2;
                }
                System.out.println(instances);
                fileInputStream = new FileInputStream(stringArray[0]);
                instances = new Instances(fileInputStream);
                instances.setClassIndex(n3 - 1);
                System.out.println("\nDataset:\n");
                System.out.println(instances);
                System.out.println("\nClass index: " + instances.classIndex());
            }
            System.out.println("\nClass name: " + instances.classAttribute().name());
            System.out.println("\nClass index: " + instances.classIndex());
            System.out.println("\nClass is nominal: " + instances.classAttribute().isNominal());
            System.out.println("\nClass is numeric: " + instances.classAttribute().isNumeric());
            System.out.println("\nClasses:\n");
            n2 = 0;
            while (n2 < instances.numClasses()) {
                System.out.println(instances.classAttribute().value(n2));
                ++n2;
            }
            System.out.println("\nClass values and labels of instances:\n");
            n2 = 0;
            while (n2 < instances.numInstances()) {
                System.out.print(instances.instance(n2).classValue() + "\t");
                System.out.print(instances.instance(n2).classLabel());
                if (instances.instance(n2).classIsMissing()) {
                    System.out.println("\tis missing");
                } else {
                    System.out.println();
                }
                ++n2;
            }
            System.out.println("\nCreating random weights for instances.");
            n2 = 0;
            while (n2 < instances.numInstances()) {
                instances.instance(n2).setWeight(random.nextDouble());
                ++n2;
            }
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
            Instances instances2 = new Instances(instances);
            Attribute attribute = new Attribute("Inserted");
            instances2.insertAttributeAt(attribute, 0);
            System.out.println("\nSet with inserted attribute:\n");
            System.out.println(instances2);
            System.out.println("\nClass name: " + instances2.classAttribute().name());
            instances2.deleteAttributeAt(0);
            System.out.println("\nSet with attribute deleted:\n");
            System.out.println(instances2);
            System.out.println("\nClass name: " + instances2.classAttribute().name());
            System.out.println("\nHeaders equal: " + instances.equalHeaders(instances2) + "\n");
            System.out.println("\nData (internal values):\n");
            n2 = 0;
            while (n2 < instances.numInstances()) {
                n = 0;
                while (n < instances.numAttributes()) {
                    if (instances.instance(n2).isMissing(n)) {
                        System.out.print("? ");
                    } else {
                        System.out.print(instances.instance(n2).value(n) + " ");
                    }
                    ++n;
                }
                System.out.println();
                ++n2;
            }
            System.out.println("\nEmpty dataset:\n");
            Instances instances3 = new Instances(instances, 0);
            System.out.println(instances3);
            System.out.println("\nClass name: " + instances3.classAttribute().name());
            int n4 = instances.numInstances() / 4;
            int n5 = instances.numInstances() / 2;
            System.out.print("\nSubset of dataset: ");
            System.out.println(n5 + " instances from " + (n4 + 1) + ". instance");
            instances2 = new Instances(instances, n4, n5);
            System.out.println("\nClass name: " + instances2.classAttribute().name());
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances2.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances2.sumOfWeights());
            System.out.println("\nTrain and test folds for 3-fold CV:");
            if (instances.classAttribute().isNominal()) {
                instances.stratify(3);
            }
            n = 0;
            while (n < 3) {
                Instances instances4 = instances.trainCV(3, n);
                Instances instances5 = instances.testCV(3, n);
                System.out.println("\nTrain: ");
                System.out.println("\nInstances and their weights:\n");
                System.out.println(instances4.instancesAndWeights());
                System.out.print("\nSum of weights: ");
                System.out.println(instances4.sumOfWeights());
                System.out.println("\nClass name: " + instances4.classAttribute().name());
                System.out.println("\nTest: ");
                System.out.println("\nInstances and their weights:\n");
                System.out.println(instances5.instancesAndWeights());
                System.out.print("\nSum of weights: ");
                System.out.println(instances5.sumOfWeights());
                System.out.println("\nClass name: " + instances5.classAttribute().name());
                ++n;
            }
            System.out.println("\nRandomized dataset:");
            instances.randomize(random);
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
            System.out.print("\nInstances sorted according to first attribute:\n ");
            instances.sort(0);
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights:");
            System.out.println(instances.sumOfWeights());
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Instances(InputStream inputStream) throws Exception {
        StreamTokenizer streamTokenizer = new StreamTokenizer(inputStream);
        this.initTokenizer(streamTokenizer);
        this.readHeader(streamTokenizer);
        this.theClassIndex = -1;
        this.theInstances = new FastVector(1000);
        while (this.getInstance(streamTokenizer, true)) {
        }
        this.compactify();
    }

    public Instances(InputStream inputStream, int n) throws Exception {
        if (n < 0) {
            throw new Exception("Capacity has to be positive!");
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(inputStream);
        this.initTokenizer(streamTokenizer);
        this.readHeader(streamTokenizer);
        this.theClassIndex = -1;
        this.theInstances = new FastVector(n);
    }

    public Instances(Instances instances) {
        this(instances, instances.numInstances());
        instances.copyInstances(0, this, instances.numInstances());
    }

    public Instances(Instances instances, int n) {
        if (n < 0) {
            n = 0;
        }
        this.theClassIndex = instances.theClassIndex;
        this.theRelationName = instances.theRelationName;
        this.theAttributes = instances.theAttributes;
        this.theInstances = new FastVector(n);
    }

    public Instances(Instances instances, int n, int n2) throws Exception {
        this(instances, n2);
        if (n < 0 || n + n2 > instances.numInstances()) {
            throw new Exception("Parameters first and/or toCopy out " + "of range");
        }
        instances.copyInstances(n, this, n2);
    }

    public Instances(String string, FastVector fastVector, int n) {
        this.theRelationName = string;
        this.theClassIndex = -1;
        this.theAttributes = fastVector;
        int n2 = 0;
        while (n2 < this.numAttributes()) {
            this.attribute(n2).setIndex(n2);
            ++n2;
        }
        this.theInstances = new FastVector(n);
    }
}

