/*
 * Decompiled with CFR 0.152.
 */
package jaws.corePackage;

import java.io.Serializable;
import java.util.Enumeration;
import jaws.corePackage.Copyable;

public class FastVector
implements Copyable,
Serializable {
    private Object[] theObjects;
    private int theSize;
    private int theCapacityIncrement;
    private double theCapacityMultiplier;

    public FastVector() {
        this.theObjects = new Object[0];
        this.theSize = 0;
        this.theCapacityIncrement = 1;
        this.theCapacityMultiplier = 2.0;
    }

    public FastVector(int n) {
        this.theObjects = new Object[n];
        this.theSize = 0;
        this.theCapacityIncrement = 1;
        this.theCapacityMultiplier = 2.0;
    }

    public FastVector(int n, int n2, double d) {
        this.theObjects = new Object[n];
        this.theSize = 0;
        this.theCapacityIncrement = n2;
        this.theCapacityMultiplier = d;
    }

    public final void addElement(Object object) {
        if (this.theSize == this.theObjects.length) {
            Object[] objectArray = new Object[(int)this.theCapacityMultiplier * (this.theObjects.length + this.theCapacityIncrement)];
            System.arraycopy(this.theObjects, 0, objectArray, 0, this.theSize);
            this.theObjects = objectArray;
        }
        this.theObjects[this.theSize] = object;
        ++this.theSize;
    }

    public final int capacity() {
        return this.theObjects.length;
    }

    public final Object copy() {
        FastVector fastVector = new FastVector(this.theObjects.length, this.theCapacityIncrement, this.theCapacityMultiplier);
        fastVector.theSize = this.theSize;
        System.arraycopy(this.theObjects, 0, fastVector.theObjects, 0, this.theSize);
        return fastVector;
    }

    public final Object copyElements() {
        FastVector fastVector = new FastVector(this.theObjects.length, this.theCapacityIncrement, this.theCapacityMultiplier);
        fastVector.theSize = this.theSize;
        int n = 0;
        while (n < this.theSize) {
            fastVector.theObjects[n] = ((Copyable)this.theObjects[n]).copy();
            ++n;
        }
        return fastVector;
    }

    public final Object elementAt(int n) {
        return this.theObjects[n];
    }

    public final Enumeration elements() {
        return new FastVectorEnumeration(this);
    }

    public final Enumeration elements(int n) {
        return new FastVectorEnumeration(this, n);
    }

    public final Object firstElement() {
        return this.theObjects[0];
    }

    public final int indexOf(Object object) {
        int n = 0;
        while (n < this.theSize) {
            if (object.equals(this.theObjects[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final void insertElementAt(Object object, int n) {
        if (this.theSize < this.theObjects.length) {
            int n2 = this.theSize - 1;
            while (n2 >= n) {
                this.theObjects[n2 + 1] = this.theObjects[n2];
                --n2;
            }
            this.theObjects[n] = object;
        } else {
            Object[] objectArray = new Object[(int)this.theCapacityMultiplier * (this.theObjects.length + this.theCapacityIncrement)];
            System.arraycopy(this.theObjects, 0, objectArray, 0, n);
            objectArray[n] = object;
            System.arraycopy(this.theObjects, n, objectArray, n + 1, this.theSize - n);
            this.theObjects = objectArray;
        }
        ++this.theSize;
    }

    public final Object lastElement() {
        return this.theObjects[this.theSize - 1];
    }

    public final void removeElementAt(int n) {
        Object[] objectArray = new Object[this.theObjects.length];
        System.arraycopy(this.theObjects, 0, objectArray, 0, n);
        System.arraycopy(this.theObjects, n + 1, objectArray, n, this.theObjects.length - (n + 1));
        this.theObjects = objectArray;
        --this.theSize;
    }

    public final void removeAllElements() {
        this.theObjects = new Object[this.theObjects.length];
        this.theSize = 0;
    }

    public final void setCapacity(int n) {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.theObjects, 0, objectArray, 0, n);
        this.theObjects = objectArray;
        if (this.theObjects.length < this.theSize) {
            this.theSize = this.theObjects.length;
        }
    }

    public final void setElementAt(Object object, int n) {
        this.theObjects[n] = object;
    }

    public final int size() {
        return this.theSize;
    }

    public final void swap(int n, int n2) {
        Object object = this.theObjects[n];
        this.theObjects[n] = this.theObjects[n2];
        this.theObjects[n2] = object;
    }

    public final void trimToSize() {
        Object[] objectArray = new Object[this.theSize];
        System.arraycopy(this.theObjects, 0, objectArray, 0, this.theSize);
        this.theObjects = objectArray;
    }

    public class FastVectorEnumeration
    implements Enumeration {
        private int theCounter;
        private FastVector theVector;
        private int theSpecialElement;

        public FastVectorEnumeration(FastVector fastVector2) {
            FastVector.this = FastVector.this;
            this.theCounter = 0;
            this.theVector = fastVector2;
            this.theSpecialElement = -1;
        }

        public FastVectorEnumeration(FastVector fastVector2, int n) {
            FastVector.this = FastVector.this;
            this.theVector = fastVector2;
            this.theSpecialElement = n;
            if (n == 0) {
                this.theCounter = 1;
                return;
            }
            this.theCounter = 0;
        }

        public final boolean hasMoreElements() {
            return this.theCounter < this.theVector.size();
        }

        public final Object nextElement() {
            Object object = this.theVector.elementAt(this.theCounter);
            ++this.theCounter;
            if (this.theCounter == this.theSpecialElement) {
                ++this.theCounter;
            }
            return object;
        }
    }
}

