/*
 * Decompiled with CFR 0.152.
 */
package jaws.classifierPackage;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import jaws.corePackage.Instance;
import jaws.corePackage.Instances;
import jaws.corePackage.Utils;
import jaws.evaluationPackage.Classifier;
import jaws.evaluationPackage.DistributionClassifier;
import jaws.evaluationPackage.Evaluation;
import jaws.evaluationPackage.Option;
import jaws.evaluationPackage.OptionHandler;

public class BaggingWithResampling
extends DistributionClassifier
implements OptionHandler {
    private Classifier[] theClassifiers = null;
    private Random theRandomInstance = new Random();
    private int theNumIterations = 10;
    private int theSeed = -1;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tNumber of bagging iterations.\n\t(default 10)", "I", 1, "-I"));
        vector.addElement(new Option("\tFull name of scheme to bag.\n\teg: jaws.classifierPackage.NaiveBayes", "W", 1, "-W"));
        vector.addElement(new Option("\tSeed for random number generator.", "S", 1, "-S"));
        if (this.theClassifiers != null && this.theClassifiers[0] instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to scheme " + this.theClassifiers[0].getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.theClassifiers[0])).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void parseOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A scheme must be specified with the -W option.");
        }
        String string2 = Utils.getOption('I', stringArray);
        if (string2.length() != 0) {
            this.setNumIterations(Integer.parseInt(string2));
        }
        this.setScheme(string);
        String string3 = Utils.getOption('S', stringArray);
        if (string3.length() != 0) {
            this.setSeed(Integer.parseInt(string3));
        }
        if (this.theClassifiers != null && this.theClassifiers[0] instanceof OptionHandler) {
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < this.getNumIterations()) {
                stringArray2 = new String[stringArray.length];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                ((OptionHandler)((Object)this.theClassifiers[n])).parseOptions(stringArray2);
                ++n;
            }
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray.length);
        }
    }

    public void setScheme(String string) throws Exception {
        this.theClassifiers = null;
        try {
            this.theClassifiers = new Classifier[this.getNumIterations()];
            int n = 0;
            while (n < this.getNumIterations()) {
                this.theClassifiers[n] = (Classifier)Class.forName(string).newInstance();
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            throw new Exception("Can't find Classifier with class name: " + string);
        }
    }

    public String getScheme() {
        if (this.theClassifiers == null) {
            return null;
        }
        return this.theClassifiers[0].getClass().getName();
    }

    public void setNumIterations(int n) {
        this.theNumIterations = n;
    }

    public int getNumIterations() {
        return this.theNumIterations;
    }

    public void setSeed(int n) {
        this.theSeed = n;
        this.theRandomInstance.setSeed(n);
    }

    public int getSeed() {
        return this.theSeed;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n = 0;
        while (n < this.theClassifiers.length) {
            Instances instances2 = new Instances(instances, instances.numInstances());
            while (instances2.numInstances() < instances.numInstances()) {
                int n2 = (int)(this.theRandomInstance.nextDouble() * (double)instances.numInstances());
                instances2.add(instances.instance(n2));
            }
            this.theClassifiers[n].buildClassifier(instances2);
            ++n;
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        return Utils.maxIndex(this.distributionForInstance(instance));
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        int n = 0;
        while (n < this.theNumIterations) {
            if (this.theClassifiers[n] instanceof DistributionClassifier) {
                double[] dArray2 = ((DistributionClassifier)this.theClassifiers[n]).distributionForInstance(instance);
                int n2 = 0;
                while (n2 < dArray2.length) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + dArray2[n2];
                    ++n2;
                }
            } else {
                int n4 = (int)this.theClassifiers[n].classifyInstance(instance);
                dArray[n4] = dArray[n4] + 1.0;
            }
            ++n;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("All the base classifiers: \n\n");
        int n = 0;
        while (n < this.theClassifiers.length) {
            stringBuffer.append(String.valueOf(this.theClassifiers[n].toString()) + "\n\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new BaggingWithResampling(), stringArray));
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }
}

