;  ###----------------------------------------------------------------###
;  #									#
;  # file	: exc001.s						#
;  # date	: Apr  1 1993						#
;  # descr.	: functional test for dlx				#
;  #									#
;  ###----------------------------------------------------------------###

	;  ###--------------------------------------------------------###
	;  #   exceptions :						#
	;  #     - data address miss alignment (when storing a word)	#
	;  ###--------------------------------------------------------###

adr		equ	X"80000051"
data		equ	X"9043ad6b"
da_viol		equ	X"00000400"

bad		equ	X"7ffffff8"
good		equ	X"7ffffff0"

		org	X"ffffff00"
		start	init_sys

init_sys :
		loadi	r30, good
		loadi	r31, bad

		loadi	r1 , adr		; word's address in r1
		loadi	r2 , adr & X"fffffffc"	; aligned address in r2

		loadi	r3 , data		; a data in r3
		loadi	r4 , data ^ X"ffffffff"	; data inverted in r4

		sw	r3 , r2 , 0		; init the storage at adr
		sw	r4 , r1 , 0		; EXCEPTION (alignment)

		lw	r5 , r2 , 0		; check that the sw has failed
		seq	r11, r5, r3
		beqz	r11, goto_bad
		jr	r30			; jump to good

handler_body :
		loadi	r21, da_viol

		movs2i	r20, sr			; check the exception cause
		andi	r20, r20, X"ffff"	; mask high order bits of sr
		seq	r22, r20, r21
		bnez	r22, return		; excep. caused by dav : return
goto_bad	jr	r31			; jump to bad

return :
		rfe
		nop

		org	X"fffffff0"
exc_handler :
		j	handler_body

		end
